Module Timer;

Exports

Procedure StartTimeout (Seconds: Integer);

Function Timeout: Boolean;

Private

Imports GetTimeStamp from GetTimeStamp;

Var     ToSec, ToMin, ToHour, ToDay, ToMonth, ToYear: Integer;
        InstantReturn: Boolean;

Procedure StartTimeout (Seconds: Integer);

        Var     Time: TimeStamp;
                DaysinMonth: Integer;

        Begin
        InstantReturn := Seconds < 1;
        if InstantReturn then Exit (StartTimeout);
        GetTStamp (Time);
        with Time do
            begin
            ToSec := Second;
            ToMin := Minute;
            ToHour := Hour;
            ToDay := Day;
            ToMonth := Month;
            ToYear := Year;
            end;
        ToSec := ToSec + Seconds;
        if ToSec >= 60 then
            begin
            ToMin := ToMin + ToSec div 60;
            ToSec := ToSec mod 60;
            if ToMin >= 60 then
                begin
                ToHour := ToHour + ToMin div 60;
                ToMin := ToMin mod 60;
                if ToHour >= 24 then
                    begin
                    ToDay := ToDay + ToHour div 24;
                    ToHour := ToHour mod 24;
                    Case ToMonth of
                        1, 3, 5, 7, 8, 10, 12: DaysinMonth := 31;
                        4, 6, 9, 11: DaysinMonth := 30;
                        2: if (ToYear mod 4 = 0) and (ToYear <> 20)
                                then DaysinMonth := 29
                                else DaysinMonth := 28;
                        end;
                    if ToDay > DaysinMonth then
                        begin
                        ToMonth := ToMonth + (ToDay - 1) div DaysinMonth;
                        ToDay := (ToDay - 1) mod DaysinMonth + 1;
                        if ToMonth > 12 then
                            begin
                            ToYear := ToYear + (ToMonth - 1) div 12;
                            ToMonth := (ToMonth - 1) mod 12 + 1;
                            InstantReturn := ToYear > 63;
                            end;
                        end;
                    end;
                end;
            end;
        End;

Function Timeout: Boolean;

        Var     Time: TimeStamp;

        Begin
        if InstantReturn then
            begin
            Timeout := True;
            Exit (Timeout);
            end;
        GetTStamp (Time);
        with Time do
            begin
            if Year > ToYear then Timeout := True
            else if Year < ToYear then Timeout := False
            else if Month > ToMonth then Timeout := True
            else if Month < ToMonth then Timeout := False
            else if Day > ToDay then Timeout := True
            else if Day < ToDay then Timeout := False
            else if Hour > ToHour then Timeout := True
            else if Hour < ToHour then Timeout := False
            else if Minute > ToMin then Timeout := True
            else if Minute < ToMin then Timeout := False
            else Timeout := Second >= ToSec;
            end;
        End.
