Module E2Low;



Exports



Imports Ether10IO from Ether10IO;  { this will be made private someday }



Type    E2Who = Pointer;

        E2CnRes = (E2ConnA, E2ConnB, E2NoReply, E2Busy);

                { E2ConnA means I asked to connect to him first;

                { E2ConnB means he asked to connect to me first. }

        E2Group = 1 .. 255;



Procedure E2Init (Myname: String);

{ initialize this package; Myname is the symbolic name of this machine }



Procedure E2AddGroup (Group: E2Group);

{ add a group to the list of groups you will receive from }



Procedure E2RmvGroup (Group: E2Group);

{ remove a group from the list of groups you will receive from }



Function E2Connect (Who: String; Var Result: E2CnRes; Retries: Integer): E2Who;

{ open a connection to a particular other machine, by symbolic name.

{ Result is E2ConnA or E2ConnB if connection succeeds; result on the other

{ machine is the opposite. }



Function E2Disconnect (Who: E2Who): Boolean;

{ close a connection to some other machine }



Procedure E2GetSendBuffer (Buffer: Pointer);

{ sets buffer to point to a buffer; fill it with data and then call E2SendW }



Function E2SendW (Who: E2Who; NumBytes, Retries: Integer): Boolean;

{ actually send a packet }



Procedure E2RecvHandler (stat: pEtherStatus);  { this will go away someday }

{ user's program must handle ERecvDone and just call this subroutine }



Exception E2Receive (WhoFrom: E2Who; Data: Pointer; NumBytes: Integer);

{ raised when a packet is received }



Private



Imports EBuffer from EBuffer;

Imports EGroup from EGroup;

Imports ELowSends from ELowSends;



{ Here is stuff for keeping track of connections }



Type    pConnectRec = ^ConnectRec;

        ConnectRec = Record

                IsFree: Boolean;

                HisName: String;

                HisAddr: EtherAddress;

                IDtoHim, IDtoMe: Integer;

                NextConnRec: pConnectRec;

                End;



        WhoConnect = Record Case Boolean of

                True:  (W: E2Who);

                False: (C: pConnectRec);

                End;



Var     ConnList: pConnectRec;



{ The Type of a Connect Request Packet }



Type    ConReqPacket = Record

                ToName, FromName: String;

                End;



{ Here are all the buffers that we pass to E10IO }



Var     SendBuf,  AckBuf,  RecBuf1,  RecBuf2:  pEtherBuffer;

        SendHead, AckHead, RecHead1, RecHead2: pEtherHeader;

        SendStat, AckStat, RecStat1, RecStat2: pEtherStatus;

        Address: pEtherAdRec;



        MySymbName: String;

        MyAddress: EtherAddress;

        ConnGrpAddr: EtherAddress;  { address of group for connect requests }



{ Here are constants for different packet types etc. }



Const   MCConnect   = 0;         { group # for multicast connect request }



        ConnReq     = 1;         { request for connection }

        ConnGrant   = 2;         { connection granted }

        ConnDeny    = 3;         { connection request denied }

        Disconnect  = 4;         { close connection }

        Acknowledge = 5;         { acknowledge a data packet }

        NegAck      = 6;         { received garbled data packet }

        Data        = 7;         { data packet }



        AckSize     = MinDataBytes;

        OverHead    = 4 * WordSize (Integer);

        ConnSize    = 2 * WordSize (ConReqPacket);

{$ifc ConnSize < MinDataBytes then}

{$message Size of Connect Packet is too small. }

End.

{$endc}



{ Now for some state }



Var     RcvConAct: (Ignore, WaitFor, JustRcvd);

        RcvConRGD: (Request, Grant, Deny);  { valid when RcvConAct = JustRcvd }

        RcvConFrom: EtherAddress;           { " }

        RcvConSymb: String;                 { " }



        SendInUse: Boolean;                 { valid always }



{ This type def is handy for avoiding recasts }



Type    PntrCnv = Record Case Integer of

                0: (Segment: Integer;

                    Offset:  Integer);

                1: (P:  Pointer);

                2: (AP: AlignedPointer);

                3: (ES: pEtherStatus);

                4: (EH: pEtherHeader);

                5: (EB: pEtherBuffer);

                6: (EA: pEtherAdRec);

                7: (CR: ^ConReqPacket);

                End;



Function FindWho (EAddr: EtherAddress): pConnectRec;



        Var     cr: pConnectRec;

                Found: Boolean;



        Begin

        if ConnList = nil

            then FindWho := nil

            else begin

                cr := ConnList;

                Found := False;

                while (cr^ . NextConnRec <> nil) and not Found do

                    if (cr^ . HisAddr . High = EAddr . High)

                                and (cr^ . HisAddr . Mid = EAddr . Mid)

                                and (cr^ . HisAddr . Low = EAddr . Low)

                        then Found := True

                        else cr := cr^ . NextConnRec;

                if Found

                    then FindWho := cr

                    else FindWho := nil;

                end;

        End;



Procedure E2Init (Myname: String);



        { We need four ethernet buffers:  two for receiving (we use double

        { buffering), one for sending user's data packets, and one for

        { sending acknowledgements.

        { }



        Const   NumBuffers = 4;



        Begin

        EB_Alloc (4, Address);

        EB_Buffers (SendHead, SendBuf, SendStat);

        EB_Buffers (AckHead, AckBuf, AckStat);

        EB_Buffers (RecHead1, RecBuf1, RecStat1);

        EB_Buffers (RecHead2, RecBuf2, RecStat2);

{

        if RecHead2 = nil then

            terrible problems!

}



        MySymbName := MyName;

        E10Init;

        MyAddress := E10GetAdr;

        InitGroup (MyAddress, Address);

        E10Reset (Address);



        SendInUse := False;     { we are not in the middle of a send }

        RcvConAct := Ignore;    { ignore incoming connect requests }

        ConnList := nil;        { not connected to anyone yet }

        ELS_Init (5, 12);       { timeout in 5 sec, try again 12 times }

        End;



Procedure NewReceive;



        Begin

        E10Reset (Address);

        E10IO (EReceive, RecHead1, RecBuf1, RecStat1, MaxDataBytes);

        E10IO (EReceive, RecHead2, RecBuf2, RecStat2, MaxDataBytes);

        End;



Procedure E2AddGroup (Group: E2Group);



        Begin

        AddGroup (Group, Address);

        NewReceive;

        End;



Procedure E2RmvGroup (Group: E2Group);



        Begin

        RmvGroup (Group, Address);

        NewReceive;

        End;



Procedure SendAck (ToWhom: EtherAddress; PackID, PackType: Integer);



        Begin

        with AckHead^ do

            begin

            Dest := ToWhom;

            Src := MyAddress;

            EType := PackType;

            end;

        AckBuf^ [0] := PackID;

        SendNoAck (AckHead, AckBuf, AckStat, AckSize);

        End;



Function E2Connect (Who: String; Var Result: E2CnRes; Retries: Integer): E2Who;



        Var     pc: pConnectRec;

                pcnv: PntrCnv;

                reply: E2CnRes;

                try: Integer;



        Begin

        { check to see if we are already connected }

        pc := ConnList;

        while (pc <> nil) do

            begin

            if pc^ . HisName = Who then  { already connected }

                begin

                result := E2ConnB;

                E2Connect := ReCast (pc, E2Who);

                Exit (E2Connect);

                end;

            pc := pc^ . NextConnRec;

            end;



        { we are not connected, so let's broadcast a connect request }

        { but first, get all ready to recieve once we've sent }

        AddGroup (MCConnect, Address);

        NewReceive;



        { now actually broadcast the request }

        pcnv . EB := SendBuf;

        pcnv . CR^ . ToName := Who;

        pcnv . CR^ . FromName := MySymbName;

        with SendHead^ do

            begin

            Dest := ConnGrpAddr;

            Src := MyAddress;

            EType := ConnReq;

            end;

        reply := E2NoReply;

        try := 0;

        repeat

            try := try + 1;

            SendNoAck (SendHead, SendBuf, SendStat, ConnSize);

            RcvConAct := WaitFor;

            StartTimeout (5);

            repeat

                if RcvConAct = JustRcvd then

                    if RcvConSymb = Who

                        then begin

                            case RcvConRGD of

                                Request: begin

                                    reply := E2ConnA;

                                    { send connect grant }

                                    SendAck (RcvConFrom, 0, ConnGrant);

                                    { wait for acknowledge }

                                    repeat

                                        RcvAckAct := WaitFor;

                                        until

                                            {

                                            (RcvAckPN = Positive) and

                                            (RcvAckFrom = RcvConFrom) and

                                            }

                                            (RcvAckID = 0);

                                    end;

                                Grant: begin

                                    reply := E2ConnB;

                                    SendAck (RcvConFrom, 0, Acknowledge);

                                    end;

                                Deny: begin

                                      reply := E2Busy;

                                    SendAck (RcvConFrom, 0, Acknowledge);

                                    end;

                                end;

                            end

                        else RcvConAct := WaitFor;

                until Timeout or (RcvConAct <> WaitFor);

            RcvConAct := Ignore;

            until (reply <> E2NoReply) or (try > Retries);

        

        New (pc);

        pc^ . NextConnRec := ConnList;

        ConnList := pc;

        with pc^ do

            begin

           { IsFree := ???;}

            HisName := Who;

            HisAddr := RcvConFrom;

            IDtoHim := 0;

            IDtoMe := 0;

            end;

        End;



Function E2Disconnect (Who: E2Who): Boolean;



        Begin

        End;



Procedure E2GetSendBuffer (Buffer: Pointer);



        Var     pcnv: PntrCnv;



        Begin

        if SendInUse

            then Buffer := nil

            else with pcnv do

                begin

                SendInUse := True;

                EB := SendBuf;

                Offset := Offset + OverHead;   { overhead for data packet }

                Buffer := P;

                end;

        End;



Function E2SendW (Who: E2Who; NumBytes, Retries: Integer): Boolean;



        Var     ToWho: WhoConnect;

                Err: SWA_Type;



        Begin

        if not SendInUse then

            begin

            E2SendW := False;

            Exit (E2SendW);

            end;

        ToWho . W := Who;

        SendBuf^ [0] := ToWho . C^ . IDtoHim;

        SendBuf^ [1] := NumBytes;

        NumBytes := NumBytes + OverHead;   { overhead for data packet }

        if NumBytes < MinDataBytes then NumBytes := MinDataBytes;

        if NumBytes > MaxDataBytes then NumBytes := MaxDataBytes;

        with SendHead^ do

            begin

            Dest := ToWho . C^ . HisAddr;

            Src := MyAddress;

            EType := Data;

            end;

        Err := SendWAck (SendHead, SendBuf, SendStat, NumBytes, SendBuf^ [0]);

        E2SendW := Err = SWA_Received;

        if Err = SWA_Received then

            with ToWho . C^ do

                IDtoHim := IDtoHim + 1;

        SendInUse := False;

        End;



Procedure E2RecvHandler (stat: pEtherStatus);



        Var     buf: PntrCnv;

                head: pEtherHeader;

                NumBytes, BytesRecvd: Integer;

                WhoFrom: WhoConnect;



        Procedure IgnoreThis;



                Begin

                E10IO (EReceive, head, buf  . EB, stat, MaxDataBytes);

                Exit (E2RecvHandler);

                End;



        Handler E10DByteError;



                Begin

                IgnoreThis;

                End;

                

        Begin

        if stat = RecStat1

            then begin

                buf . EB := RecBuf1;

                head := RecHead1;

                end

            else begin

                buf . EB := RecBuf2;

                head := RecHead2;

                end;

        BytesRecvd := E10DataBytes (stat^ . BitsRecv);



        Case head^ . EType of

            ConnReq, ConnGrant, ConnDeny: begin

                if RcvConAct <> WaitFor then IgnoreThis;

                if BytesRecvd <> ConnSize then IgnoreThis;

                if buf . CR^ . ToName <> MySymbName then IgnoreThis;

                Case head^ . EType of

                    ConnReq:   RcvConRGD := Request;

                    ConnGrant: RcvConRGD := Grant;

                    ConnDeny:  RcvConRGD := Deny;

                    end;

                RcvConFrom := head^ . Src;

                RcvConSymb := buf . CR^ . FromName;

                RcvConAct := JustRcvd;

                end;



            Disconnect: begin

                end;



            AckNowledge, NegAck: begin

                if BytesRecvd <> AckSize then IgnoreThis;

                with head^ do

                    ELS_Receive (Src, buf . EB^ [0], EType = Acknowledge);

                end;



            Data: begin

                with WhoFrom do

                    begin

                    C := FindWho (head^ . Src);

                    if C = nil then IgnoreThis;

                    if buf . EB^ [0] <> C^ . IDtoMe

                        then IgnoreThis;

                    NumBytes := buf . EB^ [1];

                    with C^ do

                        IDtoMe := IDtoMe + 1;

                    { Probably not a good idea to acknowledge already }

                    SendAck (head^ . Src, buf . EB^ [0], Acknowledge);

                    buf . Offset := buf . Offset + OverHead;

                    Raise E2Receive (W, buf . P, NumBytes);

                    end;

                end;

            Otherwise: begin

                end;

            End;

        E10IO (EReceive, head, buf  . EB, stat, MaxDataBytes);

        End.

