Program Pente;

Imports PenteIO from PenteIO;
Imports Rand from :user>bl>misc>rand;

CONST
    MT = 0;
    OO = 1;
    XX = 2;
    ED = 3;

Var
    board: IOBoardType;

TYPE
    fastboard = array [0..32*(19+1)] of integer;
    movetype = record
        row : integer;
        col : integer;
    END;

VAR
    bo : fastboard;


PROCEDURE InitGame ;
VAR
    i, j : integer;
BEGIN
    for i := 1 to SIZE do for j := 1 to SIZE do board[i, j] := EMPTY;
    board[10, 10] := BLACK;
    DispBoard (board);
    
{    for i := 0 to 32*(19+1) do bo[i] := ED;
    for i := 0 to 18 do for j := 0 to 18 do BEGIN
        bo[SHIFT (i, 5)+j] := MT;
    END;
    bo[SHIFT(9, 5)+9] := OO;}
END;


FUNCTION winsgame (who : adversary; board : fastboard) : boolean;
VAR
    i, j : integer;
BEGIN
    winsgame := FALSE;
END;

FUNCTION getmove (player : Adversary) : movetype;
LABEL
    1111;
VAR
    io : iomove;
BEGIN
  1111: ;
    io := GetPlayersMove (player);
    if (board[io.row, io.col] <> EMPTY) then goto 1111;
    getmove.row := io.row;
    getmove.col := io.col;
END;

PROCEDURE makemove (move : movetype; onmove : adversary);
BEGIN
    board[move.row, move.col] := onmove;
    dispboard (board);
END;

PROCEDURE PlayGame ;
VAR
    i, j : integer;
    isablank : boolean;
    xxwins, oowins : boolean;
    onmove : Adversary;
    move : movetype;
BEGIN
    InitGame ;
    onmove := WHITE;
    while (TRUE) do BEGIN
        { is the game a draw ?? == is no blank and is no win }
        isablank := FALSE;
        for i := 1 to 19 do for j := 1 to SIZE do BEGIN
            if (board[i, j] = EMPTY) then isablank := TRUE;
        END; 
        if (isablank = FALSE) then BEGIN
            writeln ('It was a draw');
            exit (playgame);
        END;
        xxwins := winsgame (BLACK, bo);
        oowins := winsgame (WHITE, bo);
        if (xxwins OR oowins) then BEGIN
            writeln ('Game Over');
            exit (playgame);
        END;
        move := getmove (onmove);
        makemove (move, onmove);
        if (onmove = WHITE) then onmove := BLACK
        else if (onmove = BLACK) then onmove := WHITE
        else writeln ('???');
    END;
END;


Begin

InitRandom ;

BeginPenteIO;
InitBoard (true); { true means make a window for diagnostic display }

writeln ('White is ', RECAST (White, Integer):1);
writeln ('Black is ', RECAST (Black, Integer):1);
writeln ('Empty is ', RECAST (Empty, Integer):1);

PlayGame ;

EndPenteIO;
End.
