{ Simple timing routines }
{ COPYRIGHT (C) BRUCE LADENDORF 1982 }
module tick;
EXPORTS

PROCEDURE TickInit ;
PROCEDURE TickAddString (num : integer; str : string);
PROCEDURE TickResetTime ;
PROCEDURE Tick (num : integer);
FUNCTION TickJiffies : Long;
PROCEDURE TickReport (VAR outchan : text);
PROCEDURE TickToScreen ;

{********************} PRIVATE {********************}

imports PasLong from PasLong;
imports IO_Others from IO_Others;
imports Arith from Arith;

CONST
    MAXENTRIES = 50;

TYPE
    timerec = record
        case integer of
            1: (l : long);
            2: (lsw : integer; msw : integer)
        end;

VAR
    entrystring : array [0..MAXENTRIES] of string[30];
    entrycount : array [0..MAXENTRIES] of long;
    entrytime : array [0..MAXENTRIES] of timerec;
    oldtime : double;

PROCEDURE TickInit ;
VAR
    i : integer;
BEGIN
    FOR i := 0 to MAXENTRIES do begin
        entrycount[i] := -1;
        entrystring[i] := 'NO LABEL';
        entrytime[i].l := 0;
    end;
    entrystring[0] := 'GARBAGE';
    IOGetTime (oldtime);
END;

PROCEDURE TickAddString (num : integer; str : string);
BEGIN
    if ((num >= 0) and (num <= MAXENTRIES)) then
        entrystring[num] := str;
END;

PROCEDURE TickResetTime ;
BEGIN
    IOGetTime (oldtime);
END;

FUNCTION MYRECAST (dub : double) : long;
VAR
    answer : TimeRec;
BEGIN
    answer.lsw := dub[0];
    answer.msw := dub[1];
    MYRECAST := answer.l;
END;

PROCEDURE Tick (num : integer);
VAR
    presenttime : double;
    longtemp : long;
BEGIN
    IOGetTime (presenttime);
    if ((num < 1) or (num > MAXENTRIES)) then num := 0;
    entrycount[num] := entrycount[num] + 1;
    longtemp := MYRECAST (oldtime);
    longtemp := MYRECAST (presenttime) - longtemp;
    longtemp := entrytime[num].l + longtemp;
    entrytime[num].l := longtemp;
    IOGetTime (oldtime);
END;

FUNCTION TickJiffies : Long;
VAR
    presenttime : double;
    longtemp : long;
BEGIN
    IOGetTime (presenttime);
    longtemp := MYRECAST (oldtime);
    longtemp := MYRECAST (presenttime) - longtemp;
    TickJiffies := longtemp;
    IOGetTime (oldtime);
END;

PROCEDURE TickToScreen ;
VAR
    i : integer;
    bigs, secs, ticks : integer;
BEGIN
    for i := 0 to MAXENTRIES do begin
        if (entrycount[i] > -1) then begin
            write (entrystring[i]:10);
            write (entrycount[i]+1 : 7);
            bigs  := entrytime[i].msw;
            secs  := entrytime[i].lsw DIV 60;
            ticks := entrytime[i].lsw MOD 60;

            if (bigs <> 0) then write (bigs:2, ',')
            else write ('   ');
            write (secs : 5);
            write (':');
            if (ticks < 10) then write ('0');
            write (ticks : 1, ' secs');
            write (entrytime[i].l:1, ' jiffies');
            writeln ;
        end;
    end;
end;

PROCEDURE TickReport (VAR outchan : text);
VAR
    i : integer;
    bigs, secs, ticks : integer;
BEGIN
    for i := 0 to MAXENTRIES do begin
        if (entrycount[i] > -1) then begin
            write (outchan, entrystring[i]:10);
            write (outchan, entrycount[i]+1 : 7);
            bigs  := entrytime[i].msw;
            secs  := entrytime[i].lsw DIV 60;
            ticks := entrytime[i].lsw MOD 60;

            if (bigs <> 0) then write (outchan, bigs:2, ',')
            else write (outchan, '   ');
            write (outchan, secs : 5);
            write (outchan, ':');
            if (ticks < 10) then write (outchan, '0');
            write (outchan, ticks : 1, ' secs');
            write (outchan, entrytime[i].l:1, ' jiffies');
            writeln (outchan);
        end;
    end;
end.
{}
