program tempest ;
{ COPYRIGHT (C) 1982 BRUCE LADENDORF }
EXPORTS {****************************************************************}

CONST
    NUMNODES = 41;
    LOWNODES = 0;
    HIGHNODES = LOWNODES + NUMNODES - 1;
    
    NUMLINKS = 75;
    LOWLINKS = 0;
    HIGHLINKS = LOWLINKS + NUMLINKS - 1;
    
    STARTNODE = 0;
    FINISHNODE = 40;

    NONE = 0;
    YELLOW = 1;
    GREEN = 2;
    RED = 4;
    PURPLE = 8;
    ALL = YELLOW + GREEN + RED + PURPLE;

    BOGUSNODE = LOWNODES-1;
    BOGUSLINK = LOWLINKS-1;

    PRODUCTION = TRUE;

TYPE
    PathType = record
        path : array [1..NUMLINKS+1] of integer;
        numinpath : integer;
    end;
{    smallStatetype = record 
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
        lostpoints : integer;
        linkused : integer;
        nextnode : integer;
    end;}
    StateType = record
        linkfree : array [LOWLINKS..HIGHLINKS] of boolean;
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
    end;
    SubGraph = array [LOWLINKS..HIGHLINKS] of boolean;
        { TRUE ifof the link is included in the subgraph }
VAR
    { description of complete graph }
    ValOfNode : array [LOWNODES..HIGHNODES] of integer;
    ColorOfNode : array [LOWNODES..HIGHNODES] of integer;
    hasflag : array [LOWLINKS..HIGHLINKS] of integer;
        { 1 if has flag else 0 }
    smallend, bigend : array [LOWLINKS..HIGHLINKS] of integer;

    { auxillary data that are subgraph independent }
    Lon, Loff : array [LOWNODES..HIGHNODES] of integer;
    numlightson : array [0..7] of integer;

    { data that are for the current subgraph }
    GetThereFromHere : 
        array [LOWNODES..HIGHNODES, LOWNODES..HIGHNODES] of integer;
    linksfrom, tonode : array [LOWNODES..HIGHNODES, 1..8] of integer;
    nlinksfrom : array [LOWNODES..HIGHNODES] of integer;
    maxvisits : array [LOWNODES..HIGHNODES] of integer;

    assumesg, stdsubgraph : subgraph;
    sgmaxflags : integer;
    
PROCEDURE CompleteSearch (Threshold : integer);

PRIVATE {****************************************************************}
IMPORTS T5Sub FROM T5Sub ;

{$IFC PRODUCTION THEN}
    {$RANGE-}
{$ENDC}

VAR
    { data for the complete search routine }
    globlightson : array [1..NUMLINKS] of integer;
    globscore : array [1..NUMLINKS] of integer;
    globnumflags : array [1..NUMLINKS] of integer;
    globcurnode : array [1..NUMLINKS] of integer;
    globlinks : array [LOWLINKS..HIGHLINKS] of boolean; 
        { TRUE ifof link is available for use }

    { search variables for new complete search }
    { at 2222, all arrays and variables are valid for 1..curdepth-1,
        except nexnode[curdepth] }
    curdepth : integer;
    nextnode : array [1..NUMLINKS] of integer;
    linkused : array [1..NUMLINKS] of integer;
    lostpoints : array [1..NUMLINKS] of integer;
    numvisits : array [LOWNODES..HIGHNODES] of integer;
    flagstoget : array [1..NUMLINKS] of integer;
    totlostpoints : integer;
    Numbumpers : integer;
    nodelastuse : array [LOWNODES..HIGHNODES] of integer;
    nodesbackup : array [LOWNODES..HIGHNODES, 1..4] of integer;
    nodenumbackup : array [LOWNODES..HIGHNODES] of integer;
    badnews : array [0..NUMLINKS] of integer;
    bndepth : integer;
    remaininglinks : array [LOWNODES..HIGHNODES] of integer;
    losingnode, losinglink : array [1..NUMLINKS] of integer;

    { misc vars for complete search }
    pointThreshold : integer;
    compath : pathtype;

    fds, flp : integer;
    thisnode, foonode, foolink : integer;

{$IFC PRODUCTION THEN}
VAR
    i, j, tempnext, newnode, bestscore, lastuse : integer;
    upperlimit : integer;
    thisdepth, otherdepth : integer;
    isbadnews : boolean;
    nodecount : long;
    ch : char;
    maxbumpers : integer;
    temp28, temp31 : integer;
{$ENDC}


FUNCTION FasterDeltaScore (node : integer) : integer;
BEGIN
    if ((node = 18) or (node = 23)) then BEGIN
        FasterDeltaScore := 10 * globnumflags[curdepth];
        Exit (FasterDeltaScore);
    END;
    
    if (node = 35) then BEGIN
        FasterDeltaScore := 25 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;

    if (node = 37) then BEGIN
        FasterDeltaScore := 50 * numlightson[globlightson[curdepth]];
        Exit (FasterDeltaScore);
    END;
    
    if (LAND (globlightson[curdepth], colorofnode[node]) <> 0) then 
        FasterDeltaScore := SHIFT (valofnode[node], 1)
    else FasterDeltaScore := valofnode[node];
END;

FUNCTION FasterLosePoints (node : integer) : integer;
BEGIN
    FasterLosePoints := 0;
    if (LAnd (colorofnode[node], YELLOW+GREEN+RED) > 0) then 
        if (LAND (globlightson[curdepth], colorofnode[node]) = 0) then
            FasterLosePoints := ValOfNode[node];
    if ((node = 18) or (node = 23)) then
{        FasterLosePoints := (4-numbumpers) * (21 - globnumflags[curdepth]);}
        FasterLosePoints := 10 * (sgmaxflags - globnumflags[curdepth]);
    if (node = 35) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*25;
    if (node = 37) then
        FasterLosePoints := (3-numlightson[globlightson[curdepth]])*50;
END;

FUNCTION InUpperBound (sg : subgraph) : integer;
CONST
    VERBOSE = TRUE;
VAR
    totYellow, totGreen, totRed, totPurple : integer;
    i, subtotal, weight :integer;
    flagweight, b25weight, b50weight : integer;
    flags : integer;
BEGIN
    { it is assumed that nlinksfrom represents sg }
    
    flags := 0;
    for i := LOWLINKS to HIGHLINKS do
      if (sg[i]) then
        if (hasflag[i]>0) then
          flags:=flags+1;
    
    totYellow := 0;
    totGreen := 0;
    totRed := 0;
    totPurple := 0;
    for i := LOWNODES to HIGHNODES do begin
        weight := nlinksfrom[i] DIV 2;
        case colorofnode[i] of
            YELLOW: totYellow := totYellow + valofnode[i] * weight;
            GREEN: totGreen := totGreen + valofnode[i] * weight;
            RED: totRed := totRed + valofnode[i] * weight;
            PURPLE: totPurple := TotPurple + valofnode[i] * weight;
            NONE: ;
            otherwise: writeln ('Bad color');
        end;
    end;
    flagweight := (nlinksfrom[18] DIV 2) + (nlinksfrom[23] DIV 2);
    b25weight := nlinksfrom[35] DIV 2;
    b50weight := nlinksfrom[37] DIV 2;
    
    SubTotal := totPurple + 2*(totyellow+totgreen+totred) +
        flags*10*flagweight + 
        3 * 25 * b25weight +
        3 * 50 * b50weight;
    InUpperBound := SubTotal;

    {$IFC VERBOSE THEN}
        writeln ('UPPER BOUND');
        writeln ('TotYellow ', totYellow:1);
        writeln ('TotGreen  ', totGreen:1);
        writeln ('TotRed    ', totRed:1);
        writeln ('TotPurple ', totPurple:1);
        writeln ('Flags     ', flags:1);
        writeln ('FlagWeight  ', flagweight:1);
        writeln ('B25Weight   ', b25weight:1);
        writeln ('B50Weight   ', b50weight:1);
        writeln ('Total     ', SubTotal:1);
    {$ENDC}

END;


PROCEDURE CompleteSearch (Threshold : integer);
LABEL
    2222, 3333, 4444, 5555;
CONST
    VERBOSE = FALSE;
{$IFC NOT PRODUCTION THEN}
VAR
    i, j, tempnext, newnode, bestscore, lastuse : integer;
    upperlimit : integer;
    thisdepth, otherdepth : integer;
    isbadnews : boolean;
    nodecount : long;
    ch : char;
    maxbumpers : integer;
    temp28, temp31 : integer;
{$ENDC}
BEGIN
    { set up temp28 and temp31 }
    for i := 1 to nlinksfrom[28] do if (tonode[28, i] = 27) then BEGIN
        temp28 := i;
        writeln ('Got temp28');
    END;
    for i := 1 to nlinksfrom[31] do if (tonode[31, i] = 38) then BEGIN
        temp31 := i;
        writeln ('Got temp31');
    END;

    { Check that the maxbumpers constant is correct }
{    if (((nlinksfrom[18] DIV 2)+(nlinksfrom[23] DIV 2))
      <> MAXBUMPERS) then BEGIN
        writeln ('Error, CompleteSearch, bad MAXBUMPERS');
        writeln ('Maxvisits[18]=', maxvisits[18]:1,
            ' Maxvisits[23]=', maxvisits[23]:1);
        exit (completesearch);
    END;}
    maxbumpers := maxvisits[23] + maxvisits[18];

    PointThreshold := threshold;

    writeln ('Doing a New Complete Search');
    bestscore := 0;
    nodecount := 0;
    upperlimit := InUpperBound (stdsubgraph);
    {$IFC VERBOSE THEN}
        writeln ('Threshold That is to be used is ', upperlimit:1);
    {$ENDC}
    
    { inits }
    for i := LOWNODES to HIGHNODES do nodenumbackup[i] := 0;
    nodelastuse[0] := 1;
    nodenumbackup[0] := 1;
    bndepth := 0;

    { init from the subgraph stdsubgraph }
    curdepth := 2;
    globlightson[1] := NONE;
    globscore[1] := 0;
    globnumflags[1] := 0;
    globcurnode[1] := STARTNODE;
    for i := LOWLINKS to HIGHLINKS do globlinks[i] := stdsubgraph[i];

    nextnode[1] := 1; { for completeness }
    linkused[1] := 1;
    lostpoints[1] := 0;
    numbumpers := 0;
    totlostpoints := 0;

    flagstoget[1] := sgmaxflags;
    losingnode[1] := BOGUSNODE;
    for i := LOWNODES to HIGHNODES do
        remaininglinks[i] := nlinksfrom[i];

    { start by going deeper }
    nextnode[curdepth] := 0;
    goto 2222;
    
  2222: ; { try next node }
    nodecount := nodecount + 1;
    if (curdepth <= 1) then begin
        writeln ('Threshold was ', pointThreshold:1);
        writeln ('Num Nodes was ', nodecount:1);
        exit (completesearch);
    end;

    {$IFC VERBOSE THEN}
        writeln ;
        writeln ('S T A T E');
        writeln ('CD L SCOR FL CN NN FG LU LPs');
        for i := 1 to curdepth-1 do begin
            write (i:2, ' ',
                globlightson[i]:1, ' ',
                globscore[i]:4, ' ',
                globnumflags[i]:2, ' ',
                globcurnode[i]:2, ' ',
                nextnode[i]:2, ' ', 
                flagstoget[i]:2, ' ',
                linkused[i]:2, ' ',
                lostpoints[i]:3, ' ',
                losingnode[i]:2, ' ',
                losinglink[i]:2, ' ');
            writeln ;
        end;
        writeln ;
        writeln ('NextN NumB TotPts');
        writeln (nextnode[curdepth]:5, ' ', 
            numbumpers:4, ' ',
            Totlostpoints:6);

        for j := LOWNODES to HIGHNODES do write (j mod 10 : 1);
        writeln ;
        for j := LOWNODES to HIGHNODES do write (remaininglinks[j]:1);
        writeln ;

        for j := LOWLINKS to HIGHLINKS do
          if (not globlinks[j]) then
            write (j:1, ' ');
        writeln ;
        for j := 1 to curdepth-1 do
            write (linkused[j]:1, ' ');
        writeln ;
        writeln ;
    {$ENDC}

  {$IFC FALSE THEN}
    writeln ;
    writeln ('NUKE THIS PATH??? [No]');
    if (eoln ) then readln 
    else begin
        readln (ch);
        if (ch = 'y') then goto 3333;
    end;
  {$ENDC}

    if (upperlimit-totlostpoints < pointThreshold) then begin
        { truncate this path because of threshold }
        {$IFC VERBOSE THEN}
            writeln ('THRESHOLD ', upperlimit-totlostpoints);
        {$ENDC}
        goto 3333;
    end;

    tempnext := nextnode[curdepth]+1;
    nextnode[curdepth] := tempnext;
    if (tempnext>nlinksfrom[globcurnode[curdepth-1]]) then begin
        { go up }
        {$IFC VERBOSE THEN}
            writeln (' No more, go up');
        {$ENDC}
      3333: ;
        if ((globcurnode[curdepth-1] = 18)or(globcurnode[curdepth-1]=23)) then 
                numbumpers := numbumpers - 1;
        totlostpoints := totlostpoints - lostpoints[curdepth-1];
        globlinks[linkused[curdepth-1]] := TRUE;
        curdepth := curdepth - 1;

        if (bndepth > 0) then if (badnews[bndepth] >= curdepth) then
            bndepth := bndepth-1;
        nodelastuse[globcurnode[curdepth]] := 
            nodesbackup[globcurnode[curdepth],
              nodenumbackup[globcurnode[curdepth]] ];
        nodenumbackup[globcurnode[curdepth]] := 
            nodenumbackup[globcurnode[curdepth]] - 1;

        remaininglinks[globcurnode[curdepth]] := 
            remaininglinks[globcurnode[curdepth]] + 1;
        if (curdepth > 1) then remaininglinks[globcurnode[curdepth-1]] := 
            remaininglinks[globcurnode[curdepth-1]] + 1;
                { oops, index to globcurnode must be >= 1}
        if (losingnode[curdepth] <> BOGUSNODE) then BEGIN
            globlinks[losinglink[curdepth]] := TRUE;
            foonode := losingnode[curdepth];
            remaininglinks[foonode] := remaininglinks[foonode] + 1;
        END;

        goto 2222;
    end;

  {$IFC TRUE THEN}
    if ((globcurnode[curdepth-1]=28) and (globlinks[55]) and
      (not globlinks[69])) then BEGIN
        {$IFC VERBOSE THEN}
            writeln ('From node 28, forced into loop');
        {$ENDC}
        nextnode[curdepth] := 8;
        tempnext := {3} temp28;
        newnode := tonode[globcurnode[curdepth-1],tempnext];
        {$IFC TRUE THEN}
            if (newnode <> 27) then writeln ('Error, going from 27');
        {$ENDC}
        goto 4444;
    END;
    if ((globcurnode[curdepth-1]=31) and (globlinks[64]) and
      (not globlinks[0])) then BEGIN
        {$IFC VERBOSE THEN}
            writeln ('From node 31, forced into loop');
        {$ENDC}
        nextnode[curdepth] := 8;
        tempnext := {4} temp31;
        newnode := tonode[globcurnode[curdepth-1],tempnext];
        {$IFC TRUE THEN}
            if (newnode <> 38) then writeln ('Error, going from 31');
        {$ENDC}
        goto 4444;
    END;
  {$ENDC}

    {$IFC VERBOSE THEN}
        write (' Trying son ', tonode[globcurnode[curdepth-1],tempnext]:1);
    {$ENDC}
    newnode := tonode[globcurnode[curdepth-1],tempnext];

    if (not globlinks[linksfrom[globcurnode[curdepth-1], tempnext]]) then begin
        { goto next son }
        {$IFC VERBOSE THEN}
            writeln (' Bad Node, skip son');
        {$ENDC}
        goto 2222;
    end;

    if (newnode = FINISHNODE) then begin
        { report score, then go up }
        {$IFC VERBOSE THEN}
            writeln (' Made it',
                ' score ', globscore[curdepth-1]:4);
        {$ENDC}
        if (globscore[curdepth-1] > bestscore) then begin
            writeln ('NEWBEST ', globscore[curdepth-1]:4);
            bestscore := globscore[curdepth-1];
            for i := 1 to curdepth-1 do compath.path[i] := globcurnode[i];
            compath.numinpath := curdepth-1;
            printpath (compath, output);
        end;
        if (globscore[curdepth-1] < pointThreshold) then goto 2222;
        Writeln ('GOT A GREAT SOLUTION!!!!!, score ', globscore[curdepth-1]:1);


        { going up... }
        goto 2222;
    end;

    { Don't go to a son who has only one link }
    if (remaininglinks[newnode] = 1) then BEGIN
        {$IFC VERBOSE THEN}
            writeln (' Only one link out ');
        {$ENDC}
        goto 2222;
    END;

    { go down }
  4444: ;
{    if (Lon[newnode] <> NONE) then
        globlightson[curdepth] := LOR (globLightsOn[curdepth-1], Lon[newnode]);
    if (Loff[newnode] <> ALL) then
        GlobLightsOn[curdepth] :=
            LAnd (GlobLightsOn[curdepth-1], Loff[newnode]);
}
    globlightson[curdepth] := 
        LAND (Loff[newnode], LOR (Lon[newnode], globlightson[curdepth-1]) );
    globcurnode[curdepth] := newnode;
    linkused[curdepth] := linksfrom[globcurnode[curdepth-1], tempnext];
    globnumflags[curdepth] := 
        globnumflags[curdepth-1] + hasflag[linkused[curdepth]];
    globlinks[linkused[curdepth]] := FALSE;

    { do in-line call to FasterLosePoints }
{    lostpoints[curdepth] := FasterLosePoints (newnode);}
    flp := 0;
    if (LAnd (colorofnode[newnode], YELLOW+GREEN+RED) > 0) then 
        if (LAND (globlightson[curdepth], colorofnode[newnode]) = 0) then
            flp := ValOfNode[newnode];
    if (newnode = 35) then
        flp := (3-numlightson[globlightson[curdepth]])*25
    else if (newnode = 37) then
        flp := (3-numlightson[globlightson[curdepth]])*50;
    {$IFC TRUE THEN}
        if (upperlimit-totlostpoints-flp < pointThreshold) then BEGIN
            globlinks[linkused[curdepth]] := TRUE;
                { undo the only real change made so far }
            {$IFC VERBOSE THEN}
                writeln (' Early Truncation');
            {$ENDC}
            goto 2222;
        END;
    {$ENDC}
    flagstoget[curdepth] := flagstoget[curdepth-1];
    thisnode := globcurnode[curdepth-1];
    remaininglinks[newnode] := remaininglinks[newnode] - 1;
    remaininglinks[thisnode] := remaininglinks[thisnode] - 1;
    if (remaininglinks[thisnode] <> 1) then losingnode[curdepth] := BOGUSNODE
    else BEGIN
        for i := nlinksfrom[thisnode] downto 1 do
            if (globlinks[linksfrom[thisnode, i]]) then BEGIN
                foonode := tonode[thisnode, i];
                foolink := linksfrom[thisnode, i];
                goto 5555;
            END;
        writeln ('Error, completesearch, should not get here.');
      5555: ;
        losingnode[curdepth] := foonode;
        losinglink[curdepth] := foolink;
        globlinks[foolink] := FALSE;
        remaininglinks[foonode] := remaininglinks[foonode] - 1;
        if (hasflag[foolink] > 0) then begin
            flp := flp + (MAXBUMPERS - numbumpers) * 10;
            flagstoget[curdepth] := flagstoget[curdepth-1] - 1;
        end;
    END; {else}
    if ((newnode = 18) or (newnode = 23)) then
        flp := 10 * (flagstoget[curdepth] - globnumflags[curdepth]);
    lostpoints[curdepth] := flp;
    
    { do in-line call to fasterDeltaScore }
{    globscore[curdepth]:=globscore[curdepth-1]+FasterDeltaScore(newnode);}
    if ((newnode = 18) or (newnode = 23)) then BEGIN
        fds := 10 * globnumflags[curdepth];
    END
    else if (newnode = 35) then BEGIN
        fds := 25 * numlightson[globlightson[curdepth]];
    END
    else if (newnode = 37) then BEGIN
        fds := 50 * numlightson[globlightson[curdepth]];
    END
    else if (LAND (globlightson[curdepth], colorofnode[newnode]) <> 0) then 
        fds := SHIFT (valofnode[newnode], 1)
    else fds := valofnode[newnode];
    globscore[curdepth] := globscore[curdepth-1] + fds;

    if ((newnode = 18) or (newnode = 23)) then numbumpers := numbumpers+1;
    totlostpoints := totlostpoints + lostpoints[curdepth];
    {$IFC VERBOSE THEN}
        writeln (' OK Go Down, lost ', lostpoints[curdepth]:3);
    {$ENDC}
    curdepth := curdepth + 1;
    nextnode[curdepth] := 0;
    case newnode of
      18,23,35,37,2,3,4,28,31,10,16,13:
        begin
            bndepth := bndepth + 1;
            badnews[bndepth] := curdepth-1;
        end;
    end; {case}
    nodenumbackup[newnode] := nodenumbackup[newnode] + 1;
    nodesbackup[newnode, nodenumbackup[newnode]] := nodelastuse[newnode];
    nodelastuse[newnode] := curdepth-1;
                   
  {$IFC TRUE THEN}
    if (nodenumbackup[globcurnode[curdepth-1]] > 1) then begin
        { consider zapping this path as having a redundant loop }
        {$IFC VERBOSE THEN}
            writeln ('Considering zapping because of loop');
        {$ENDC}
        thisdepth := curdepth-1;
        otherdepth := nodesbackup[globcurnode[curdepth-1], 
            nodenumbackup[globcurnode[curdepth-1]] ];
        if (globcurnode[thisdepth-1] < globcurnode[otherdepth+1]) then begin
            { first step nodes are in order, if no bad news then
              zap path. }
            i := bndepth;
            while (i>0) do BEGIN
                if (badnews[i] < thisdepth) then BEGIN
                    if (badnews[i] <= otherdepth) then goto 3333;
                        { no bad news, so zap }
                    case globcurnode[badnews[i]] of
                      2,3,4,28,31,10,13,16:
                        if (globlightson[badnews[i]] <> 
                            globlightson[badnews[i]-1]) then goto 2222;
                                {bad news, so continue}
                      35,37: ;
                      18,23:
                        if (globnumflags[thisdepth]+globnumflags[otherdepth] >
                          SHIFT (globnumflags[badnews[i]],1)) then goto 2222;
                            {more flags after then before so continue}
                      otherwise: writeln ('Error, CompleteSearch, foo');
                    end; {case}
                END;
                i := i - 1;
            END;

        end; {if}
    end;
  {$ENDC}

    goto 2222;
END;

BEGIN
    { global inits }
    writeln ('Initializing...');
    Initialize ;

    CommandLoop ('T> ', input, output);
END.
