module PaneIcons;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module is the icon management system for the Pane manager.
 *      Icons are created whenever a pane is covered or shrunk too small
 *      to stay on the screen.
 *
 *    -----------
 *    CHANGE LOG:
 *      Aug 16 1984     Lee Iverson     Added RedrawIcons.
 *      Jul 11 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports PaneGlobs from PaneGlobs;

procedure
  GrowIcon(
    iconNum: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Convert an icon back to its full pane view.
 *
 ***********************************************************************)

function
  IconAt(
    x: Integer;
    y: Integer
  ): Integer;
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Return the number of the icon at the position (x,y).  The
 *        value returned if there is no icon at this position is 0.
 *
 ***********************************************************************)

procedure
  Iconize(
    pn: pPane
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Change the given pane from visible state to iconized.
 *
 ***********************************************************************)

procedure
  InitIcons(
    var width: Integer;
    var height: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Initialize the icon manager.
 *
 ***********************************************************************)

procedure
  RedrawIcons;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Redraw the entire icon region.
 *
 ***********************************************************************)

private

{$include PaneIcons.impl}.
