module Browser;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module implements a generalized browser interface.  It is
 *      designed around the pane interface.
 *
 *    -----------
 *    CHANGE LOG:
 *      Aug 13 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports Panes from Panes;

type
  (* A list of strings to be used for selection *)
  pNameList = ^NameList;
  NameList = Array[1..1] of String;

  (* The actual browser structure *)
  pBrowser = ^Browser;
  Browser = record
              pn: Pane;
              width: Integer;
              height: Integer;
              entries: Integer;
              top: Integer;
              entriesShown: Integer;
              names: pNameList;
            end;

exception
  BrowserSelect(
    browse: pBrowser;
    selected: Integer;
    selString: String
  );

function
  CreateBrowser(
    pan: Pane;
    numberOfNames: Integer;
    theNames: pNameList
  ): pBrowser;
  
(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Creates a new browser inside the given pane.  The browser displays
 *      the list of strings stored in the array, theNames.  Returns a
 *      pointer to the browser structure.
 *
 ***********************************************************************)

procedure
  HandleBrowser(
    browse: pBrowser;
    keyEv: PaneEvent
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This is the function which deals with events which are to be
 *      managed by the browser.  It is called by ListenBrowser and may
 *      also be called from outside the Browser module for handling of
 *      one event at a time.
 *
 ***********************************************************************)

procedure
  ListenBrowser(
    browse: pBrowser
  );
  
(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This is the function that must be called by the user when the
 *      browser becomes the listener pane.  It deals with scrolling through
 *      the list of names and selection when that is attempted.
 *
 ***********************************************************************)

procedure
  RedrawBrowser(
    browse: pBrowser
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Redraws the browser.  This should be called if any  of the data
 *      in the name list are changed or a pane exposed exception is
 *      received from the Pane Manager for the browser's home pane.
 *
 ***********************************************************************)

procedure
  ResizeBrowser(
    browse: pBrowser;
    w: Integer;
    h: Integer
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This is the procedure that should be called when the browser's
 *      home pane has been resized.  It is generally called from the
 *      Pane exception handler.
 *
 ***********************************************************************)

private
{$include Browser.impl}.


