module pasmac1;

{++}
{ abstract:	scanning routines
{
{ created:	amy lansky (all@su-ai)
{ date:		31-may-79
{--}

{++}
{ history in pasmac.p
{--}

EXPORTS

{ $R-}

const
   maxidlen = 10;
   filenamelen = 75;
   maxmac = 10000; {24000}
   { dzg - not enough memory with 24000; I'm trying with 10000 }
   { LWE 3/12/80: reduced to 24K for PI Pascal limits }
   (* 10000 for pasmac, 65000 for bigmac *)
   maxchunk = 50;
   maxlinlen = 200;
   maxparno = 15; (* 15 for pasmac, 20 for bigmac *)
   maxtab = 211;
   maxwork = 200;
   maxintexp=20;
   maxpar = 200; (* 200 for pasmac, 800 for bigmac *)
   wasfile=0;
   wasbody=1;

type
   macsort = (mvar,macro);
   mactype = (mstring,mboolean,minteger);
   toktype = (inttok,realtok,identtok,reservetok,commenttok,
              mkwdtok,nulltok,booltok,assigntok,stringtok,nametok,
              lseqtok,greqtok,neqtok,andtok,ortok,modtok,divtok,
              nottok,mequtok,mlstok,squotetok,lparentok,colontok,lesstok,
              grttok,amptok,semitok,commatok,lbracktok,rbracktok,
              rparentok,multtok,plustok,minustok,equaltok,periodtok,
              bangtok,dollartok,percenttok,dividetok,arrowtok,slashtok,
              questtok,attok,bartok,dquotetok);
   mkeytype =(macrotok,massigntok,mbegintok,mbooltok,melsetok,mendtok,mexptok,
              mfitok,miftok,mincludetok,minttok,mstringtok,mthentok,
              mvartok);      
   readplace=(afile,charray,bodyarray);
   putplace =(out,work,line,body,intexp,trfal,chk,nowhere,fnam);
   boolorint=(booltype,inttype);
 
   getplace= work..chk;
   parno   = 0..maxparno;
   macsize = 1..maxmac;
   chunksize=1..maxchunk;
   tabsize = 0..maxtab;
   worksize= 0..maxwork;
   linsize = 0..maxlinlen;
   intexpsize = 1..maxintexp;
   parsize = 1..maxpar;
   errornum = 1..43;

   ident = packed array [1..maxidlen] of char;

 
   bounds = record
                first,last:integer;
            end;
   bndpnt = ^bounds;
 
   tabpnt = ^tabrec;
   tabrec = record
                link:tabpnt;
                name:ident;
                case macflavor:macsort of
                   mvar: (case vartype:mactype of
                              mstring: (strval:bndpnt);
                              mboolean:(boolval:boolean);
                              minteger:(intval:integer)
                          );
                   macro: (numpar:parno;
                           parname: array[parno] of ident;
                           partype: array[parno] of mactype;
                           macbnd: bndpnt
                          )
             end;
 
 
   chunkpnt = ^chunk;
   chunkarr = packed array[chunksize] of char;
   chunk = record
             arr: chunkarr;
             pos:0..maxchunk;
             nxt:chunkpnt;
           end;
   vaxfile = packed array [1..filenamelen] of char;
   mbarray = packed array [macsize] of char;
   mbarrayptr = ^mbarray;


var
   macbodyptr : mbarrayptr;
   workarea:array[worksize] of char;
   intexparea:array[intexpsize] of char;
   mactable:array[tabsize] of tabpnt;
   pararray:array[parsize] of chunkpnt;
   filelin: array[0..8,1..maxlinlen] of char;
   column,linlen:  array[0..8] of linsize;
   inclusion:array[0..30] of integer;
 
   mkeyword:array[1..14] of mkeytype;
   mkeystring:array[1..14] of ident;
   reserve: array[1..30] of ident;
   argfile: vaxfile;
   filnames,file1,file2,file3,file4,file5,file6,file7,file8:
        packed file of char;
   filenum:0..8;
 
   tftemp:packed array[1..9] of char;
   truefalse:array[1..9] of char;
   linebnd,trueword,falseword:bndpnt;

   newtoktype:toktype;
   newtok,blanks:bndpnt;
   newmkeytype:mkeytype;
 
   bodyend:macsize;
   currbodypos,bodyextent:integer;

   dummychunk,globalchunk:chunkpnt;
   currchunkpos:integer;
 
   workend:worksize;

   intexpend:intexpsize;

   currmacpar,parend:parsize;

   currmacro,localmvar:tabpnt;
 
   currplace:readplace;
 
   inctop:integer;

   havelookahead,knowstring,knowcomment,forwardint:boolean;
   haveblanks,macrocalltime,endmac,havetok,dotrace:boolean;
 
   startword:set of mkeytype;
   mactypeword:set of mkeytype;
   reloperators:set of toktype;

   ch:char;
   (* dzg - reintroduced the tty file for error messages *)
   tty, input, output: text;

{++}
{external procedures
{--}

procedure init;

PRIVATE

procedure init;
(* initialization of global variables*)

var  i:integer;
begin
if dotrace then writeln(tty,'init');
new(macbodyptr);
for i := 0 to maxtab do     (*initialize mvar-macro table to nil pointers*)
   mactable[i] := nil;
for i := 1 to maxpar do     (*initialize parameter stack to nil pointers*)
   pararray[i] := nil;
for i := 0 to 8 do          (*initialize column and line lengths to 0 *)
   begin
   column[i] := 0;
   linlen[i] := 0;
   end;

filenum := 0;

new(newtok);                (*create global records for newtok,blanks, and linebnd*)
new(blanks);  
new(linebnd);

tftemp := 'truefalse';      (*create records with the bounds of the global *)
                                        (* substitute the non-std. cmu unpack 
                                        for: unpack(tftemp,truefalse,1);*)

                { LWE 3/11/80: changed CMU format back to standard on unpack}
{   dzg - changed to Perq strings, taking away unpack(tftemp, truefalse, 1); }
(*  'strings' trueword and falseword which  exist
in the character array truefalse*)

for i := 1 to 9 do
  truefalse[i] := tftemp[i];
{ end dzg }
new(trueword);
trueword^.first := 1;
trueword^.last := 4;
new(falseword);
falseword^.first := 5;
falseword^.last := 9;

currbodypos := 1;           (*initialize variables having to do with*)
bodyextent := 1;            (*positions within the arrays macbody,  *)
bodyend := 1;               (*workarea,intexparea,pararray,inclusion,*)
workend := 0;
intexpend := 1;
currmacpar := 1;
parend := 1;
inctop := 0;

localmvar := nil;           (*initialize global pointer to local mvars*)
currmacro := nil;           (*of current macro localmvar,and the pointer*)
                            (*to the current macro currmacro to nil*)

currplace := afile;         (*begin reading from a file*)

havelookahead := false;     (*initialize global switches appropriately*)
knowstring := true;
knowcomment := true;
forwardint := false;
haveblanks := false;
macrocalltime := false;
endmac := false;
havetok := false;

(*initialize special sets appropriately*)
startword := [macrotok,massigntok,miftok,mincludetok,mvartok];
mactypeword := [mbooltok,minttok,mstringtok];
reloperators:= [equaltok,neqtok,lseqtok,greqtok,lesstok,grttok];

(*initialize the names and representative strings of each macro-time keyword*)
mkeyword[1] := macrotok;       mkeystring[1] := 'macro     ';
mkeyword[2] := massigntok;     mkeystring[2] := 'massign   ';
mkeyword[3] := mbegintok;      mkeystring[3] := 'mbegin    ';
mkeyword[4] := mbooltok;    mkeystring[4] := 'mboolean  ';
mkeyword[5] := melsetok;       mkeystring[5] := 'melse     ';
mkeyword[6] := mendtok;        mkeystring[6] := 'mend      ';
mkeyword[7] := mexptok;        mkeystring[7] := 'mexp      ';
mkeyword[8] := mfitok;         mkeystring[8] := 'mfi       ';
mkeyword[9] := miftok;         mkeystring[9] := 'mif       ';
mkeyword[10]:= mincludetok;    mkeystring[10]:= 'minclude  ';
mkeyword[11]:= minttok;    mkeystring[11]:= 'minteger  ';
mkeyword[12]:= mstringtok;     mkeystring[12]:= 'mstring   ';
mkeyword[13]:= mthentok;       mkeystring[13]:= 'mthen     ';
mkeyword[14]:= mvartok;        mkeystring[14]:= 'mvar      ';

(*initialize the array containing the strings representing pascal keywords*)
reserve[1] := 'array     '; reserve[11] := 'function  '; reserve[21]:= 'record    ';
reserve[2] := 'begin     '; reserve[12] := 'goto      '; reserve[22]:= 'repeat    ';
reserve[3] := 'case      '; reserve[13] := 'if        '; reserve[23]:= 'set       ';
reserve[4] := 'const     '; reserve[14] := 'in        '; reserve[24]:= 'then      ';
reserve[5] := 'do        '; reserve[15] := 'label     '; reserve[25]:= 'to        ';
reserve[6] := 'downto    '; reserve[16] := 'nil       '; reserve[26]:= 'type      ';
reserve[7] := 'else      '; reserve[17] := 'of        '; reserve[27]:= 'until     ';
reserve[8] := 'end       '; reserve[18] := 'packed    '; reserve[28]:= 'var       ';
reserve[9] := 'file      '; reserve[19] := 'procedure '; reserve[29]:= 'while     ';
reserve[10]:= 'for       '; reserve[20] := 'program   '; reserve[30]:= 'with      ';
end.
