{*****************************************}
{
{        Spice Region Editor
{        Global Declarations
{        Richard Cohn
{        April 1, 1981
{
{*****************************************}


const
      
      BS       = Chr(#010);    { back space }
      Oops     = Chr(#025);    { OOPS }
      CR       = Chr(#015);    { carriage return }
      LF       = Chr(#012);    { line feed }
      FF       = Chr(#014);    { form feed }
      HELP     = Chr(#007);    { HELP }
      TAB      = Chr(#011);

      DotDotDot= Chr(#214);    { "..." }
      EolMarker= Chr(#215);    { end of line marker }
      EotMarker= Chr(#213);    { end of text marker }

      Ins      = Chr(#033);    { INS }
      Del      = Chr(#177);    { delete }

      Stx      = Chr(#002);    { start of text }
      Etx      = Chr(#003);    { end of text }

      Bel      = Chr(#007);    { bell }
      Blank    = ' ';
      
      CloseInsert = #005;      { special command for transcripts }
      
      { limits: }                                                      
      
      MaxDiskPage = maxint;
      MinSwapPage = MaxDiskPage - 4096;
      MaxMemPage = 15;
      MaxOffset = 511;          { this **MUST** be 511, i.e. one disk block }
      MaxLength = 512;          { MaxOffset + 1 }
      MinWindex = 1;
      MaxWindex = 9;
      MaxWindows = MaxWindex - MinWindex + 1;
      MinFile = 0;
      MaxFile = 20;
      maxSegSize = 256;         { limit on segs - replaces MMMaxExtSize }

      SwapFile = MinFile;  { index into IdFile for the swap file }
      PromptNum = MaxWindex + 1; 

      { screen characteristics }
      
      LenEdTitle = 61; { so that time string is at far right (same as shell) }
      CharHeight = 13;
      CharWidth = 9;
      LineHeight = 16;
      
      xScreenMax = 767;
      yScreenMax = 1023;

      MaxColumn = xScreenMax div CharWidth;
      MaxLine   = yScreenMax div LineHeight;
      
      GatherOffset = 8;
      GatherL1  = 1;
      
      ScreenMargin = 2; { Margin of window enclosing entire screen }
      PromptLines  = 3;
      BoxMargin    = 5;
      MaxPromptHeight = PromptLines * LineHeight + 2 * BoxMargin;
      MinPromptHeight = MaxPromptHeight; { to be changed later }

      ThumbHeight = 30; { height of entire thumb area }
      TBarHeight  = 16;
      TBarWidth   = 500;
      MinFillWidth= 10;
      xTBarOffset = 250;
      yTBarOffset = 7;
      SelectMark  = 'S';
      MarkMark    = 'M';
      NameOffset  = 25;
      MinPageWidth= 2;
      MinWindowHeight = ThumbHeight + 2 * LineHeight;
      
      ScrollWidth = 25;
      xScroll     = 3;
      
      MinBuffer   = 0;
      MaxBuffer   = 11;
      KillBMin    = 0;
      KillBMax    = 7;
      SearchB     = KillBMax + 1;
      ReplaceB    = KillBMax + 2;
      SelectB     = KillBMax + 3;
      TempB       = KillBMax + 4;

      MaxRepeatCount   = 32000;
      MaxDigits        = 4;
      DefaultRepeat    = 4;
      DefaultSaveAfter = 500;
      DfltTabSpaces    = 8;
      IDfltLeftMargin  = 0;
      IDfltRightMargin = 70;
      MaxMovesCount    = 5;

      InsModePrompt = 'Insert Mode:  press HELP for Help';
      CmdModePrompt = 'Command Mode:  press HELP for Help';
      ReplPrompt    = 'Replay:  <space>, <INS>, or <DEL>';
      MacroPrompt   = 'Remembering macro--mouse disabled.';
      
      InsertTable = 'Insert';
      CmdTable    = 'Command';

      PrefixBit   = #200; { normally control bit for characters }

      dirFileName = '>pepper.dir';
      

{****************************************************************}
      
type

     Windex      = MinWindex..MaxWindex+1;  { + 1 is for PromptWindow }
     FileIndex   = MinFile..MaxFile;
     DiskPage    = 0..MaxDiskPage;
     MemPage     = 0..MaxMemPage;
     OffsetRange = 0..MaxOffset;
     LengthRange = 0..MaxLength;
     PtrRange    = (TextPtr, ThumbPtr, ScrollPtr, BScrollPtr);
     BufRange    = KillBMin..TempB;
     
     pChunk = ^ChunkRec;
     ChunkRec = record
                 CPage:  DiskPage;
                 First:  OffsetRange;
                 Length: LengthRange;
                 OrderP: integer;
                 OrderC: integer;
                 Next:   pChunk;
                 Prev:   pChunk
                 end;
                
     Position = record
                 Chunk:  pChunk;
                 Offset: OffsetRange
                 end;
                 
     ReadWrite = (ReadCursor, WriteCursor);
                
     Cursor = record
               Pos: Position;
               Attached: boolean;
               Writing:  boolean;
               ChPage:   MemPage;
               ChOffset: OffsetRange;
               Ch:       Char
               end;
                 
     LineIndex = -1..MaxLine+1; { "I'm ashamed of this." (smk) }
     ColumnIndex = -1..MaxColumn+1; { GetLC assigns 1 +/- real indexes }
     
     UnderKind = (Erase, ThinBlack, ThickBlack);
     PromptKind = (NoPrompt, OneLinePrompt, FullPrompt);
     
     pSwapBuffer = ^TextBlock;
     TextBlock = packed array [OffsetRange] of char;

     
      pWindow =  ^Window;
      Window = record
               xMin, yMin, xMax, yMax:  integer
               end;

    pEditBuffer = ^EditBuffer;
    EditDoc = record
              IsFile:   boolean;
              FirstBuf: pEditBuffer;
              Name:     PathName;
              nChars:   integer
              end;
    EditBuffer = record
                 Buffer:  TextBlock;
                 Next:    pEditBuffer
                 end;
    pTextWindow = ^TextWindow;
    TextWindow = record
                 Name, FullName:  PathName;
                 WinNum:  Windex;
                 Bound:  pWindow;
                 xHome, yHome:  integer;
                 yLastLine:  integer;
                 LastLine:  LineIndex;
                 nColumn:  integer;
                 LastColumn:  ColumnIndex;
                 xLastColumn:  integer;
                 leftMargin, rightMargin:  ColumnIndex;
                 BoxOn:  boolean;
                 case IsPrompt:  boolean of
                     false:  (FIndex:  FileIndex;
                              ScrollOn:  boolean;
                              HTextBound, VTextBound:  integer;
                              FilledFirst, FilledLast:  Position;
                              ScreenFirst, ScreenLast:  Position;
                              Mark:  Position;
                              CurLine:  LineIndex;
                              CurCol:  ColumnIndex;
                              OrgLastC:  integer;
                              nChanges, nMoves: integer;
                              SaveAfter:  integer;
                              Ln: array[-1..MaxLine] of record
                                      Start, Finish: Position;
                                      Length: integer
                                      end;    
                              Prev, Next:  pTextWindow;
                              case ThumbOn:  boolean of
                                  true: (xTBarOrigin:  integer;
                                         yTBarOrigin:  integer;
                                         TBFillWidth:  integer;
                                         yThumb:  integer))
                 end;

    ReplayMode = (ReplaySingleStep, ReplayFree, NotReplaying);
    Canvas     = (CanvTrans, CanvKeybd);


{*******************************************************************}

var

    DEBUG:  array [1..9] of boolean;
        { don't change to something bigger w/o changing DebugEditor }
    
    ExitEdit:  boolean;

    IdFile: array[FileIndex] of record
          Index:    FileId;
          MinPage:  DiskPage;
          MaxPage:  DiskPage;
          end;
    Txt: array[MemPage] of record
          Buffer: pSwapBuffer;
          TPage: DiskPage;
          Used, Dirty, RealDirty: boolean;
          end;
    LastMemPage: MemPage;
    FilePages, Pages: DiskPage;
    Files:  FileIndex;
    
    NilPosition:  Position;
    
    { Positions which are automatically updated during Join and Split.
      if you add a Position variable, you must add it to FixUp. }
    
    EmptyFirst,   EmptyLast:    Position;
    SourceFirst,  SourceLast:   Position;
    Display:                    Position;
    LeftPart,     RightPart:    Position;
    PFirst,       PLast:        Position;
    Tmp:                        Position;
    savedPos:                   Position;
    PrevKill,     NextKill:     Position;
    justP:                      Position;
    
    Bufary:  array [BufRange] of record
                 First, Last:  Position
                 end;
    KillB:  KillBMin..KillBMax;

    { Cursors which are automatically updated during Join and Split,
      and which reserve pages in Mem.
      if you add a Cursor variable, you must add it to Fixup and Mem. }
    
    DrawCursor, Cursor1, Cursor2: Cursor;
    
    WordChars:  set of '0'..'z';
    UCLetters:  set of 'A'..'Z';
    LCLetters:  set of 'a'..'z';
    Numbers:    set of char;

    Jump: array[char] of integer;
    PatLength: integer;
    
    CurrentPtr:  PtrRange;
    CursorPtr:  array [PtrRange] of
                  record
                  Pattern:  CurPatPtr;
                  xOrigin, yOrigin:  integer
                  end;   

    CurWin:  pTextWindow;
    SelectWindow:  pTextWindow;
    PromptWindow:  pTextWindow;
    PromptSize:  PromptKind;

    NewEvent:  KeyEvent;
    
    MouseCmds, UpMouseCmds:  CmdSet;
    InsCmds:         CmdSet;
    LeaveTSCmds:     CmdSet;
    ChangeCmds:      CmdSet;
    RepeatableCmds:  CmdSet;
    RepeatCount:     integer;
    
    InsertMode:  boolean;
    SwapOn:  boolean;
    ImmedPrompt:  boolean;
    NeedPrompt:  boolean;
    Automatic:  boolean;
    CountChanges:  boolean;    
    TBarOn:  boolean;  { turned off during insertion }
    
    xPointer, yPointer:  integer;
    xMove, yMove:  integer;
    PtrDisplayed:  boolean;

    CmdPrompt:  string;

    ValidParams:  set of char;
    NormSaveAfter:  integer;
    DfltLeftMargin:  integer;
    DfltRightMargin:  integer;
    Verify:  boolean;
    MouseJump:  integer;
    TabSpaces:  integer;
    BlackScreen:  boolean;
    wordWrap: boolean;

    EdWin:  WinRange;  { must be var for GetWindowParms }
    Winary:  array [Windex] of pTextWindow;
    
    BufferSeg:  integer;
    WindowSeg:  integer;
    ChunkSeg:   integer;
    FreeChunk:  pChunk;

    EdTitle:  string;
    TimStr:  string;

    Replay:     ReplayMode;     { if replaying and how }
    CanvDflt:   Canvas;
    ReplayCmds: CmdSet;
    PosCmds:    CmdSet;
    SelCmds:    CmdSet;
    DEBUG5:     boolean;        { if true then give debug info on replay }
    InSrchCmds: CmdSet;
    InReplCmds: CmdSet;
    ExitStrCmds:  CmdSet;
    InsWhiteCmds: CmdSet;

    remembering:  boolean;      { true if remembering for macro }
    macroRunning: boolean;      { true if executing a macro }
    macroQueue:   KeyQueue;
