program Print;
{**************************************}
{ Author: Peter H. Feiler CRT Siemens Corp.   (first steps)
{ Abstract:
{       print filename/fpag,lpag
{           fpag => first wanted page
{           lpag => last wanted page
{
{       List a file over the rs232 and multiplexer to a line printer device.
{
{       Filename may contain wildcards; if more than one file matches
{       then all matching names are put up in a menu and the user points
{       to the file (s)he wants printed.  If filename does not contain
{       wildcards and is not found, it is used as a basename and files are
{       searched for with any extension other than '.Seg' and '.Run' and
{       files ending in a '$'.  If more than one is found, a menu is used.
{
{ log.:
{
{ 17 Jun 82  (sjc) Made it read printer connection # from user's Profile,
{                  and made it do the right thing for control-C's before
{                  it ever got connected.
{
{ 16 Jun 82  (sjc) Added handlers for CtlC and CtlCAbort to disconnect
{                  from printer, and rationalized checking for XOff etc.
{
{  4 Jun 82  (sjc) Updated menu stuff to use my "Util" package instead of
{                  several older modules, and added looking for files with
{                  extensions other than '.Seg' etc. so it can be reasonably
{                  used with no arguments.
{
{ 23 Feb 82  (sjc) use sail_string break table instead of CmdParse
{
{ 22 Feb 82  (sjc) Added wildcard processing and changed to menu of matching
{                  files.
{
{ 18 Feb 82  (sjc) Added menu of .pas files if no file specified 
{
{ 31-jan-82  (sv)  expanded li4 to ls4 (with: filename,page # and date)
{
{ 29-jan-82  (sv)  the amount of wanted pages can be specified
{ 
{ 26-jan-82  (sv)  Now it should know  <FF>'s  in the file . 
{                  If the printer is busy, it retries  for about 20 sec's . 
{
{ 22-jan-82  (sv)  running version, that doesn't miss characters
{
**************************************}

const   m = true;  {if true then include menu stuff}
const   debug = true;   
const   tick = true;   

Imports io_Unit from io_Unit;
Imports ioerrors from ioerrors;
imports rs232baud from rs232baud;
Imports system from system;
Imports clock from clock;
imports sail_string from sail_string;
imports FileSystem from FileSystem;
imports PMatch from PMatch;
imports Profile from Profile;

{$ifc m then}
imports Util from Util;
imports PopUp from PopUp;
{$endc}

const
    chCR = chr(13);
    chLF = chr(10);
    chFF = chr(12);
    chBYE = chr(23);
    chXON = chr(17);   { printer XOn }
    chXOFF = chr(19);  { printer XOff }
    chON = chr(145);   { switch XOn }
    chOFF = chr(147);  { switch XOff }

var     timstring: string;
        time: timestamp;
        infile: text;
        filename: string;
        textbuffer: string;
        c1,c2,c3: char;
        k,iold: integer;
        fpag,lpag: integer;
        ConnectString: String;           { printer connection # }
        OffSwitch, OffPrinter: Boolean;  { flags for xoff }
        State: (sDisconnected, sInSwitch, sConnected);

{$ifc m then}
Const   FilePrompt =
             'Which file do you want printed?  (Press outside menu to abort.)';

{$endc}

label   100;

function checkxoffrs (var c: char): boolean;
                { check to see if c is OFF or XOFF. }
                { Returns true if c is a useable character. }

        begin
        c := Chr (LAnd (Ord (c), #377));
        case c of
            chXON: begin
                {$ifc tick then}
                    write ('}');
                    {$endc}
                OffPrinter := False;
                CheckXOffRS := False;
                end;
            chXOFF: begin
                {$ifc tick then}
                    write ('{');
                    {$endc}
                OffPrinter := True;
                CheckXOffRS := False;
                end;
            chON: begin
                {$ifc tick then}
                    write (']');
                    {$endc}
                OffSwitch := False;
                CheckXOffRS := False;
                end;
            chOFF: begin
                {$ifc tick then}
                    write ('[');
                    {$endc}
                OffSwitch := True;
                CheckXOffRS := False;
                end;
            OtherWise: begin
                {$ifc tick then}
                    if OffSwitch then
                        write ('X]');
                    if OffPrinter then
                        write ('X}');
                    {$endc}
                OffPrinter := False;
                OffSwitch := False;
                CheckXOffRS := True;
                c := Chr (LAnd (Ord (c), #177));
                end;
            end;
        end;

function readchrs:char;

        var     c:char; 

        begin
        repeat
            while iocread (rs232in,c) <> IOEIOC do ;
            until checkxoffrs (c);
        readchrs := c;
        end;

procedure eatcharsrs;

        var     c:char;
                garbage: boolean;

        begin
        while iocread (rs232in,c) = IOEIOC do
            garbage := checkxoffrs (c);
        end;

procedure readmatchrs(ch:char);

        begin
        while readchrs <> ch do;  
        end;

procedure munchrs(n:integer);

        var     i:integer;
                c : char;

        begin
        for i := 1 to n do
            c := readchrs;
        end;

procedure readlnrs;

        begin
        while readchrs <> chLF do;  
        end;  

procedure writechrs(c:char);

        begin
        repeat   
            eatcharsrs;
            until (not OffSwitch) and (not OffPrinter);
        if iocwrite(rs232out,c) <> IOEIOC then
            writeln('** RS Out error **'); 
        end;

procedure writelnrs (str:string);

        var     i:integer;

        begin
        for i := 1 to length(str) do
            writechrs(str[i]);
        writechrs(chCR);
        end;

procedure delay(i:integer);

        var     n,m,m1:integer;

        begin
        for n:=1 to i do
            begin
            for m:=1 to 1000 do
                m1:=m div 4;
            end;
        end;

Function Header (Filename: String; Page: Integer; Time: String): String;

        Const   Str80Spaces = '                                                                                ';

        Var     h, p: String;
                pos: Integer;

        Begin
        h := Str80Spaces;
        ReplaceChars (h, Filename, 1);
        p := Concat ('Page ', CVS (Page));
        pos := (80 - Length (p)) div 2;
        ReplaceChars (h, p, pos);
        ReplaceChars (h, Time, 80 - Length (Time));
        Header := h;
        End;

procedure printfile(filename:string;fpag,lpag:integer);

        var     f:text;
                str:string[255];
                i,k,ipag:integer;
                print:boolean;

begin
        write ('printing ',filename, ' pages ', fpag:1, ' to ');
        if lpag = MaxInt
            then writeln ('end of file')
            else writeln (lpag:1);
        reset(f,filename);
        GetTString(timstring);
        k:=1;
        ipag:=1;
        while not eof(f) and (ipag<=lpag )do
          begin 
          print := (ipag>=fpag);  
            if print and (k=1)then
              begin 
              write (' ', ipag:1);
              writechrs(chFF);
              writechrs(chLF);
              writechrs(chLF);
              writelnrs(Header (Filename, ipag, timstring));
              writechrs(chLF);
              writechrs(chLF);
              writechrs(chLF);
              end;
          readln(f,str);
          for i:=1 to Length (str) do
          begin
            if str[i] = chFF then
              k:=54
            else  if print then
              writechrs(str[i]);
            end;
          if  print and ( k < 54 ) then
          begin
            writechrs(chCR);
            writechrs(chLF);
          end;
          delay(1);                
          k:=k+1;
          if k > 53 then
            begin
            k:=1; 
            ipag:=ipag+1; 
            end;             
          end;
        writechrs(chFF);
        writeln;
        writeln('printing complete');
end;

Function NextArgStr(var CmdStr, ArgStr: String; BT: BreakTable): Boolean;
  var Broke: string;
  begin
  ArgStr := '';
  while (length (cmdstr) > 0) and (length (ArgStr) <= 0) do
      ArgStr := scan (CmdStr, BT, Broke);
  NextArgStr := length (ArgStr) > 0;
  end;


Procedure ParseCmds(var f:string;var fpag,lpag:integer);

  var Str: string;
      Cmdlin:string;
      BT: BreakTable;
      garbage: boolean;

  begin
  Cmdlin := UsrCmdLine;
  BT := GetBreak;
  SetBreak (BT, ' ,/', '', [Inclusive, Skip]);
  garbage := NextArgStr (cmdlin, str, BT);
  garbage := NextArgStr (cmdlin, f, BT);
                   { if no filename given, f will be set to null string }
  if NextArgStr (cmdlin, str, BT)
    then fpag := CVD (str)
    else fpag := 1;
  if NextArgStr (cmdlin, str, BT)
    then lpag := CVD (str)
    else lpag := MaxInt;
  end;

Function Exist (f: string): Boolean;

    Var dum1, dum2: integer;

    begin
    Exist := FSLocalLookup (f, dum1, dum2) <> 0;
    end;


{$ifc m then}
Procedure FindFile (Var FileName: String);
    { Sets FileName to the null string if no file found. }

        Var     OldFilePat, SegFilePat, RunFilePat: String [10];
                PND: pNameDesc;
                result: ResRes;
                DirList, P: UPtrFile;
                NumFiles: Integer;
                DirPart: String;

        Handler Outside;
        
                Begin
                UErasePrompt;
                Exit (Print);
                End;

        Begin
        if FileName = '' then FileName := '*';
        if IsPattern (FileName)

    { if given a pattern, then simply choose among all files that match }
            then FileName := UGetFile (FilePrompt, '', FileName)

    { otherwise, check whether the file exactly as given exists }
            else if not Exist (FileName) then begin

    { if FileName does not name a file itself, then look for files
      with that basename and any extension other than '.Seg', '.Run',
      and anything ending in a '$'.
      }
                USplit (FileName, DirPart, FileName);
                AppendString (Filename, '.*');
                DirList := UDirectory ('', FileName);

                P := DirList;      { count the number files }
                NumFiles := 0;
                while P <> nil do
                    begin
                    NumFiles := NumFiles + 1;
                    P := P^ . Next;
                    end;

                if NumFiles > 0
                  then
                    begin
                { fill a PopUp NameDesc with filenames that are OK. }
                    OldFilePat := '*$';
                    SegFilePat := '*.Seg';
                    RunFilePat := '*.Run';
                    UAllocNameDesc (NumFiles, PND);
                    NumFiles := 0;      { now NumFiles is # of OK files }
                    P := DirList;
                    while P <> Nil do
                        begin
                        if not PattMatch (P^ . name, OldFilePat, True)
                                and not PattMatch (P^ . name, SegFilePat, True)
                                and not PattMatch (P^ . name, RunFilePat, True)
                            then begin
                                NumFiles := NumFiles + 1;
                                {$R-}
                                PND^ . Commands [NumFiles] := P^ . name;
                                {$R+}
                                end;
                        P := P^ . Next;
                        end;
                    UDispDirectory (DirList);

                { choose among the OK filenames }
                    if NumFiles > 1
                        then begin
                            UPrompt (FilePrompt);
                            Menu (PND, False, 1, NumFiles,
                                            UPopX, UPopY, UPopMaxY, result);
                            UErasePrompt;
                            {$R-}
                            FileName := PND^ .commands [result^ .indices [1]];
                            {$R+}
                            DestroyRes (result);
                            end
                        else if NumFiles = 1
                            then FileName := PND^ . commands [1]
                            else FileName := '';

                    DestroyNameDesc (PND);
                    end
                  else FileName := '';
                if length (FileName) > 0 then
                    FileName := Concat (DirPart, FileName);
                end;
        End;
{$endc}

Procedure Disconnect;

        Begin
        if State = sConnected then
            begin
            delay (10);
            writechrs (chBYE);
            writechrs (chBYE);
            readmatchrs ('*');       
            State := sInSwitch;
            {$ifc Debug then }
                write ('Disconnected from printer ..');
                {$endc}
            end;
        if State = sInSwitch then
            begin
            writechrs (chCR);
            munchrs (15);     { eat <chCR><chCR><chLF>SIGNED OFF<chCR><chLF> }
            State := sDisconnected;
            {$ifc Debug then }
                writeln ('.. Signed off of switch.');
                {$endc}
            end;
        End;

Handler CtlC;

        Begin
        writeln ('^C');
        Disconnect;
        CtrlCPending := False;
        Raise ExitProgram;
        End;

Handler CtlCAbort;

        Begin
        writeln ('^C');
        Disconnect;
        CtrlCPending := False;
        Raise ExitProgram;
        End;

{ the main program }
begin
State := sDisconnected;
{$ifc m then}
UInit (Uversion);       { initialize utility package }
{$endc}

ParseCmds(Filename,fpag,lpag);  { read command line }

       { if file does not exist, f will be set to null string }
{$ifc m then}
    FindFile (FileName);
{$elsec}
    if not exist (filename) then filename := '';
{$endc}

    if length (filename) > 0 then 
    begin
        SetBaud('4800', true);  { Initialize RS232 connection }
        OffPrinter := False;
        OffSwitch := False;

        PFileInit (CurPFile, 'Print');      { Get printer connection number }
        ConnectString := Concat ('c ', Strip (PFileEntry));
        { ConnectString should be, e.g., 'c 220' or 'c 120' }

        if ConnectString = 'c ' then    { there was no entry in the profile }
            begin
            writeln ('*** You should put an entry in your Profile like this:');
            writeln ('#Print');
            writeln ('        <number>');
            write ('*** where <number> is the connection number of the ');
            writeln ('printer from your Perq.');
            writeln ('*** (probably 120 or 220) ***');
            writeln;
            write ('What is the printer connection number from your Perq? ');
            readln (k);
            AppendString (ConnectString, CVS (k));
            end;

        reset(infile,filename); 
        eatcharsrs;
        {$ifc Debug then }
            write ('Attempting to get to switch ..');
            {$endc}
        writechrs('h');
        readmatchrs('*');
        State := sInSwitch;
        {$ifc Debug then }
            write ('.. In the switch ..');
            {$endc}
        { we are in the switch now }
        k := 1;
        repeat
            writelnrs (ConnectString);       { connect to printer }
            munchrs (length(ConnectString)+3);      { read two CR and one LF }
            if (readchrs = 'C') then   goto 100;
            writeln('** Printer busy; trying again in two seconds **');
            k := k+1;
            gettstamp (time);
            iold := time.second + 2;
            if (iold > 59) then iold := iold-60;
            repeat gettstamp (time);
                until time.second = iold;
        until (k=10); 

100:    if (k < 10)
            then
                begin
                State := sConnected;
                {$ifc Debug then }
                    writeln ('.. Connected to printer.');
                    {$endc}
                printfile(filename,fpag,lpag);
                end
            else writeln('** Could not connect **');
        Disconnect;
    end
    else  writeln('*** No file printed ***');
end.
