Module PopCmdParse;
{---------------------------------------------------------------
{
{ Abstract:
{    This module provides procedures to help with PopUp menus.  See
{    the module PopUp for the definition of pNameDesc and for some
{    useful procedures for creating and destroying pNameDescs.
{
{ Written by Brad Myers    Nov 18, 1981
{
{ Copyright (C) 1981 Three Rivers Computer Corperation
{
{---------------------------------------------------------------}


{------------------------------------------------------------------
{ Change Log:
{
{ Date: 26 Jan-82  V1.8 Brad Myers
{ Only character illegal after a command is "=" in IGetCmdLine.
{ Extra blank input at the end of command files.
{ Use PointAllowed.


{ Date: 21 Jan-82  V1.7 Brad Myers
{ No popup if isFloppy
{

{ Date:  8 Jan-82  V1.6 Brad Myers
{ Fixed Type ahead bug if in a command file.
{ Fixed PopUniqueCmdIndex to find a command if it equals another even if it
{   is shorter.  Eg.  in table are "p" and "path".  "p" will get "p" even
{    though is not unique.
{ Help on PopUp menus.

{ Date:  5 Jan-82  V1.5 Brad Myers
{ No beep if Pop not OK for GetCmdLine and GetConfirm.

{ Date:  4 Jan-82  V1.4 Brad Myers
{ Fixed bug in CmdFile prompt character in GetCmdLine.
{ Re-instated IdleProc.

{ Date: 30 Dec-81  V1.3 Brad Myers
{ Fixed Destroy ==> Dstry for new CmdParse.
{ Added NullIdleProc.

{ Date: 30 Nov-81  V1.1 Brad Myers
{ Moved alloc and destroy Name desc to popUp.
{ Change GetConfirm to take prompt and default.  

{ }
{ Date: 19 Nov-81  V1.0 Brad Myers
{ Started.  
{ }
{------------------------------------------------------------------}


{********************} Exports {********************}

Imports CmdParse from CmdParse;
Imports PopUp from PopUp;

Function PopUniqueCmdIndex(Cmd: CString; Var names: pNameDesc): Integer;

Function GetCmdLine(Procedure IdleProc; prompt: String;
                    var line, cmd: CString; var inF: pCmdList;
                    var names: pNameDesc; var firstPress: boolean;
                    popOK: boolean): integer;

Function GetShellCmdLine(var cmd: CString; var inF: pCmdList;
                 var names: pNameDesc): integer;

Function GetConfirm(Procedure IdleProc; popOK: boolean;
                     prompt: String; def: integer;
                     var switches: pSwitchRec): integer;

Procedure NullIdleProc;

{********************} Private {********************}
