module Stream;
{$Version Stream V3.7 of 3 Nov 83 }
exports
imports AccentType from AccentType;
const StreamVersion ='1.12';
IdentLength =8;
type SName =string[255];
type pStreamBuffer =^StreamBuffer;
StreamBuffer =record case integer of
0:(W:array[0..255]of integer);
1:(B1:packed array[0..0]of 0..1);
2:(B2:packed array[0..0]of 0..3);
3:(B3:packed array[0..0]of 0..7);
4:(B4:packed array[0..0]of 0..15);
5:(B5:packed array[0..0]of 0..31);
6:(B6:packed array[0..0]of 0..63);
7:(B7:packed array[0..0]of 0..127);
8:(B8:packed array[0..0]of 0..255);
9:(C:packed array[0..255]of char);
end;
pStreamF =^StreamF;
StreamF =record
FName:SName;
Buffer:pStreamBuffer;
BufSize:long;
WordIndex:long;
LastElt:integer;
EltIndex:integer;
end;
ControlChar =0..#37;
FileKind =(BlockStructured,CharacterStructured);
FileType =
packed record
Flag:packed record case integer of
0:(CharReady :boolean;
FEoln :boolean;
FEof :boolean;
FNotReset :boolean;
FNotOpen :boolean;
FNotRewrite:boolean;
FExternal :boolean;
FBusy :boolean;
FKind :FileKind);
1:(skip1 :0..3;
ReadError :0..7);
2:(skip2 :0..15;
WriteError:0..3)
end;
EolCh,EofCh,EraseCh,NoiseCh:ControlChar;
OmitCh :set of ControlChar;
FileNum :integer;
FIndex :integer;
Length :integer;
BlockNumber :integer;
StreamP :pStreamF;
LengthInBlocks:integer;
LastBlockLength:integer;
SizeInWords :integer;
SizeInBits :0..16;
ElsPerWord :0..16;
Element:record case integer of
1:(C:char);
2:(W:array[0..0]of integer)
end
end;
ChArray =packed array[1..1]of char;
Identifier =string[IdentLength];
IdentTable =array[0..1]of Identifier;
procedure StreamInit(var F:FileType;WordSize,BitSize:integer;
CharFile:boolean );
procedure StreamOpen(var F:FileType;var Name:SName;
WordSize,BitSize:integer;CharFile:boolean;
OpenWrite:boolean );
procedure StreamClose(var F:FileType );
procedure GetB(var F:Filetype );
procedure PutB(var F:Filetype );
procedure GetC(var F:Filetype );
procedure PutC(var F:FileType );
procedure PReadln(var F:Filetype );
procedure PWriteln(var F:Filetype );
procedure InitStream;
function StreamName(var F:FileType ):SName;
function FullLn(var F:Text ):Boolean;
procedure StreamKeyBoardReset(var F:Text );
exception ResetError(FileName:SName );
exception RewriteError(FileName:SName );
exception NotTextFile(FileName:SName );
exception NotOpen;
exception NotReset(FileName:SName );
exception NotRewrite(FileName:SName );
exception PastEof(FileName:SName );
exception UnitIOError(FileName:SName );
exception TimeOutError(FileName:SName );
exception UndfDevice;
exception NotIdentifier(FileName:SName );
exception NotBoolean(FileName:SName );
exception BadIdTable(FileName:SName );
exception IdNotUnique(FileName:SName;Id:Identifier );
exception IdNotDefined(FileName:SName;Id:Identifier );
exception NotNumber(FileName:SName );
exception LargeNumber(FileName:SName );
exception BadBase(FileName:SName;Base:Integer );
procedure KBFlushBoardOutput(var F:FileType );
exception SmallReal(FileName:SName);
exception LargeReal(FileName:SName);
procedure WriteNChars(VAR F:FileType;c:char;N:Integer);
procedure WriteChars(VAR F:FileType;VAR S:String);
function IsStreamDevice(S:SName):integer;
procedure StreamFlushOutput(var F:Text);
var
DefaultInputName :STRING[255];
DefaultOutputName :STRING[255];
private
 { Stub created by MakeStub at15-Feb-84  17:29:42 }
begin
end.
