module Dynamic;
exports
imports AccentType from AccentType;
const DynamicVersion ='1.0';
DynDebug =false;
DynPrint =false;
AccentVersion =True;
{$ifc DynDebug then}
{$MESSAGE Debugging version of dynamic }
{$ifc DynPrint then}
{$MESSAGE Debug printing version }
{$endc}
{$ENDC}
{$IFC not AccentVersion THEN}
{$Message Compiling POS Version * * * * * * * * * * * * * * * * * * * * * *}
{$ENDC}
const
BadHeapNumber =0;
type
HeapNumber =integer;
HeapOffset =integer;
HeapAddress=record case integer of
0:(
Offset:HeapOffset;
Segment:HeapNumber );
1:(
AnyPtr:Pointer );
2:(
LongInt:Long );
end;
procedure NewP (S:HeapNumber;A:integer;var Where:pointer;L:integer);
procedure DisposeP (var Where:pointer;L:integer);
procedure InitDynamic;
function CreateHeap:HeapNumber;
procedure ResetHeap(S:HeapNumber);
procedure DestroyHeap(S:HeapNumber);
procedure CheckHeap(S:HeapNumber);
{$IFC AccentVersion THEN}
exception NilPointer;
exception BadPointer;
exception TooManyHeaps;
exception AccentError(R:GeneralReturn;M:String);
{$ENDC}
exception BadHeap(H:HeapNumber );
exception BadAlignment;
procedure DynStats(Tr,Dump:boolean);
procedure TraceHeap(S:HeapNumber;Trace:boolean);
private
 { Stub created by MakeStub at15-Feb-84  17:23:14 }
begin
end.
