program DirTree(input,output);
{--------------------------------------------------------------------------
 DirTree draws a tree on the screen showing the current directory structure.
 
 Written by Brad A. Myers
 
 Copyright (C) 1981 - The Three Rivers Computer Corporation
--------------------------------------------------------------------------}

{--------------------------------------------------------------------------
   Versions:
    29-Jul-81  Brad Myers  V2.0  Change to take 2nd parameter which is the
                                   window number to display in
     3-Jun-81  Brad Myers  V1.2  Added comments
    ??-???-81  Brad Myers  V1.1  Allowed DirTree on multiple partitions
    ??-???-81  Brad Myers  V1.0  Started
--------------------------------------------------------------------------}


imports fileUtils from Fileutils;
imports Screen from Screen;
imports FileDir from FileDir;
imports PERQ_STRING FROM PERQ_STRING;
imports CmdParse from CmdParse;
imports system from system;
imports allocDisk from AllocDisk;
imports SigUtils from SigUtils;

type  DirRec = record
                 name: SimpleName;
                 fullName: PathName;
                 x,y: integer;   {of where displayed}
                 rightX: integer;  {end of where displayed}
                 parent: integer;
                 level: integer;
                 fid: FileID;
              end;

type pDirStack = ^dirStack;
     dirStack = RECORD
                   dirName: PathName;
                   dirInd: integer;
                   next: pDirStack;
                   prev: pDirStack;
                END;

var dumWindR : WinRange;

    treeRoot: PathName; {dir list used while searching for directories}
    dirs: Array[1..100] of DirRec;  {dir list used for displaying directories}

    numDirs, xPos, i, maxLevels, winX, winY, winH, winW: integer;
    scanptr : ptrScanRecord;
    levelSize: array[1..9] of integer;
    pBot, pTop, pTemp: pDirStack;  
    fid, rootFid: FileID;
    dumBool: boolean;
    curLevel: integer;
    
    debug: boolean;
    
const Version = '1.2';

label 1;


Procedure AddIt(dir, name: PathName; level, parent: integer; fid: FileID);
{---------------------------------------------------------------
  Abstract: Adds a newly found directory to the lists
  Parameters: directory IN WHICH the new directory was found
              name is the simpleName of the new directory found
              level is the level of the directory found
              parent is the array index of dir (the parent of name)
              fid is the file ID of name
  SideEffects: Adds name to both directory lists
               Increments numDirs and LevelSize[level]
  Environment: Assumes lists and numDirs properly initialized
-------------------------------------------------------------------}
   var pTemp: pDirStack;
        begin

        if debug then writeLn('Dir ',name,' found in ',dir,
             '. Numdirs=',numdirs:1,' level =',level:1,' parent=',parent:1);
        
        numDirs := numDirs+1;

        NEW(pTemp);
        if pBot = NIL then pBot := pTemp;
        pTemp^.next := pTop;
        if pTop <> NIL then pTop^.prev := pTemp;
        pTemp^.prev := NIL;
        pTop := pTemp;
        pTemp^.dirInd := numDirs;
        pTemp^.dirName := Concat(dir, name);
        
        dirs[numDirs].name := name;
        dirs[numDirs].fullName := pTemp^.dirName;
        dirs[numDirs].level := level;
        dirs[numDirs].parent := parent;
        dirs[numDirs].fid := fid;
        levelSize[level] := levelSize[level] + 1;
        
        end; {AddIt}


Procedure DoOneLevel(level: integer);
{---------------------------------------------------------------
  Abstract: Displays all the directories in a partiticular level
  Parameters: level is the level to display
  SideEffects: Changes xPos
  Environment: Assumes xPos is set and dir array has been filled with all
                the items at this level
  Design: Have to do levels in order from left to right
          Assumes the width of the current font is 9
-------------------------------------------------------------------}
   var len, maxLen: integer;
       yOffset, y: integer;
       i: integer;
   begin
   yOffset := (winH-13) div (levelSize[level]+1);
   if debug then WriteLn('~~~~level ',level:1,' size=',levelSize[level]:1,
                         ' yOffset=',yOffset:1);
   y := winY+yOffset;
   maxLen := 0;
   for i := 1 to numDirs do
     if dirs[i].level = level then
        begin
        SSetCursor(XPos, y);
        if dirs[i].name = '' then 
          begin
          adjust(dirs[i].name, 1);
          dirs[i].name[1] := chr(#177);
          end;
        Write(dirs[i].name);
        dirs[i].x := xPos;
        dirs[i].y := y;
        len := 9*length(dirs[i].name);
        if len > maxLen then maxLen := len;
        dirs[i].rightX := xPos+len;
        if dirs[i].parent <> 0 then
          Line(DrawLine, xPos, y-7, dirs[dirs[i].parent].rightx-2, 
              dirs[dirs[i].parent].y-7, SScreenP);
        y := y+yOffset;
        end;
   xPos := xPos+maxLen+100;
   end;


Function UpperEqual(name1, name2: SimpleName): boolean;
{---------------------------------------------------------------
  Abstract: Tests to see if two strings are equal after converting to uppercase
  Parameters: name1 and name2 are strings to compare
  Returns: True if equal after uppercasing
-------------------------------------------------------------------}
    begin
    ConvUpper(name1);
    ConvUpper(name2);
    UpperEqual := name1=name2;
    end;


Procedure DoDirScan(dir: PathName; dirInd: integer);
{---------------------------------------------------------------
 Abstract: Scans through one directory or partition searching for sub-
            directories and adds any found to lists.  If directory doing is at
            a new level, then display the previous level
 Parameters: dir is the pathName of the directory to search through
             dirInd is the index in the directory array of dir
 SideEffects: Changes dir list and arrays
 Calls: AddIt, DoOneLevel
-------------------------------------------------------------------}
  var s: String[2];
      name: SimpleName;
      dum: integer;
      fid: FileID;
      i, disk: integer;
  label 1;
  begin

  scanptr^.InitialCall := true;
  scanptr^.dirName := dir;
      
  if dirs[dirInd].level > curLevel then
     begin
     DoOneLevel(curLevel);
     curLevel := curLevel+1;
     end;
  if debug then begin
                WriteLn;
                WriteLn('in dirScan, dir=',dir,' index=',dirInd:1);
                end;
  if dir[length(dir)] = ':' then  {is a device; find all partitions}
     begin
     for i := 0 to MAXDISKS-1 do
        if UpperEqual(DiskTable[i].RootPartition, SubStr(dir, 1,length(dir)-1))
           then begin
                disk := i;
                goto 1;
                end;
     {if get to here then device not found}
       WriteLn(' ** Device ',dir,' not found; aborting');
       Exit(DirTree);
   1: for i := 1 to MAXPARTITIONS do
         if PartTable[i].PartInUse and (disk=PartTable[i].PartDevice) then
             begin
             name := partTable[i].partName;
             AppendChar(name, '>');
             fid := FSLookUp(Concat(dir, name), dum, dum);
             AddIt(dir, name, dirs[dirInd].level+1, dirInd, fid); 
             end;
     end {partition}
  else while FSScan(scanptr, name, fid) do  {is a directory; find subdirs}
    if length(name) > 3 then
     if name[length(name)-2] = '.' then
       begin
       s := Substr(name, length(name)-1,2);
       ConvUpper(s);
       if s = 'DR' then
            begin
            name := SubStr(name, 1, length(name) -3);
            if name = '..' then
               begin
               WriteLn;
               WriteLn(' ** Directory ',dir,' contains a bad directory: ...DR; aborting');
               exit(DirTree);
               end;
            AppendChar(name, '>');
            AddIt(dir, name, dirs[dirInd].level+1, dirInd, fid);
            end;
       end;
 end; {DoDirScan}


Procedure BreadthFirstSearch;
{---------------------------------------------------------------
 Abstract: Does a breadth first scan through all directories, adding any
             directories found to the lists.  After finishing each level,
             displays the level on the screen
 SideEffects: Initializes dir array and lists and then fills them
 Calls: DoDirScan 
 Design: Adds directories found to the front of a list using AddIt.  Every time
         finish scanning a directory, take the next directory off the end of
         the list.  This way, all the directories at a certain level are
         guaranteed to be processed before anything at the next level.  In
         addition, this guarantees that the directories at the next level
         will be in a corresponding order.
-------------------------------------------------------------------}
   var leave: boolean;
       dir: PathName;
       dirInd: integer;
   
   begin

   pBot := NIL;
   pTop := NIL;
   leave := false;
   
   dir := treeRoot;
   dirs[1].name := treeRoot;
   dirs[1].fullName := treeRoot;
   dirs[1].level := 1;
   dirs[1].parent := 0;
   dirs[1].fid := rootFid;
   dirInd := 1;;
   numDirs := 1;
   curLevel := 1;
   
   levelSize[1] := 1;
   
   repeat
      DoDirScan(dir, dirInd);
      
      if pBot <> NIL then
         begin
         dir := pBot^.dirName;
         dirInd := pBot^.dirInd;
         pTemp := pBot;
         pBot := pBot^.prev;
         if pBot <> NIL then pBot^.next := NIL;
         DISPOSE(pTemp);
         end
      else leave := true; 

  until leave;
  end;
     

Procedure ReadCmdLine;
{-----------------------------------------------------------------------
 Abstract: This procedure is used to read the command line and set the
           partition name.
 Side Effects: This procedure will change partition name;
-----------------------------------------------------------------------}
    var Broke: String;
        dum, cnt: integer;
        win: WinRange;
    begin
    cnt := ArgCount;
    NextArgStr(broke);  { Take off cmd }
    NextArgStr(treeRoot);
    if treeRoot = '?' then
      begin
      WriteLn('** Usage: DirTree treeRoot win#');
      exit(DirTree);
      end;
    
    if cnt > 2 then 
       begin
       nextArgInt(dum);
       win := dum;
       ChangeWindow(win);
       RefreshWindow(win);
       Write(FF);
       end;
       
    if treeRoot = 'debug' then 
        begin
        debug := true;
        treeRoot := '';
        end;
    if treeRoot = '' then
       begin
       Write('Root of Directory tree [',DefaultDeviceName,'] : ');
       readLn(treeRoot);
       if treeRoot = '' then treeRoot := DefaultDeviceName;
       end;
    if treeRoot[length(treeRoot)] = ':' then rootFid := 0 {is a device name}
    else begin
         if treeRoot[length(treeRoot)] <> '>' then AppendChar(treeRoot, '>');
         rootFid := FSLocalLookUp(treeRoot, dum, dum);
         if rootFid = 0 then
             begin
             WriteLn('** ',treeRoot,' does not exist');
             exit(DirTree);
             end;
         end;
    end;



begin

  debug := false;
  
  ReadCmdLine;
  FSAddToTitleLine(Concat('DirTree ', Version));

  NEW(scanPtr);
  For i := 1 to 9 do
    levelSize[i] := 0;

  Write(chr(12));
  GetWindowParms(dumWindR, winX, winY, winW, winH, dumBool);

  xPos := winX+3;
  winY := winY+3;
  
  BreadthFirstSearch;
 
  maxLevels := 9;
  while levelSize[maxLevels] = 0 do
    maxLevels := maxLevels-1;
  
  for i := curLevel to maxLevels do
    DoOneLevel(i);
  
  SSetCursor(winX+3,winY+16);
  
  fid := FSLocalLookup(FSDirPrefix, i, i);
  for i := 1 to numDirs do
    if dirs[i].fid = fid then
       with dirs[i] do
         begin
         RasterOp(RNot, rightX-x+5, 15, x-4, y-14, SScreenW, SScreenP,
                                        x-4, y-14, SScreenW, SScreenP);
         goto 1;
         end;
1: 

end.
  

    
    
