program hello;
imports Dynamic from Dynamic;
imports io from io;
imports ioerrors from ioerrors;
imports rs232baud from rs232baud;
imports system from system;
imports FileSystem from FileSystem;
imports IOErrMessages from IOErrMessages;

{ This is a dead simple program to do a raw disk dump of the
  hard drive to the RS232 port.  It's also my first Pascal program
  as well as my first PERQ program, so it sucks.  But hopefully
  it'll work.
  
  J. Dersch, 8/14/06.}
  

type
    CharArray = array [0..512] of char;
    ChrArrayPtr = ^CharArray;
        
var i : integer;
    c : char;
    buf : IOBufPtr;
    Stat : DevStatusBlock;
    addr : double;
    header : IOHeadPtr;
    status : IOStatPtr;
    Head : integer;
    Sector : integer;
    Cylinder : integer;
    CylStart : integer;
    CylEnd : integer;
    seg : SegmentNumber;
    success : boolean;
    RetryCount : integer;
    
procedure WriteChar( c : char );
begin
  if iocwrite(RS232Out, c) <> IOEIOC then
    writeln( ' -- error writing to serial port -- ' );
end;

procedure WriteInt( i : integer );
var high : char;
    low : char;
    
begin
 high := chr(shift(i,-8));
 low := chr(land(i,255));
 
 WriteChar( low );
 WriteChar( high );
end;

procedure WriteDbl( d : double );
begin
 WriteInt( d[0] );
 WriteInt( d[1] );
end;

begin
  
  writeln ('Start at what cylinder? ');
  readln ( CylStart );
  
  writeln ('End at what cylinder? (Max 201)');
  readln ( CylEnd );
  
  writeln ('Here we go...');
  
  { Configure the RS232 port }
  
  with Stat
  do begin
    ByteCnt := 1;
    RSRcvEnable := false;
    end;
    
  IOPutStatus( RS232In, Stat );
  SetBaud('9600', true);
  
  writeln ('Set RS232 port to 9600 baud...'); 
  
  writeln ('Allocating memory...');
  
  NEW(0,4,status);
  NEW(0,4,header);
  
  CreateSegment( seg, 1, 1, 1 ); 
  buf := MakePtr(seg,0, IOBufPtr); 

  { Read 512 bytes from the disk }
  writeln ('Reading 512 bytes...');
  
    
    
      
  for Cylinder := CylStart to CylEnd do
   begin
    for Head := 0 to 7 do
     begin
      for Sector := 0 to 29 do
        begin
        
        addr[0] := Cylinder * 256 + Head*32 + Sector;
        
        writeln( 'reading cylinder ', cylinder, ' head ', head, ' sector ', sector );
        success := false;
        RetryCount := 0;
        
        while (not success) and (RetryCount < 10) do
          begin
         
          UnitIO( HardDisk, buf, IODiagRead, 512, addr, header, status );
          
          {writeln( 'serial ', header^.SerialNum[0], header^.SerialNum[1], ' logblock ', header^.LogBlock, ' filler ', header^.Filler, ' NextAdr ', header^.NextAdr[0], header^.NextAdr[1], ' PrevAdr ', header^.PrevAdr[0], header^.PrevAdr[1] );}
  
          if status^.SoftStatus = IOEIOC then
           success := true;
                      
          {Yes, this is stupid, got fed up trying to get 'else' to work.}
          if status^.SoftStatus <> IOEIOC then
           begin
            writeln('error ', status^.SoftStatus, ' while reading disk.');
            RetryCount := RetryCount + 1;
           end;
          end;
          
        if (not success) then
         begin
         writeln('retries unsuccessful, data may be unusable for this sector');
        
         for i := 0 to 255 do
          begin
           {$R-}
           buf^[i] := 21845;
           {$R+}
          end;
           
         end;
         
        { Write header block }
        WriteDbl( header^.SerialNum );
        WriteInt( header^.LogBlock );
        WriteInt( header^.Filler );
        WriteDbl( header^.NextAdr );
        WriteDbl( header^.PrevAdr );
        
        { Write data block }
        for i := 0 to 255 do
        begin
         {$R-}
         WriteInt( buf^[i] );
                  
         {$R+}
         {write( low, high ); }

               
         end;
      end;
    end;
   end;
   
 
   
end.
