Module ReadDisk;
{--------------------------------------------------------------------------
{
{ Abstract:
{
{   Module to Read and write to the disk using a buffer system

   Written by the CMU Spice Group
--------------------------------------------------------------------------}

{--------------------------------------------------------------------------
 Versions:

     12 Jan 82  BAM   V1.5  Fixed FlushFail bugs in FlushAll, ForgetAll. 
      3 Dec 81  BAM   V1.4  Change FlushFail to provide more information. 
                             Change FlushBuffer to get the info.
     12 May 81  BAM   V1.3  Add exception for Flush failure
     20 Apr 81  JPS   V1.2  Make ReadDisk use its own segment (BufferSegment)
                            rather than DiskIO's (DiskSegment).
                            Set the BufferSegment and UnSwappable for virtual
                            memory.
     14 Apr 81  BAM   V1.1  Fixed ForgetAll to set Flags to false.
     19 Mar 81  BAM   V1.0  Changed Bit32 to FSBit32.
     17 Mar 81  GGR   V0.1  Changed number of buffers from 4 to 8.
     ?? ??? ??  CMU Spice Group  V0.0  Started
--------------------------------------------------------------------------}


{******************} exports {***************************}
imports DiskIO from DiskIO;

function  ReadDisk(addr : DiskAddr)     : ptrDiskBuffer;
function  ChangeDisk(addr : DiskAddr)   : ptrDiskBuffer;
function  ReadHeader(addr : DiskAddr)   : ptrHeader;
function  ChangeHeader(addr : DiskAddr) : ptrHeader;
procedure FlushDisk(addr : DiskAddr);
procedure WriteDisk(addr : DiskAddr; ptr : ptrDiskBuffer; hdptr : ptrHeader);
procedure WriteHeader(addr : DiskAddr; ptr : ptrDiskBuffer; hdptr : ptrHeader);

procedure InitBuffers;
function  FindDiskBuffer(dskaddr : DiskAddr; alwaysfind : boolean) : integer;
procedure ReleaseBuffer(indx : integer);
procedure FlushBuffer(indx : integer);
procedure FlushAll;
procedure ChangeBuffer(indx : integer);
procedure ChgHdr(indx : integer);
procedure UseBuffer(indx,numtimes : integer);
function  BufferPointer(indx : integer) : ptrDiskBuffer;
function  HeaderPointer(indx : integer) : ptrHeader;
function  ReadAhead(addr : DiskAddr)     : ptrDiskBuffer;
procedure ForgetAll;

Exception FlushFail(msg: String; operation: DiskCommand; addr: DiskAddr;
                       softStat: integer);
{--------------------------------------------------------------------------
  Abstract: Raised when the system is unable to flush out a buffer.  The buffer
            is marked as flushed out, however, so the error will not repeat
            the next time a buffer needs to be flushed
  Parameters: Same as DiskFailure (in DiskIO)
  Resume: ALLOWED, but has no effect (procedure will return normally as if
           flush had been successful)
--------------------------------------------------------------------------}

{******************} private {***************************}
