Module FileTypes;
{-----------------------------------------------------------------------------
{
{ Abstract:

 This module exports the Types put in the FileType field of File FIBs.  The
 types are stored as integers.  Three Rivers reserves the first 512 types for
 their use.  Customers are encouraged to choose numbers > 512 if they invent
 new file types
 
 Written by Brad A. Myers  Feb. 2, 1981
 
 Copyright (C) 1980 Three Rivers Computer Corporation
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
   Versions:
      V1.2  1-May-81  Brad Myers   Added SwapFile and BadFile
                                   Changed name of BootFile to SBootFile to
                                     remove name conflict
      V1.1 31-Mar-81  Brad Myers   Added BootFile and MBootFile
      V1.0  2-Feb-81  Brad Myers   Started
-----------------------------------------------------------------------------}

{\\\\\\\\\\\\\\\\\\\\\\\\\\} EXPORTS {/////////////////////////}

Const
      UnknownFile = 0;
      SegFile = 1;
      PasFile = 2;
      DirFile = 3;
      ExDirFile = 4;
      FontFile = 5;
      RunFile = 6;
      TextFile = 7;     {for non-Pas text files}
      CursorFile = 8;   {cursor bin files}
      BinaryFile = 9;
      BinFile = 10;     {microcode output}
      MicroFile = 11;
      ComFile = 12;
      RelFile = 13;
      IncludeFile = 14; {included in a pas file}
      SBootFile = 15; {system part of boot file}
      MBootFile = 16; {microcode part}
      SwapFile = 17; {a file used for swapping by compiler or editor; length
                        not set}
      BadFile = 18;  {created by the scavenger}
      

{\\\\\\\\\\\\\\\\\\\\\\\\\\} PRIVATE {/////////////////////////}
