module FileAccess;
{---------------------------------------------------------------------------
{
{ Abstract:
{ Module to handle reading, writing, entering and deleting files independant
{ from the directory structure.
{
{ Written by the CMU Spice Group
---------------------------------------------------------------------------}

{---------------------------------------------------------------------------
  Change history.

   28 May 81  V1.7 BAM  Changes to Lights module.
   26 May 81  V1.6 JPS  Use new Lights module.
   19 May 81  V1.5 BAM  Fix position of scavenge light.
   12 May 81  V1.4 BAM  Prevent scavenge from being recursive.
    7 Mar 81  V1.3 JPS  Use DiskSegment for memory allocation.
   30 Mar 81  V1.2 BAM  Renamed from SpiceSeg
   27 Mar 81  V1.1 BAM  Added comments; fixed truncate
   19 Mar 81  V1.0 BAM  Changed Bit32 to FSBit32; add FBLANKSIZE to Index
   17 Mar 81  V0.2 GGR  Fixed bug in SegAddr checking for logical block
                         inconsistency.
    6 Mar 81  V0.1 JPS  Export the Index procedure.
    ? ??? ??  V0.0 CMU-Spice Group  Started
---------------------------------------------------------------------------}


{******************} exports {***************************}

imports Arith from Arith;
imports DiskIO from DiskIO;
imports AllocDisk from AllocDisk;

function  CreateSpiceSegment(partition : integer; kind : SpiceSegKind) : SegID;
procedure DestroySpiceSegment(id : SegID);
procedure TruncateSpiceSegment(id : SegID; len : integer);
procedure ReadSpiceSegment(id : SegID; firstblk,numblks : integer; 
                           ptr : ptrDiskBuffer);
procedure WriteSpiceSegment(id : SegID; firstblk,numblks : integer;
                            ptr : ptrDiskBuffer);
procedure Index(logblk : integer; var indblk,indoff : integer);

Exception BadLength(len: integer);
{---------------------------------------------------------------------------
 Abstract: Raised if try to truncate file to a length < 0
 Parameters: len is bad length
---------------------------------------------------------------------------}

Exception NotAFile(id: SegID);
{---------------------------------------------------------------------------
 Abstract: Raised when an operation is attempted and the SegID passed does not
            seem to be the id for a valid file
 Parameters: id is the bad id
---------------------------------------------------------------------------}

{******************} private {***************************}
