Module ViewPt;
Exports
imports AccentType from AccentType;
imports AccInt from AccentUser;
procedure InitViewPt;
imports SapphDefs from SapphDefs;
imports ViewKern from ViewKern;
Function MakeViewport(
ServPort :Viewport;
x :integer;
y :integer;
w :integer;
h :integer;
rank :integer;
memory :boolean;
courteous :boolean;
transparent :boolean
):Viewport;
Procedure DestroyViewport(
ServPort :Viewport
);
Procedure ViewportState(
ServPort :Viewport;
var curlx :integer;
var curty :integer;
var curwidth :integer;
var curheight :integer;
var curRank :integer;
var memory :boolean;
var courteous :boolean;
var transparent :boolean
);
Procedure ModifyVP(
ServPort :Viewport;
newlx :integer;
newty :integer;
newwidth :integer;
newheight :integer;
newrank :integer;
wantVpChEx :boolean
);
Procedure EnableNotifyExceptions(
ServPort :Viewport;
notifyPort :Port;
changed :boolean;
exposed :boolean
);
Function GetVPRank(
ServPort :Viewport
):integer;
Procedure ReserveScreen(
ServPort :Viewport;
reserve :boolean
);
Function GetFullViewport(
ServPort :Viewport
):Viewport;
Procedure VPtoScreenCoords(
ServPort :Viewport;
x :integer;
y :integer;
var scrX :integer;
var scrY :integer
);
Procedure ScreenToVPCoords(
ServPort :Viewport;
scrX :integer;
scrY :integer;
var x :integer;
var y :integer
);
Procedure ViewROP(
ServPort :Viewport;
funct :RopFunct;
dx :integer;
dy :integer;
width :integer;
height :integer;
srcVP :Viewport;
sx :integer;
sy :integer
);
Procedure ViewColorRect(
ServPort :Viewport;
funct :RectColorFunct;
x :integer;
y :integer;
width :integer;
height :integer
);
Procedure ViewScroll(
ServPort :Viewport;
x :integer;
y :integer;
width :integer;
height :integer;
Xamt :integer;
Yamt :integer
);
Procedure ViewLine(
ServPort :Viewport;
funct :LineFunct;
x1 :integer;
y1 :integer;
x2 :integer;
y2 :integer
);
Procedure ViewString(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
var dx :integer;
var dy :integer;
str :VPStr255;
firstCh :integer;
var lastch :integer
);
Procedure ViewChArray(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
var dx :integer;
var dy :integer;
chars :pVPCharArray;
chars_Cnt :long;
firstCh :integer;
var lastch :integer
);
Procedure ViewChar(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
var dx :integer;
var dy :integer;
ch :char
);
Procedure ViewPutString(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
dx :integer;
dy :integer;
str :VPStr255;
firstCh :integer;
lastch :integer
);
Procedure ViewPutChArray(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
dx :integer;
dy :integer;
chars :pVPCharArray;
chars_Cnt :long;
firstCh :integer;
lastch :integer
);
Procedure ViewPutChar(
ServPort :Viewport;
fontVP :Viewport;
funct :RopFunct;
dx :integer;
dy :integer;
ch :char
);
Procedure FontSize(
ServPort :Viewport;
var name :String;
var PointSize :integer;
var Rotation :integer;
var FaceCode :integer;
var maxWidth :integer;
var maxHeight :integer;
var xOrigin :integer;
var yOrigin :integer;
var fixedWidth :boolean;
var fixedHeight :boolean
);
Procedure FontCharWidthVector(
ServPort :Viewport;
ch :char;
var dx :integer;
var dy :integer
);
Procedure FontStringWidthVector(
ServPort :Viewport;
str :VPStr255;
firstCh :integer;
lastch :integer;
var dx :integer;
var dy :integer
);
Function LoadFont(
ServPort :Viewport;
fileName :VPStr255
):Viewport;
Function GetSysFont(
ServPort :Viewport
):Viewport;
Function LoadVPPicture(
ServPort :Viewport;
fileName :VPStr255;
width :integer;
height :integer
):Viewport;
Procedure PutViewportBit(
ServPort :Viewport;
x :integer;
y :integer;
value :boolean
);
Function GetViewportBit(
ServPort :Viewport;
x :integer;
y :integer;
var value :boolean
):boolean;
Procedure PutViewportRectangle(
ServPort :Viewport;
Funct :RopFunct;
x :integer;
y :integer;
width :integer;
height :integer;
Data :pVPIntegerArray;
Data_Cnt :long;
WordsAcross :integer;
ux :integer;
uy :integer
);
Function GetViewportRectangle(
ServPort :Viewport;
x :integer;
y :integer;
width :integer;
height :integer;
var Data :pVPIntegerArray;
var Data_Cnt :long;
var WordsAcross :integer;
ux :integer;
uy :integer
):boolean;
Procedure EnableInput(
ServPort :Viewport;
keytrantab :VPStr255;
timeout :integer
);
Procedure SetListener(
ServPort :Viewport
);
Function GetEvent(
ServPort :Viewport;
howWait :KeyHowWait
):KeyEvent;
Function FlushEvents(
ServPort :Viewport
):boolean;
Procedure PushRegion(
ServPort :Viewport;
regionNum :integer;
leftx :integer;
topy :integer;
width :integer;
height :integer
);
Procedure DeleteRegion(
ServPort :Viewport;
regionNum :integer
);
Procedure DestroyRegions(
ServPort :Viewport
);
Procedure ModifyRegion(
ServPort :Viewport;
regionNum :integer;
leftx :integer;
topy :integer;
width :integer;
height :integer
);
Procedure SetRegionCursor(
ServPort :Viewport;
regionNum :integer;
cursorImage :CursorSet;
cursIndex :integer;
cursFunc :CursorFunction;
track :boolean
);
Procedure GetRegionCursor(
ServPort :Viewport;
regionNum :integer;
var cursorImage :CursorSet;
var cursIndex :integer;
var cursFunc :CursorFunction;
var track :boolean
);
Procedure SetRegionParms(
ServPort :Viewport;
regionNum :integer;
absolute :boolean;
speed :integer;
minx :integer;
maxx :integer;
miny :integer;
maxy :integer;
modx :integer;
posx :integer;
mody :integer;
posy :integer
);
Procedure GetRegionParms(
ServPort :Viewport;
regionNum :integer;
var absolute :boolean;
var speed :integer;
var minx :integer;
var maxx :integer;
var miny :integer;
var maxy :integer;
var modx :integer;
var posx :integer;
var mody :integer;
var posy :integer
);
Function LoadVPCursors(
ServPort :Viewport;
fileName :VPStr255;
var numCursors :integer
):CursorSet;
Procedure DestroyVPCursors(
ServPort :CursorSet
);
Procedure SetCursorPos(
ServPort :Viewport;
x :integer;
y :integer
);
Procedure ReserveCursor(
ServPort :Viewport;
reserve :boolean
);
Exception VPNIY;
Exception UserError(
s :String
);
Exception Impossible(
s :String
);
Private
 { Stub created by MakeStub at15-Feb-84  17:30:53 }
begin
end.
