/*	$NetBSD: syscallargs.h,v 1.78.2.1 2000/10/06 15:47:29 he Exp $	*/

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.90.2.2 2000/10/06 15:46:29 he Exp 
 */

#ifndef _SYS__SYSCALLARGS_H_
#define _SYS__SYSCALLARGS_H_

#ifdef	syscallarg
#undef	syscallarg
#endif

#define	syscallarg(x)								\
		union {								\
			register_t pad;						\
			struct { x datum; } le;					\
			struct {						\
				int8_t pad[ (sizeof (register_t) < sizeof (x))	\
					? 0					\
					: sizeof (register_t) - sizeof (x)];	\
				x datum;					\
			} be;							\
		}

struct sys_exit_args {
	syscallarg(int) rval;
};

struct sys_read_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_write_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(mode_t) mode;
};

struct sys_close_args {
	syscallarg(int) fd;
};

struct sys_wait4_args {
	syscallarg(int) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage *) rusage;
};

struct compat_43_sys_creat_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_link_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_unlink_args {
	syscallarg(const char *) path;
};

struct sys_chdir_args {
	syscallarg(const char *) path;
};

struct sys_fchdir_args {
	syscallarg(int) fd;
};

struct sys_mknod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(dev_t) dev;
};

struct sys_chmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_obreak_args {
	syscallarg(char *) nsize;
};

struct sys_getfsstat_args {
	syscallarg(struct statfs *) buf;
	syscallarg(long) bufsize;
	syscallarg(int) flags;
};

struct compat_43_sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(long) offset;
	syscallarg(int) whence;
};

struct sys_mount_args {
	syscallarg(const char *) type;
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(void *) data;
};

struct sys_unmount_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_setuid_args {
	syscallarg(uid_t) uid;
};

struct sys_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(caddr_t) addr;
	syscallarg(int) data;
};

struct sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(const struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(struct sockaddr *) from;
	syscallarg(unsigned int *) fromlenaddr;
};

struct sys_accept_args {
	syscallarg(int) s;
	syscallarg(struct sockaddr *) name;
	syscallarg(unsigned int *) anamelen;
};

struct sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(unsigned int *) alen;
};

struct sys_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(unsigned int *) alen;
};

struct sys_access_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_chflags_args {
	syscallarg(const char *) path;
	syscallarg(u_long) flags;
};

struct sys_fchflags_args {
	syscallarg(int) fd;
	syscallarg(u_long) flags;
};

struct sys_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};

struct compat_43_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct compat_43_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct sys_dup_args {
	syscallarg(int) fd;
};

struct sys_profil_args {
	syscallarg(caddr_t) samples;
	syscallarg(size_t) size;
	syscallarg(u_long) offset;
	syscallarg(u_int) scale;
};

struct sys_ktrace_args {
	syscallarg(const char *) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};

struct compat_13_sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction13 *) nsa;
	syscallarg(struct sigaction13 *) osa;
};

struct compat_13_sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(int) mask;
};

struct sys___getlogin_args {
	syscallarg(char *) namebuf;
	syscallarg(size_t) namelen;
};

struct sys_setlogin_args {
	syscallarg(const char *) namebuf;
};

struct sys_acct_args {
	syscallarg(const char *) path;
};

struct compat_13_sys_sigaltstack_args {
	syscallarg(const struct sigaltstack13 *) nss;
	syscallarg(struct sigaltstack13 *) oss;
};

struct sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(void *) data;
};

struct compat_12_sys_reboot_args {
	syscallarg(int) opt;
};

struct sys_revoke_args {
	syscallarg(const char *) path;
};

struct sys_symlink_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_readlink_args {
	syscallarg(const char *) path;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_execve_args {
	syscallarg(const char *) path;
	syscallarg(char *const *) argp;
	syscallarg(char *const *) envp;
};

struct sys_umask_args {
	syscallarg(mode_t) newmask;
};

struct sys_chroot_args {
	syscallarg(const char *) path;
};

struct compat_43_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat43 *) sb;
};

struct compat_43_sys_getkerninfo_args {
	syscallarg(int) op;
	syscallarg(char *) where;
	syscallarg(int *) size;
	syscallarg(int) arg;
};

struct compat_12_sys_msync_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
};

struct sys_sbrk_args {
	syscallarg(int) incr;
};

struct sys_sstk_args {
	syscallarg(int) incr;
};

struct compat_43_sys_mmap_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pos;
};

struct sys_ovadvise_args {
	syscallarg(int) anom;
};

struct sys_munmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};

struct sys_mprotect_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
};

struct sys_madvise_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) behav;
};

struct sys_mincore_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(char *) vec;
};

struct sys_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(gid_t *) gidset;
};

struct sys_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(const gid_t *) gidset;
};

struct sys_setpgid_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};

struct sys_setitimer_args {
	syscallarg(int) which;
	syscallarg(const struct itimerval *) itv;
	syscallarg(struct itimerval *) oitv;
};

struct compat_12_sys_swapon_args {
	syscallarg(const char *) name;
};

struct sys_getitimer_args {
	syscallarg(int) which;
	syscallarg(struct itimerval *) itv;
};

struct compat_43_sys_gethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct compat_43_sys_sethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct sys_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};

struct sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

struct sys_select_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(struct timeval *) tv;
};

struct sys_fsync_args {
	syscallarg(int) fd;
};

struct sys_setpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
	syscallarg(int) prio;
};

struct sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct sys_connect_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(unsigned int) namelen;
};

struct compat_43_sys_accept_args {
	syscallarg(int) s;
	syscallarg(caddr_t) name;
	syscallarg(int *) anamelen;
};

struct sys_getpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
};

struct compat_43_sys_send_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_43_sys_recv_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_13_sys_sigreturn_args {
	syscallarg(struct sigcontext13 *) sigcntxp;
};

struct sys_bind_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(unsigned int) namelen;
};

struct sys_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(const void *) val;
	syscallarg(unsigned int) valsize;
};

struct sys_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};

struct compat_43_sys_sigvec_args {
	syscallarg(int) signum;
	syscallarg(struct sigvec *) nsv;
	syscallarg(struct sigvec *) osv;
};

struct compat_43_sys_sigblock_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigsetmask_args {
	syscallarg(int) mask;
};

struct compat_13_sys_sigsuspend_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigstack_args {
	syscallarg(struct sigstack *) nss;
	syscallarg(struct sigstack *) oss;
};

struct compat_43_sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct omsghdr *) msg;
	syscallarg(int) flags;
};

struct compat_43_sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(caddr_t) msg;
	syscallarg(int) flags;
};

struct sys_vtrace_args {
	syscallarg(int) request;
	syscallarg(int) value;
};

struct sys_gettimeofday_args {
	syscallarg(struct timeval *) tp;
	syscallarg(struct timezone *) tzp;
};

struct sys_getrusage_args {
	syscallarg(int) who;
	syscallarg(struct rusage *) rusage;
};

struct sys_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(void *) val;
	syscallarg(unsigned int *) avalsize;
};

struct sys_readv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_writev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_settimeofday_args {
	syscallarg(const struct timeval *) tv;
	syscallarg(const struct timezone *) tzp;
};

struct sys_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_fchmod_args {
	syscallarg(int) fd;
	syscallarg(mode_t) mode;
};

struct compat_43_sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(caddr_t) from;
	syscallarg(int *) fromlenaddr;
};

struct sys_setreuid_args {
	syscallarg(uid_t) ruid;
	syscallarg(uid_t) euid;
};

struct sys_setregid_args {
	syscallarg(gid_t) rgid;
	syscallarg(gid_t) egid;
};

struct sys_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};

struct compat_43_sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(long) length;
};

struct compat_43_sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(long) length;
};

struct sys_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};

struct sys_mkfifo_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_sendto_args {
	syscallarg(int) s;
	syscallarg(const void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(const struct sockaddr *) to;
	syscallarg(unsigned int) tolen;
};

struct sys_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};

struct sys_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(int *) rsv;
};

struct sys_mkdir_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_rmdir_args {
	syscallarg(const char *) path;
};

struct sys_utimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};

struct sys_adjtime_args {
	syscallarg(const struct timeval *) delta;
	syscallarg(struct timeval *) olddelta;
};

struct compat_43_sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(caddr_t) asa;
	syscallarg(int *) alen;
};

struct compat_43_sys_sethostid_args {
	syscallarg(int32_t) hostid;
};

struct compat_43_sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct orlimit *) rlp;
};

struct compat_43_sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct orlimit *) rlp;
};

struct compat_43_sys_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};

struct sys_quotactl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(caddr_t) arg;
};

struct compat_43_sys_getsockname_args {
	syscallarg(int) fdec;
	syscallarg(caddr_t) asa;
	syscallarg(int *) alen;
};

struct sys_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(void *) argp;
};

struct compat_43_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};

struct sys_statfs_args {
	syscallarg(const char *) path;
	syscallarg(struct statfs *) buf;
};

struct sys_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct statfs *) buf;
};

struct sys_getfh_args {
	syscallarg(const char *) fname;
	syscallarg(fhandle_t *) fhp;
};

struct compat_09_sys_getdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_setdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_uname_args {
	syscallarg(struct outsname *) name;
};

struct sys_sysarch_args {
	syscallarg(int) op;
	syscallarg(void *) parms;
};

struct compat_10_sys_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};

struct compat_10_sys_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};

struct compat_10_sys_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};

struct sys_pread_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys_pwrite_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys_ntp_gettime_args {
	syscallarg(struct ntptimeval *) ntvp;
};

struct sys_ntp_adjtime_args {
	syscallarg(struct timex *) tp;
};

struct sys_setgid_args {
	syscallarg(gid_t) gid;
};

struct sys_setegid_args {
	syscallarg(gid_t) egid;
};

struct sys_seteuid_args {
	syscallarg(uid_t) euid;
};

struct lfs_bmapv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct lfs_markv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct lfs_segclean_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(u_long) segment;
};

struct lfs_segwait_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct timeval *) tv;
};

struct compat_12_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};

struct compat_12_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat12 *) sb;
};

struct compat_12_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};

struct sys_pathconf_args {
	syscallarg(const char *) path;
	syscallarg(int) name;
};

struct sys_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};

struct sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct rlimit *) rlp;
};

struct sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct rlimit *) rlp;
};

struct compat_12_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};

struct sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pad;
	syscallarg(off_t) pos;
};

struct sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
	syscallarg(int) whence;
};

struct sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys___sysctl_args {
	syscallarg(int *) name;
	syscallarg(u_int) namelen;
	syscallarg(void *) old;
	syscallarg(size_t *) oldlenp;
	syscallarg(void *) new;
	syscallarg(size_t) newlen;
};

struct sys_mlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_munlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_undelete_args {
	syscallarg(const char *) path;
};

struct sys_futimes_args {
	syscallarg(int) fd;
	syscallarg(const struct timeval *) tptr;
};

struct sys_getpgid_args {
	syscallarg(pid_t) pid;
};

struct sys_reboot_args {
	syscallarg(int) opt;
	syscallarg(char *) bootstr;
};

struct sys_poll_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(int) timeout;
};

struct sys___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union semun *) arg;
};

struct sys_semget_args {
	syscallarg(key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};

struct sys_semop_args {
	syscallarg(int) semid;
	syscallarg(struct sembuf *) sops;
	syscallarg(size_t) nsops;
};

struct sys_semconfig_args {
	syscallarg(int) flag;
};

struct sys_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds *) buf;
};

struct sys_msgget_args {
	syscallarg(key_t) key;
	syscallarg(int) msgflg;
};

struct sys_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(const void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(int) msgflg;
};

struct sys_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(long) msgtyp;
	syscallarg(int) msgflg;
};

struct sys_shmat_args {
	syscallarg(int) shmid;
	syscallarg(const void *) shmaddr;
	syscallarg(int) shmflg;
};

struct sys_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds *) buf;
};

struct sys_shmdt_args {
	syscallarg(const void *) shmaddr;
};

struct sys_shmget_args {
	syscallarg(key_t) key;
	syscallarg(size_t) size;
	syscallarg(int) shmflg;
};

struct sys_clock_gettime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_clock_settime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const struct timespec *) tp;
};

struct sys_clock_getres_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_nanosleep_args {
	syscallarg(const struct timespec *) rqtp;
	syscallarg(struct timespec *) rmtp;
};

struct sys_fdatasync_args {
	syscallarg(int) fd;
};

struct sys___posix_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};

struct sys_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(const void *) arg;
	syscallarg(int) misc;
};

struct sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_minherit_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) inherit;
};

struct sys_lchmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_lutimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};

struct sys___msync13_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) flags;
};

struct sys___stat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys___fstat13_args {
	syscallarg(int) fd;
	syscallarg(struct stat *) sb;
};

struct sys___lstat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys___sigaltstack14_args {
	syscallarg(const struct sigaltstack *) nss;
	syscallarg(struct sigaltstack *) oss;
};

struct sys___posix_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys___posix_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys___posix_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_getsid_args {
	syscallarg(pid_t) pid;
};

struct sys_fktrace_args {
	syscallarg(const int) fd;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};

struct sys_preadv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys_pwritev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys___sigaction14_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
};

struct sys___sigpending14_args {
	syscallarg(sigset_t *) set;
};

struct sys___sigprocmask14_args {
	syscallarg(int) how;
	syscallarg(const sigset_t *) set;
	syscallarg(sigset_t *) oset;
};

struct sys___sigsuspend14_args {
	syscallarg(const sigset_t *) set;
};

struct sys___sigreturn14_args {
	syscallarg(struct sigcontext *) sigcntxp;
};

struct sys___getcwd_args {
	syscallarg(char *) bufp;
	syscallarg(size_t) length;
};

struct sys_fchroot_args {
	syscallarg(int) fd;
};

/*
 * System call prototypes.
 */

int	sys_exit	__P((struct proc *, void *, register_t *));
int	sys_fork	__P((struct proc *, void *, register_t *));
int	sys_read	__P((struct proc *, void *, register_t *));
int	sys_write	__P((struct proc *, void *, register_t *));
int	sys_open	__P((struct proc *, void *, register_t *));
int	sys_close	__P((struct proc *, void *, register_t *));
int	sys_wait4	__P((struct proc *, void *, register_t *));
int	compat_43_sys_creat	__P((struct proc *, void *, register_t *));
int	sys_link	__P((struct proc *, void *, register_t *));
int	sys_unlink	__P((struct proc *, void *, register_t *));
int	sys_chdir	__P((struct proc *, void *, register_t *));
int	sys_fchdir	__P((struct proc *, void *, register_t *));
int	sys_mknod	__P((struct proc *, void *, register_t *));
int	sys_chmod	__P((struct proc *, void *, register_t *));
int	sys_chown	__P((struct proc *, void *, register_t *));
int	sys_obreak	__P((struct proc *, void *, register_t *));
int	sys_getfsstat	__P((struct proc *, void *, register_t *));
int	compat_43_sys_lseek	__P((struct proc *, void *, register_t *));
int	sys_getpid	__P((struct proc *, void *, register_t *));
int	sys_mount	__P((struct proc *, void *, register_t *));
int	sys_unmount	__P((struct proc *, void *, register_t *));
int	sys_setuid	__P((struct proc *, void *, register_t *));
int	sys_getuid	__P((struct proc *, void *, register_t *));
int	sys_geteuid	__P((struct proc *, void *, register_t *));
int	sys_ptrace	__P((struct proc *, void *, register_t *));
int	sys_recvmsg	__P((struct proc *, void *, register_t *));
int	sys_sendmsg	__P((struct proc *, void *, register_t *));
int	sys_recvfrom	__P((struct proc *, void *, register_t *));
int	sys_accept	__P((struct proc *, void *, register_t *));
int	sys_getpeername	__P((struct proc *, void *, register_t *));
int	sys_getsockname	__P((struct proc *, void *, register_t *));
int	sys_access	__P((struct proc *, void *, register_t *));
int	sys_chflags	__P((struct proc *, void *, register_t *));
int	sys_fchflags	__P((struct proc *, void *, register_t *));
int	sys_sync	__P((struct proc *, void *, register_t *));
int	sys_kill	__P((struct proc *, void *, register_t *));
int	compat_43_sys_stat	__P((struct proc *, void *, register_t *));
int	sys_getppid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_lstat	__P((struct proc *, void *, register_t *));
int	sys_dup	__P((struct proc *, void *, register_t *));
int	sys_pipe	__P((struct proc *, void *, register_t *));
int	sys_getegid	__P((struct proc *, void *, register_t *));
int	sys_profil	__P((struct proc *, void *, register_t *));
#ifdef KTRACE
int	sys_ktrace	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_13_sys_sigaction	__P((struct proc *, void *, register_t *));
int	sys_getgid	__P((struct proc *, void *, register_t *));
int	compat_13_sys_sigprocmask	__P((struct proc *, void *, register_t *));
int	sys___getlogin	__P((struct proc *, void *, register_t *));
int	sys_setlogin	__P((struct proc *, void *, register_t *));
int	sys_acct	__P((struct proc *, void *, register_t *));
int	compat_13_sys_sigpending	__P((struct proc *, void *, register_t *));
int	compat_13_sys_sigaltstack	__P((struct proc *, void *, register_t *));
int	sys_ioctl	__P((struct proc *, void *, register_t *));
int	compat_12_sys_reboot	__P((struct proc *, void *, register_t *));
int	sys_revoke	__P((struct proc *, void *, register_t *));
int	sys_symlink	__P((struct proc *, void *, register_t *));
int	sys_readlink	__P((struct proc *, void *, register_t *));
int	sys_execve	__P((struct proc *, void *, register_t *));
int	sys_umask	__P((struct proc *, void *, register_t *));
int	sys_chroot	__P((struct proc *, void *, register_t *));
int	compat_43_sys_fstat	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getkerninfo	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getpagesize	__P((struct proc *, void *, register_t *));
int	compat_12_sys_msync	__P((struct proc *, void *, register_t *));
int	sys_vfork	__P((struct proc *, void *, register_t *));
int	sys_sbrk	__P((struct proc *, void *, register_t *));
int	sys_sstk	__P((struct proc *, void *, register_t *));
int	compat_43_sys_mmap	__P((struct proc *, void *, register_t *));
int	sys_ovadvise	__P((struct proc *, void *, register_t *));
int	sys_munmap	__P((struct proc *, void *, register_t *));
int	sys_mprotect	__P((struct proc *, void *, register_t *));
int	sys_madvise	__P((struct proc *, void *, register_t *));
int	sys_mincore	__P((struct proc *, void *, register_t *));
int	sys_getgroups	__P((struct proc *, void *, register_t *));
int	sys_setgroups	__P((struct proc *, void *, register_t *));
int	sys_getpgrp	__P((struct proc *, void *, register_t *));
int	sys_setpgid	__P((struct proc *, void *, register_t *));
int	sys_setitimer	__P((struct proc *, void *, register_t *));
int	compat_43_sys_wait	__P((struct proc *, void *, register_t *));
int	compat_12_sys_swapon	__P((struct proc *, void *, register_t *));
int	sys_getitimer	__P((struct proc *, void *, register_t *));
int	compat_43_sys_gethostname	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sethostname	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getdtablesize	__P((struct proc *, void *, register_t *));
int	sys_dup2	__P((struct proc *, void *, register_t *));
int	sys_fcntl	__P((struct proc *, void *, register_t *));
int	sys_select	__P((struct proc *, void *, register_t *));
int	sys_fsync	__P((struct proc *, void *, register_t *));
int	sys_setpriority	__P((struct proc *, void *, register_t *));
int	sys_socket	__P((struct proc *, void *, register_t *));
int	sys_connect	__P((struct proc *, void *, register_t *));
int	compat_43_sys_accept	__P((struct proc *, void *, register_t *));
int	sys_getpriority	__P((struct proc *, void *, register_t *));
int	compat_43_sys_send	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recv	__P((struct proc *, void *, register_t *));
int	compat_13_sys_sigreturn	__P((struct proc *, void *, register_t *));
int	sys_bind	__P((struct proc *, void *, register_t *));
int	sys_setsockopt	__P((struct proc *, void *, register_t *));
int	sys_listen	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigvec	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigblock	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigsetmask	__P((struct proc *, void *, register_t *));
int	compat_13_sys_sigsuspend	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigstack	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recvmsg	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sendmsg	__P((struct proc *, void *, register_t *));
#ifdef TRACE
int	sys_vtrace	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_gettimeofday	__P((struct proc *, void *, register_t *));
int	sys_getrusage	__P((struct proc *, void *, register_t *));
int	sys_getsockopt	__P((struct proc *, void *, register_t *));
int	sys_readv	__P((struct proc *, void *, register_t *));
int	sys_writev	__P((struct proc *, void *, register_t *));
int	sys_settimeofday	__P((struct proc *, void *, register_t *));
int	sys_fchown	__P((struct proc *, void *, register_t *));
int	sys_fchmod	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recvfrom	__P((struct proc *, void *, register_t *));
int	sys_setreuid	__P((struct proc *, void *, register_t *));
int	sys_setregid	__P((struct proc *, void *, register_t *));
int	sys_rename	__P((struct proc *, void *, register_t *));
int	compat_43_sys_truncate	__P((struct proc *, void *, register_t *));
int	compat_43_sys_ftruncate	__P((struct proc *, void *, register_t *));
int	sys_flock	__P((struct proc *, void *, register_t *));
int	sys_mkfifo	__P((struct proc *, void *, register_t *));
int	sys_sendto	__P((struct proc *, void *, register_t *));
int	sys_shutdown	__P((struct proc *, void *, register_t *));
int	sys_socketpair	__P((struct proc *, void *, register_t *));
int	sys_mkdir	__P((struct proc *, void *, register_t *));
int	sys_rmdir	__P((struct proc *, void *, register_t *));
int	sys_utimes	__P((struct proc *, void *, register_t *));
int	sys_adjtime	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getpeername	__P((struct proc *, void *, register_t *));
int	compat_43_sys_gethostid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sethostid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getrlimit	__P((struct proc *, void *, register_t *));
int	compat_43_sys_setrlimit	__P((struct proc *, void *, register_t *));
int	compat_43_sys_killpg	__P((struct proc *, void *, register_t *));
int	sys_setsid	__P((struct proc *, void *, register_t *));
int	sys_quotactl	__P((struct proc *, void *, register_t *));
int	compat_43_sys_quota	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getsockname	__P((struct proc *, void *, register_t *));
#if defined(NFS) || defined(NFSSERVER)
int	sys_nfssvc	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_43_sys_getdirentries	__P((struct proc *, void *, register_t *));
int	sys_statfs	__P((struct proc *, void *, register_t *));
int	sys_fstatfs	__P((struct proc *, void *, register_t *));
#if defined(NFS) || defined(NFSSERVER)
int	sys_getfh	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_09_sys_getdomainname	__P((struct proc *, void *, register_t *));
int	compat_09_sys_setdomainname	__P((struct proc *, void *, register_t *));
int	compat_09_sys_uname	__P((struct proc *, void *, register_t *));
int	sys_sysarch	__P((struct proc *, void *, register_t *));
#if defined(SYSVSEM) && !defined(alpha)
int	compat_10_sys_semsys	__P((struct proc *, void *, register_t *));
#else
#endif
#if defined(SYSVMSG) && !defined(alpha)
int	compat_10_sys_msgsys	__P((struct proc *, void *, register_t *));
#else
#endif
#if defined(SYSVSHM) && !defined(alpha)
int	compat_10_sys_shmsys	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_pread	__P((struct proc *, void *, register_t *));
int	sys_pwrite	__P((struct proc *, void *, register_t *));
int	sys_ntp_gettime	__P((struct proc *, void *, register_t *));
int	sys_ntp_adjtime	__P((struct proc *, void *, register_t *));
int	sys_setgid	__P((struct proc *, void *, register_t *));
int	sys_setegid	__P((struct proc *, void *, register_t *));
int	sys_seteuid	__P((struct proc *, void *, register_t *));
#ifdef LFS
int	lfs_bmapv	__P((struct proc *, void *, register_t *));
int	lfs_markv	__P((struct proc *, void *, register_t *));
int	lfs_segclean	__P((struct proc *, void *, register_t *));
int	lfs_segwait	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_12_sys_stat	__P((struct proc *, void *, register_t *));
int	compat_12_sys_fstat	__P((struct proc *, void *, register_t *));
int	compat_12_sys_lstat	__P((struct proc *, void *, register_t *));
int	sys_pathconf	__P((struct proc *, void *, register_t *));
int	sys_fpathconf	__P((struct proc *, void *, register_t *));
int	sys_getrlimit	__P((struct proc *, void *, register_t *));
int	sys_setrlimit	__P((struct proc *, void *, register_t *));
int	compat_12_sys_getdirentries	__P((struct proc *, void *, register_t *));
int	sys_mmap	__P((struct proc *, void *, register_t *));
int	sys_lseek	__P((struct proc *, void *, register_t *));
int	sys_truncate	__P((struct proc *, void *, register_t *));
int	sys_ftruncate	__P((struct proc *, void *, register_t *));
int	sys___sysctl	__P((struct proc *, void *, register_t *));
int	sys_mlock	__P((struct proc *, void *, register_t *));
int	sys_munlock	__P((struct proc *, void *, register_t *));
int	sys_undelete	__P((struct proc *, void *, register_t *));
int	sys_futimes	__P((struct proc *, void *, register_t *));
int	sys_getpgid	__P((struct proc *, void *, register_t *));
int	sys_reboot	__P((struct proc *, void *, register_t *));
int	sys_poll	__P((struct proc *, void *, register_t *));
#ifdef LKM
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
#else	/* !LKM */
#endif	/* !LKM */
#ifdef SYSVSEM
int	sys___semctl	__P((struct proc *, void *, register_t *));
int	sys_semget	__P((struct proc *, void *, register_t *));
int	sys_semop	__P((struct proc *, void *, register_t *));
int	sys_semconfig	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVMSG
int	sys_msgctl	__P((struct proc *, void *, register_t *));
int	sys_msgget	__P((struct proc *, void *, register_t *));
int	sys_msgsnd	__P((struct proc *, void *, register_t *));
int	sys_msgrcv	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVSHM
int	sys_shmat	__P((struct proc *, void *, register_t *));
int	sys_shmctl	__P((struct proc *, void *, register_t *));
int	sys_shmdt	__P((struct proc *, void *, register_t *));
int	sys_shmget	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_clock_gettime	__P((struct proc *, void *, register_t *));
int	sys_clock_settime	__P((struct proc *, void *, register_t *));
int	sys_clock_getres	__P((struct proc *, void *, register_t *));
int	sys_nanosleep	__P((struct proc *, void *, register_t *));
int	sys_fdatasync	__P((struct proc *, void *, register_t *));
int	sys___posix_rename	__P((struct proc *, void *, register_t *));
int	sys_swapctl	__P((struct proc *, void *, register_t *));
int	sys_getdents	__P((struct proc *, void *, register_t *));
int	sys_minherit	__P((struct proc *, void *, register_t *));
int	sys_lchmod	__P((struct proc *, void *, register_t *));
int	sys_lchown	__P((struct proc *, void *, register_t *));
int	sys_lutimes	__P((struct proc *, void *, register_t *));
int	sys___msync13	__P((struct proc *, void *, register_t *));
int	sys___stat13	__P((struct proc *, void *, register_t *));
int	sys___fstat13	__P((struct proc *, void *, register_t *));
int	sys___lstat13	__P((struct proc *, void *, register_t *));
int	sys___sigaltstack14	__P((struct proc *, void *, register_t *));
int	sys___vfork14	__P((struct proc *, void *, register_t *));
int	sys___posix_chown	__P((struct proc *, void *, register_t *));
int	sys___posix_fchown	__P((struct proc *, void *, register_t *));
int	sys___posix_lchown	__P((struct proc *, void *, register_t *));
int	sys_getsid	__P((struct proc *, void *, register_t *));
#ifdef KTRACE
int	sys_fktrace	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_preadv	__P((struct proc *, void *, register_t *));
int	sys_pwritev	__P((struct proc *, void *, register_t *));
int	sys___sigaction14	__P((struct proc *, void *, register_t *));
int	sys___sigpending14	__P((struct proc *, void *, register_t *));
int	sys___sigprocmask14	__P((struct proc *, void *, register_t *));
int	sys___sigsuspend14	__P((struct proc *, void *, register_t *));
int	sys___sigreturn14	__P((struct proc *, void *, register_t *));
int	sys___getcwd	__P((struct proc *, void *, register_t *));
int	sys_fchroot	__P((struct proc *, void *, register_t *));
int	sys_issetugid	__P((struct proc *, void *, register_t *));
#endif /* _SYS__SYSCALLARGS_H_ */
