/*	$NetBSD: k_strerror.c,v 1.2 1997/01/09 06:09:05 tls Exp $	*/

#include "krb_locl.h"

const char *
k_strerror(errnum)
	int errnum;
{
#if HAVE_STRERROR
  return strerror(errnum);
#else
  extern int sys_nerr;
  extern char *sys_errlist[];
  static char ebuf[40];		/* 64-bit number + slop */

  if ((unsigned int)errnum < sys_nerr)
    return(sys_errlist[errnum]);
  (void)sprintf(ebuf, "Unknown error: %d", errnum);
  return(ebuf);
#endif /* !HAVE_STRERROR */
}

