/*	$NetBSD: viewvar.h,v 1.4 1996/10/16 12:57:12 leo Exp $	*/

/*
 * Copyright (c) 1994 Christian E. Hopps
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Christian E. Hopps.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* The view major device is a placeholder device.  It serves
 * simply to map the semantics of a graphics dipslay to
 * the semantics of a character block device.  In other
 * words the graphics system as currently built does not like to be
 * refered to by open/close/ioctl.  This device serves as
 * a interface to graphics. */

#define	NOPROC	((struct proc *)-1)	/* XXX */

struct view_softc {
    struct  view_size size;
    view_t *view;
    pid_t   lock_process;
    int     flags;
};

enum view_unit_flag_bits {
    VUB_OPEN,
    VUB_ADDED,
    VUB_DISPLAY,
    VUB_LAST_BIT
};

enum view_unit_flags {
    VUF_OPEN    = 1<<VUB_OPEN,
    VUF_ADDED   = 1<<VUB_ADDED,
    VUF_DISPLAY = 1<<VUB_DISPLAY,
    VUF_MASK    = ((1<<VUB_LAST_BIT)-1)
};

#ifdef _KERNEL
view_t	*viewview __P((dev_t));
int	viewprobe __P((void));

dev_type_close(viewclose);
dev_type_ioctl(viewioctl);
dev_type_open(viewopen);
dev_type_mmap(viewmmap);
dev_type_poll(viewpoll);

#endif /* _KERNEL */
