/*-
 * amigaBW2.c --
 *	Functions for handling the amiga BWTWO board.
 *
 * Copyright (c) 1987 by the Regents of the University of California
 * Copyright (c) 1987 by Adam de Boor, UC Berkeley
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *
 */

/************************************************************
Copyright 1994 by Eduardo Horvath
Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.

                    All Rights Reserved

Permission  to  use,  copy,  modify,  and  distribute   this
software  and  its documentation for any purpose and without
fee is hereby granted, provided that the above copyright no-
tice  appear  in all copies and that both that copyright no-
tice and this permission notice appear in  supporting  docu-
mentation,  and  that the names of Sun or MIT not be used in
advertising or publicity pertaining to distribution  of  the
software  without specific prior written permission. Sun and
M.I.T. make no representations about the suitability of this
software for any purpose. It is provided "as is" without any
express or implied warranty.

SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/


#ifndef	lint
static char sccsid[] = "%W %G Copyright 1987 Sun Micro";
#endif

/*-
 * Copyright (c) 1987 by Sun Microsystems,  Inc.
 */

#include    "amiga.h"
#include    "resource.h"

#include    <sys/mman.h>

#if defined(__NetBSD__) && !defined(MAP_FILE)
#define MAP_FILE 0
#endif

extern caddr_t mmap();

extern Bool FlipPixels;

/*-
 *-----------------------------------------------------------------------
 * amigaBW2Init --
 *	Attempt to find and initialize a bw2 framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Most of the elements of the ScreenRec are filled in.  The
 *	video is enabled for the frame buffer...
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
amigaBW2Init (index, pScreen, argc, argv)
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    ScreenPtr	  pScreen;  	/* The Screen to initialize */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    if (!mfbScreenInit(pScreen,
		       amigaFbs[index].fb,
		       amigaFbs[index].info.view.vs.width,
		       amigaFbs[index].info.view.vs.height,
		       monitorResolution, monitorResolution,
		       amigaFbs[index].info.view.vs.width))
	return (FALSE);

    if (!amigaScreenAllocate (pScreen) || !amigaScreenInit (pScreen))
	return FALSE;

    if (FlipPixels) {
	pScreen->whitePixel = 0;
	pScreen->blackPixel = 1;
    } else {
	pScreen->whitePixel = 1;
	pScreen->blackPixel = 0;
    }

    /*
     * Enable video output...? 
     */
    (void) amigaSaveScreen(pScreen, SCREEN_SAVER_OFF);

    return mfbCreateDefColormap(pScreen);
}



/*-
 *-----------------------------------------------------------------------
 * xopen_view (void) --
 *	Scan for and initialize a view to use.
 *
 * Results:
 *	Returns fd of opened view.
 *
 * Side Effects:
 *	none
 *
 *-----------------------------------------------------------------------
 */
int
xopen_view (void)
{
    u_char buffer[13];
    int i, fd;
    
    for (i=0; i < 100; i++) {
	sprintf (buffer, "/dev/view%02d", i);
	printf ("trying \"%s\"...", buffer);
	fd = open (buffer, O_RDWR);
	if (fd < 0 && errno != EBUSY) {
	    printf ("failed.\n");
	    perror ("xopen_view()");
	    return (-1);
	} else if (fd < 0) {
	    printf ("used.\n");
	} else {
	    return (fd);
	}
    }
    Error ("Ran out of views");
    return (-1);
}

/*-
 *-----------------------------------------------------------------------
 * amigaBW2Probe --
 *	Attempt to find and initialize a bw2 framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Memory is allocated for the frame buffer and the buffer is mapped. 
 *
 *-----------------------------------------------------------------------
 */

/* These are set by ddxProcessArgument */
int displayWidth = 689;
int displayHeight = 440;
int displayDepth = 1;
int displayXOffset;
int displayYOffset;

/*ARGSUSED*/
Bool
amigaBW2Probe(pScreenInfo, index, fbNum, argc, argv)
    ScreenInfo	  *pScreenInfo;	/* The screenInfo struct */
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    int	    	  fbNum;    	/* Index into the amigaFbData array */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    int         fd;
    int		pagemask, mapsize;
    caddr_t	addr, mapaddr;
    struct view_size vs;
    bmap_t	bm;

    if ((fd = xopen_view()) < 0)
	return FALSE;

    if (ioctl(fd, VIOCGSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        return FALSE;
      }

    vs.width = displayWidth;
    vs.height = displayHeight;
    vs.depth = displayDepth;
    vs.x = displayXOffset;
    vs.y = displayYOffset;

    if (ioctl(fd, VIOCSSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        return FALSE;
      }

    if (ioctl(fd, VIOCGSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        return FALSE;
      }

    if (ioctl(fd, VIOCGBMAP, &bm)) {
        perror("ioctl VIOCGBMAP");
        return FALSE;
      }

    if ((mapaddr = (caddr_t) mmap(0, bm.bytes_per_row*bm.rows*bm.depth,
        PROT_READ | PROT_WRITE, MAP_FILE, fd, (off_t)0)) == (caddr_t) -1) {
        Error("mapping BW2");
        (void) close(fd);
        return FALSE;
      }

    if (mapaddr == 0)
        mapaddr = addr;

    amigaFbs[index].fb = (pointer)mapaddr;
    amigaFbs[index].fd = fd;
    amigaFbs[index].info.view.bm = bm;
    amigaFbs[index].info.view.vs = vs;
    amigaFbs[index].EnterLeave = NULL;


#ifndef GDBUG
    if (ioctl(fd, VIOCDISPLAY, 0)) {
        perror("ioctl VIOCDISPLAY");
        return FALSE;
      }
#endif

    return TRUE;
}

Bool
amigaBW2Create(pScreenInfo, argc, argv)
    ScreenInfo	  *pScreenInfo;
    int	    	  argc;
    char    	  **argv;
{
    return (AddScreen(amigaBW2Init, argc, argv) >= 0);
}
