/* XXX */

#include "alpha/netbsd.h"
#include "alpha/elf.h"

#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (NetBSD/alpha ELF)");

#undef SDB_DEBUGGING_INFO
#define SDB_DEBUGGING_INFO
#undef DBS_DEBUGGING_INFO
#define DBX_DEBUGGING_INFO

#undef PREFERRED_DEBUGGING_TYPE
#define PREFERRED_DEBUGGING_TYPE  \
 ((len > 1 && !strncmp (str, "gsdb", len)) ? SDB_DEBUG : DBX_DEBUG)

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-D__alpha -D__alpha__ -D__NetBSD__ -D__ELF__"

#undef LINK_SPEC
#define LINK_SPEC "-m elf64alpha					\
  %{O*:-O3} %{!O*:-O1}						\
  %{assert*}							\
  %{shared:-shared}						\
  %{!shared:							\
    -dc -dp							\
    %{!nostdlib:%{!r*:%{!e*:-e __start}}}			\
    %{!static:							\
      %{rdynamic:-export-dynamic}				\
      %{!dynamic-linker:-dynamic-linker /usr/libexec/ld.elf_so}} \
    %{static:-static}}"

/* Provide a STARTFILE_SPEC appropriate for NetBSD.  Here we add
   the crtbegin.o file (see crtstuff.c) which provides part of the
   support for getting C++ file-scope static object constructed
   before entering `main'. */
   
#undef	STARTFILE_SPEC
#define STARTFILE_SPEC \
 "%{!shared: \
     %{pg:gcrt0.o%s} \
     %{!pg: \
	%{p:gcrt0.o%s} \
	%{!p:crt0.o%s}}} \
   %{!shared:crtbegin.o%s} %{shared:crtbeginS.o%s}"

/* Provide a ENDFILE_SPEC appropriate for NetBSD.  Here we tack on
   the file which provides part of the support for getting C++
   file-scope static object deconstructed after exiting `main' */

#undef	ENDFILE_SPEC
#define ENDFILE_SPEC \
  "%{!shared:crtend.o%s} %{shared:crtendS.o%s}"
