'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /afs/cs.cmu.edu/user/cgd/cvsroot/alphasrc/cygnus/tk/doc/tk.n,v 1.1.1.1 1995/08/19 03:11:08 cgd Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS tk tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tk \- Manipulate Tk internal state
.SH SYNOPSIS
\fBtk\fR \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBtk\fR command provides access to miscellaneous
elements of Tk's internal state.
Most of the information manipulated by this command pertains to the
application as a whole, or to a screen or display, rather than to a
particular window.
The command can take any of a number of different forms
depending on the \fIoption\fR argument.  The legal forms are:
.TP
\fBtk colormodel \fIwindow\fR ?\fInewValue\fR?
If \fInewValue\fR isn't specified, this command returns the current
color model in use for \fIwindow\fR's screen, which will be either
\fBcolor\fR or \fBmonochrome\fR.
If \fInewValue\fR is specified, then it must be either \fBcolor\fR
or \fBmonochrome\fR or an abbreviation of one of them;
the color model for \fIwindow\fR's screen is set to this value.
.RS
.LP
The color model is used by Tk and its widgets to determine whether
it should display in black and white only or use colors.
A single color model is shared by all of the windows managed by one
process on a given screen.
The color model for a screen is set initially by Tk to \fBmonochrome\fR
if the display has four or fewer bit planes and to \fBcolor\fR otherwise.
The color model will automatically be changed from \fBcolor\fR to
\fBmonochrome\fR if Tk fails to allocate a color because all entries
in the colormap were in use.
An application can change its own color model at any time (e.g. it
might change the model to \fBmonochrome\fR in order to conserve
colormap entries, or it might set the model to \fBcolor\fR
to use color on a four-bit display in special circumstances), but
an application is not allowed to change the color model to \fBcolor\fR
unless the screen has at least two bit planes.
.RE

.SH KEYWORDS
color model, internal state
