'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /afs/cs.cmu.edu/user/cgd/cvsroot/alphasrc/cygnus/tk/doc/options.n,v 1.1.1.1 1995/08/19 03:11:06 cgd Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS options tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
options \- Standard options supported by widgets
.BE

.SH DESCRIPTION
This manual entry describes the common configuration options supported
by widgets in the Tk toolkit.  Every widget does not necessarily support
every option (see the manual entries for individual widgets for a list
of the standard options supported by that widget), but if a widget does
support an option with one of the names listed below, then the option
has exactly the effect described below.
.PP
In the descriptions below,
``Name'' refers to the option's name in the option database (e.g.
in .Xdefaults files).  ``Class'' refers to the option's class value
in the option database.  ``Command-Line Switch'' refers to the
switch used in widget-creation and \fBconfigure\fR widget commands to
set this value.  For example, if an option's command-line switch is
\fB\-foreground\fR and there exists a widget \fB.a.b.c\fR, then the
command
.DS
\&\fB.a.b.c\0\0configure\0\0\-foreground black\fR
.DE
may be used to specify the value \fBblack\fR for the option in the
the widget \fB.a.b.c\fR.  Command-line switches may be abbreviated,
as long as the abbreviation is unambiguous.
.ta 4c
.LP
.nf
Name:	\fBactiveBackground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-activebackground\fR
.fi
.IP
Specifies background color to use when drawing active elements.
An element (a widget or portion of a widget) is active if the
mouse cursor is positioned over the element and pressing a mouse button
will cause some action to occur.
.LP
.nf
Name:	\fBactiveBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-activeborderwidth\fR
.fi
.IP
Specifies a non-negative value indicating
the width of the 3-D border drawn around active elements.  See above for
definition of active elements.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
This option is typically only available in widgets displaying more
than one element at a time (e.g. menus but not buttons).
.LP
.nf
Name:	\fBactiveForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB\-activeforeground\fR
.fi
.IP
Specifies foreground color to use when drawing active elements.
See above for definition of active elements.
.LP
.nf
.VS
Name:	\fBanchor\fR
Class:	\fBAnchor\fR
Command-Line Switch:	\fB\-anchor\fR
.fi
.IP
Specifies how the information in a widget (e.g. text or a bitmap)
is to be displayed in the widget.
Must be one of the values \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR,
\fBs\fR, \fBsw\fR, \fBw\fR, \fBnw\fR, or \fBcenter\fR.
For example, \fBnw\fR means display the information such that its
top-left corner is at the top-left corner of the widget.
.VE
.LP
.nf
Name:	\fBbackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB\-background or \-bg\fR
.fi
.IP
Specifies the normal background color to use when displaying the
widget.
.LP
.nf
Name:	\fBbitmap\fR
.VS
Class:	\fBBitmap\fR
Command-Line Switch:	\fB\-bitmap\fR
.fi
.IP
Specifies a bitmap to display in the widget, in any of the forms
acceptable to \fBTk_GetBitmap\fR.
The exact way in which the bitmap is displayed may be affected by
other options such as \fBanchor\fR or \fBjustify\fR.
Typically, if this option is specified then it overrides other
options that specify a textual value to display in the widget;
the \fBbitmap\fR option may be reset to an empty string to re-enable
a text display.
.VE
.LP
.nf
Name:	\fBborderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-borderwidth or \-bd\fR
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the outside of the widget (if such a
border is being drawn;  the \fBrelief\fR option typically determines
this).  The value may also be used when drawing 3-D effects in the
interior of the widget.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
.LP
.nf
Name:	\fBcursor\fR
Class:	\fBCursor\fR
Command-Line Switch:	\fB\-cursor\fR
.fi
.IP
Specifies the mouse cursor to be used for the widget.
The value may have any of the forms acceptable to \fBTk_GetCursor\fR.
.LP
.nf
Name:	\fBcursorBackground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-cursorbackground\fR
.fi
.IP
Specifies the color to use as background in the area covered by the
insertion cursor.  This color will normally override either the normal
background for the widget (or the selection background if the insertion
cursor happens to fall in the selection).
.VS
\fIThis option is obsolete and is gradually being replaced by
the \fBinsertBackground\fR option.\fR
.VE
.LP
.nf
Name:	\fBcursorBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-cursorborderwidth\fR
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the insertion cursor.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
\fIThis option is obsolete and is gradually being replaced by
the \fBinsertBorderWidth\fR option.\fR
.VE
.LP
.nf
Name:	\fBcursorOffTime\fR
Class:	\fBOffTime\fR
Command-Line Switch:	\fB\-cursorofftime\fR
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the cursor should remain ``off'' in each blink cycle.
If this option is zero then the cursor doesn't blink:  it is on
all the time.
.VS
\fIThis option is obsolete and is gradually being replaced by
the \fBinsertOffTime\fR option.\fR
.VE
.LP
.nf
Name:	\fBcursorOnTime\fR
Class:	\fBOnTime\fR
Command-Line Switch:	\fB\-cursorontime\fR
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the cursor should remain ``on'' in each blink cycle.
.VS
\fIThis option is obsolete and is gradually being replaced by
the \fBinsertOnTime\fR option.\fR
.VE
.LP
.nf
Name:	\fBcursorWidth\fR
Class:	\fBCursorWidth\fR
Command-Line Switch:	\fB\-cursorwidth\fR
.fi
.IP
Specifies a  value indicating the total width of the insertion cursor.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
If a border has been specified for
the cursor (using the \fBcursorBorderWidth\fR option), the border
will be drawn inside the width specified by the \fBcursorWidth\fR
option.
.VS
\fIThis option is obsolete and is gradually being replaced by
the \fBinsertWidth\fR option.\fR
.VE
.LP
.nf
.VS
Name:	\fBdisabledForeground\fR
Class:	\fBDisabledForeground\fR
Command-Line Switch:	\fB\-disabledforeground\fR
.fi
.IP
Specifies foreground color to use when drawing a disabled element.
If the option is specified as an empty string (which is typically the
case on monochrome displays), disabled elements are drawn with the
normal fooreground color but they are dimmed by drawing them
with a stippled fill pattern.
.VE
.LP
.nf
.VS
Name:	\fBexportSelection\fR
Class:	\fBExportSelection\fR
Command-Line Switch:	\fB\-exportselection\fR
.fi
.IP
Specifies whether or not a selection in the widget should also be
the X selection.
The value may have any of the forms accepted by \fBTcl_GetBoolean\fR,
such as \fBtrue\fR, \fBfalse\fR, \fB0\fR, \fB1\fR, \fByes\fR, or \fBno\fR.
If the selection is exported, then selecting in the widget deselects
the current X selection, selecting outside the widget deselects any
widget selection, and the widget will respond to selection retrieval
requests when it has a selection.  The default is usually for widgets
to export selections.
.VE
.LP
.nf
Name:	\fBfont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB\-font\fR
.fi
.IP
Specifies the font to use when drawing text inside the widget.
.LP
.nf
Name:	\fBforeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-foreground or \-fg\fR
.fi
.IP
Specifies the normal foreground color to use when displaying the widget.
.LP
.nf
Name:	\fBgeometry\fR
Class:	\fBGeometry\fR
Command-Line Switch:	\fB\-geometry\fR
.fi
.IP
Specifies the desired geometry for the widget's window, in the
form \fIwidth\fBx\fIheight\fR, where \fIwidth\fR is the desired
width of the window and \fIheight\fR is the desired height.  The
units for \fIwidth\fR and \fIheight\fR depend on the particular
widget.  For widgets displaying text the units are usually the
size of the characters in the font being displayed;  for other
widgets the units are usually pixels.
.LP
.nf
.VS
Name:	\fBinsertBackground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-insertbackground\fR
.fi
.IP
Specifies the color to use as background in the area covered by the
insertion cursor.  This color will normally override either the normal
background for the widget (or the selection background if the insertion
cursor happens to fall in the selection).
.LP
.nf
Name:	\fBinsertBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-insertborderwidth\fR
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around the insertion cursor.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.LP
.nf
Name:	\fBinsertOffTime\fR
Class:	\fBOffTime\fR
Command-Line Switch:	\fB\-insertofftime\fR
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``off'' in each blink cycle.
If this option is zero then the cursor doesn't blink:  it is on
all the time.
.LP
.nf
Name:	\fBinsertOnTime\fR
Class:	\fBOnTime\fR
Command-Line Switch:	\fB\-insertontime\fR
.fi
.IP
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``on'' in each blink cycle.
.LP
.nf
Name:	\fBinsertWidth\fR
Class:	\fBInsertWidth\fR
Command-Line Switch:	\fB\-insertwidth\fR
.fi
.IP
Specifies a  value indicating the total width of the insertion cursor.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If a border has been specified for the insertion
cursor (using the \fBinsertBorderWidth\fR option), the border
will be drawn inside the width specified by the \fBinsertWidth\fR
option.
.VE
.LP
.nf
Name:	\fBorient\fR
Class:	\fBOrient\fR
Command-Line Switch:	\fB\-orient\fR
.fi
.IP
For widgets that can lay themselves out with either a horizontal
or vertical orientation, such as scrollbars, this option specifies
which orientation should be used.  Must be either \fBhorizontal\fR
or \fBvertical\fR or an abbreviation of one of these.
.LP
.nf
Name:	\fBpadX\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB\-padx\fR
.fi
.IP
Specifies a non-negative value indicating how much extra space
to request for the widget in the X-direction.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
When computing how large a window it needs, the widget will
add this amount to the width it would normally need (as determined
by the width of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space to the left and/or right of what it displays inside.
.LP
.nf
Name:	\fBpadY\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB\-pady\fR
.fi
.IP
Specifies a non-negative value indicating how much extra space
to request for the widget in the Y-direction.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
When computing how large a window it needs, the widget will add
this amount to the height it would normally need (as determined by
the height of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space above and/or below what it displays inside.
.LP
.nf
Name:	\fBrelief\fR
Class:	\fBRelief\fR
Command-Line Switch:	\fB\-relief\fR
.fi
.IP
Specifies the 3-D effect desired for the widget.  Acceptable
.VS
values are \fBraised\fR, \fBsunken\fR, \fBflat\fR, \fBridge\fR,
and \fBgroove\fR.
.VE
The value
indicates how the interior of the widget should appear relative
to its exterior;  for example, \fBraised\fR means the interior of
the widget should appear to protrude from the screen, relative to
the exterior of the widget.
.LP
.nf
Name:	\fBrepeatDelay\fR
Class:	\fBRepeatDelay\fR
Command-Line Switch:	\fB\-repeatdelay\fR
.fi
.IP
Specifies the number of milliseconds a button or key must be held
down before it begins to auto-repeat.  Used, for example, on the
up- and down-arrows in scrollbars.
.LP
.nf
Name:	\fBrepeatInterval\fR
Class:	\fBRepeatInterval\fR
Command-Line Switch:	\fB\-repeatinterval\fR
.fi
.IP
Used in conjunction with \fBrepeatDelay\fR:  once auto-repeat
begins, this option determines the number of milliseconds between
auto-repeats.
.LP
.nf
Name:	\fBscrollCommand\fR
Class:	\fBScrollCommand\fR
Command-Line Switch:	\fB\-scrollcommand\fR
.fi
.IP
Specifies the prefix for a command used to communicate with scrollbar
widgets.  When the view in the widget's window changes (or
whenever anything else occurs that could change the display in a
scrollbar, such as a change in the total size of the widget's
contents), the widget will
generate a Tcl command by concatenating the scroll command and four
numbers.  The four numbers are, in order:  the total size of the
widget's contents, in unspecified units
(``unit'' is a widget-specific term;  for widgets
displaying text, the unit is a line);  the maximum number of units that
may be displayed at once in the widget's window, given its current size;  the
index of the top-most or left-most unit currently visible in the window
(index 0 corresponds to the first unit); and the index of the bottom-most
or right-most unit currently visible in the window.  This command is
then passed to the Tcl interpreter for execution.  Typically the
\fBscrollCommand\fR option consists of the path name of a scrollbar
widget followed by ``set'', e.g. ``.x.scrollbar set'':  this will cause
the scrollbar to be updated whenever the view in the window changes.
If this option is not specified, then no command will be executed.
.IP
.VS
The \fBscrollCommand\fR option is used for widgets that support scrolling
in only one direction.
For widgets that support scrolling in both directions, this
option is replaced with the \fBxScrollCommand\fR and \fByScrollCommand\fR
options.
.VE
.LP
.nf
Name:	\fBselectBackground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-selectbackground\fR
.fi
.IP
Specifies the background color to use when displaying selected
items.
.LP
.nf
Name:	\fBselectBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB\-selectborderwidth\fR
.fi
.IP
Specifies a non-negative value indicating the width
of the 3-D border to draw around selected items.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
.LP
.nf
Name:	\fBselectForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB\-selectforeground\fR
.fi
.IP
Specifies the foreground color to use when displaying selected
items.
.LP
.nf
.VS
Name:	\fBsetGrid\fR
Class:	\fBSetGrid\fR
Command-Line Switch:	\fB\-setgrid\fR
.fi
.IP
Specifies a boolean value that determines whether this widget controls the
resizing grid for its top-level window.
This option is typically used in text widgets, where the information
in the widget has a natural size (the size of a character) and it makes
sense for the window's dimensions to be integral numbers of these units.
These natural window sizes form a grid.
If the \fBsetGrid\fR option is set to true then the widget will
communicate with the window manager so that when the user interactively
resizes the top-level window that contains the widget, the dimensions of
the window will be displayed to the user in grid units and the window
size will be constrained to integral numbers of grid units.
See the section GRIDDED GEOMETRY MANAGEMENT in the \fBwm\fR manual
entry for more details.
.VE
.LP
.nf
Name:	\fBtext\fR
Class:	\fBText\fR
Command-Line Switch:	\fB\-text\fR
.fi
.IP
Specifies a string to be displayed inside the widget.  The way in which
the string is displayed depends on the particular widget and may be
determined by other options, such as \fBanchor\fR or \fBjustify\fR.
.LP
.nf
.VS
Name:	\fBtextVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB\-textvariable\fR
.fi
.IP
Specifies the name of a variable.  The value of the variable is a text
string to be displayed inside the widget;  if the variable value changes
then the widget will automatically update itself to reflect the new value.
The way in which the string is displayed in the widget depends on the
particular widget and may be determined by other options, such as
\fBanchor\fR or \fBjustify\fR.
.LP
.nf
Name:	\fBunderline\fR
Class:	\fBUnderline\fR
Command-Line Switch:	\fB\-underline\fR
.fi
.IP
Specifies the integer index of a character to underline in the widget.
This option is typically used to indicate keyboard traversal characters
in menu buttons and menu entries.  0 corresponds to the first character
of the text displayed in the widget, 1 to the next character, and so
on.
.LP
.nf
Name:	\fBxScrollCommand\fR
Class:	\fBScrollCommand\fR
Command-Line Switch:	\fB\-xscrollcommand\fR
.fi
.IP
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  This option is treated in the same way as the
\fBscrollCommand\fR option, except that it is used for horizontal
scrollbars associated with widgets that support both horizontal
and vertical scrolling.
See the description of \fBscrollCommand\fR for complete details
on how this option is used.
.LP
.nf
Name:	\fByScrollCommand\fR
Class:	\fBScrollCommand\fR
Command-Line Switch:	\fB\-yscrollcommand\fR
.fi
.IP
Specifies the prefix for a command used to communicate with vertical
scrollbars.  This option is treated in the same way as the
\fBscrollCommand\fR option, except that it is used for vertical
scrollbars associated with widgets that support both horizontal
and vertical scrolling.
See the description of \fBscrollCommand\fR for complete details
on how this option is used.
.VE

.SH KEYWORDS
class, name, standard option, switch
