'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /afs/cs.cmu.edu/user/cgd/cvsroot/alphasrc/cygnus/tk/doc/button.n,v 1.1.1.1 1995/08/19 03:11:02 cgd Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS button tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
button \- Create and manipulate button widgets
.SH SYNOPSIS
\fBbutton\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground\fR	\fBbitmap\fR	\fBfont\fR	\fBrelief\fR
\fBactiveForeground\fR	\fBborderWidth\fR	\fBforeground\fR	\fBtext\fR
\fBanchor\fR	\fBcursor\fR	\fBpadX\fR	\fBtextVariable\fR
\fBbackground\fR	\fBdisabledForeground\fR	\fBpadY\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.
.LP
.nf
.VS
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the button.
If a bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the button's desired height is computed
from the size of the bitmap or text being displayed in it.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the button:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the button is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the button.  In active state
the button is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the button
is insensitive:  it doesn't activate and doesn't respond to mouse
button presses.  In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the button is displayed.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the button.
If a bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the button's desired width is computed
from the size of the bitmap or text being displayed in it.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBbutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a button widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the button such as its colors, font,
text, and initial relief.  The \fBbutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A button is a widget
.VS
that displays a textual string or bitmap.
It can display itself in either of three different ways, according
to
the \fBstate\fR option; 
.VE
it can be made to appear raised, sunken, or flat;
and it can be made to flash.  When a user invokes the
button (by pressing mouse button 1 with the cursor over the
button), then the Tcl command specified in the \fB\-command\fR
option is invoked.

.SH "WIDGET COMMAND"
.PP
The \fBbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for button widgets:
.TP
\fIpathName \fBactivate\fR
Change the button's state to \fBactive\fR and redisplay the button
using its active foreground and background colors instead of normal
colors.
.VS
This command is ignored if the button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state active\fR'' instead.
.VE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBbutton\fR
command.
.TP
\fIpathName \fBdeactivate\fR
Change the button's state to \fBnormal\fR and redisplay the button
using its normal foreground and background colors.
.VS
This command is ignored if the button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state normal\fR'' instead.
.VE
.TP
\fIpathName \fBflash\fR
Flash the button.  This is accomplished by redisplaying the button
several times, alternating between active and normal colors.  At
the end of the flash the button is left in the same normal/active
state as when the command was invoked.
.VS
This command is ignored if the button's state is \fBdisabled\fR.
.VE
.TP
\fIpathName \fBinvoke\fR
.VS
Invoke the Tcl command associated with the button, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the button.
This command is ignored if the button's state is \fBdisabled\fR.
.VE

.SH "DEFAULT BINDINGS"
.PP
.VS
Tk automatically creates class bindings for buttons that give them
the following default behavior:
.IP [1]
The button activates whenever the mouse passes over it and deactivates
whenever the mouse leaves the button.
.IP [2]
The button's relief is changed to sunken whenever mouse button 1 is
pressed over the button, and the relief is restored to its original
value when button 1 is later released.
.IP [3]
If mouse button 1 is pressed over the button and later released over
the button, the button is invoked.  However, if the mouse is not
over the button when button 1 is released, then no invocation occurs.
.PP
If the button's state is \fBdisabled\fR then none of the above
actions occur:  the button is completely non-responsive.
.PP
The behavior of buttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH KEYWORDS
button, widget
