/* execvp.c */

/* This and the other exec*.c files in this directory require 
   the target to provide the execve syscall.  */

#include <_ansi.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

/*
 * Copy string, until c or <nul> is encountered.
 * NUL-terminate the destination string (s1).
 */

static char *
_DEFUN (strccpy, (s1, s2, c),
	char *s1 _AND
	char *s2 _AND
	char c)
{
  char *dest = s1;

  while (*s2 && *s2 != c)
    *s1++ = *s2++;
  *s1 = 0;

  return dest;
}

int
_DEFUN (execvp, (file, argv),
	_CONST char *file _AND
	char * _CONST argv[])
{
  char *path = getenv ("PATH");
  char buf[MAXNAMLEN];

  if (file[0] == '/')  /* pathname -- easy out */
    return execv (file, argv);

  buf[0] = 0;          /* lots of initialization here 8-) */

  while (*path)
    {
      strccpy (buf, path, ':');
      strcat (buf, "/");
      strcat (buf, file);
      execv (buf, argv);
      if (errno != ENOENT)
	return -1;
      while (*path && *path != ':')
	path++;
    }

    return -1;
}
