/*
 * asctime.c
 * Original Author:	G. Haley
 *
 * Converts the broken down time in the structure pointed to by tim_p into a
 * string of the form
 *
 * Wed Jun 15 11:38:07 1988\n\0
 *
 * Returns a pointer to the string.
 */

/*
FUNCTION
<<asctime>>---format time as string

INDEX
	asctime
INDEX
	_asctime_r

ANSI_SYNOPSIS
	#include <time.h>
	char *asctime(const struct tm *<[timp]>);

	#include <time.h>
	char *_asctime_r(const struct tm *<[timp]>, void *<[reent]>);

TRAD_SYNOPSIS
	#include <time.h>
	char *asctime(<[timp]>)
	struct tm *<[timp]>;

	#include <time.h>
	char *_asctime_r(<[timp]>, <[reent]>)
	struct tm *<[timp]>;
	char *<[reent]>;

DESCRIPTION
Format the time value at <[timp]> into a string of the form
. Wed Jun 15 11:38:07 1988\n\0
The string is generated in a static buffer; each call to <<asctime>>
overwrites the string generated by previous calls.

<<_asctime_r>> provides the same function as <<asctime>>, but is
reentrant.  The extra argument <[reent]> is a pointer to a reentrancy
structure.

RETURNS
A pointer to the string containing a formatted timestamp.

PORTABILITY
ANSI C requires <<asctime>>.

<<asctime>> requires no supporting OS subroutines.
*/

#include <stdio.h>
#include <time.h>
#include <reent.h>

char *
_DEFUN (_asctime_r, (tim_p, data),
	_CONST struct tm *tim_p _AND
	void *data)
{
  static _CONST char day_name[7][3]
    = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
  static _CONST char mon_name[12][3]
    = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
	 "Sep", "Oct", "Nov", "Dec"};

  struct _reent *p = data;

  sprintf (p->_asctime, "%.3s %.3s %.2d %.2d:%.2d:%.2d %d\n",
	   day_name[tim_p->tm_wday], mon_name[tim_p->tm_mon],
	   tim_p->tm_mday, tim_p->tm_hour, tim_p->tm_min,
	   tim_p->tm_sec, 1900 + tim_p->tm_year);

  return p->_asctime;
}

#ifndef _REENT_ONLY

char *
_DEFUN (asctime, (tim_p),
	_CONST struct tm *tim_p)
{
  return _asctime_r (tim_p, _REENT);
}

#endif
