/* syscalls for WIN32.

   Written by Steve Chamberlain of Cygnus Support.
   sac@cygnus.com

   This file is part of SH sim


		THIS SOFTWARE IS NOT COPYRIGHTED

   Cygnus offers the following for use in the public domain.  Cygnus
   makes no warranty with regard to the software or it's performance
   and the user accepts the software "AS IS" with all faults.

   CYGNUS DISCLAIMS ANY WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO
   THIS SOFTWARE INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/


#include "stdlib.h"
#include "sys/winbase.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "errno.h"
#include "fcntl.h"
#include "unistd.h"
#include "errno.h"
#include "sys/resource.h"
#include "sys/wintypes.h"
#include "syscalls.h"

extern int __ptrace;

#define M(x) { if (__ptrace>1) {write(1,x,strlen(x)); write(1,"\n", 1);}}

extern int __hmap[];
int errno;
char __syscalls_b[100];



static void seterrno()
{
  int why = GetLastError();

  if (__ptrace > 1) 
    {
      sprintf (__syscalls_b, "seterrno with %d\n", why);
      write (1, __syscalls_b, strlen (__syscalls_b));
    }

  switch (why & 0xff) 
    {
    case ERROR_INVALID_HANDLE:
      errno = EBADF;
      break;
    case ERROR_FILE_NOT_FOUND:
      errno = ENOENT;
      break;
    case ERROR_PATH_NOT_FOUND:
      errno = ENOENT;
      break;
    case ERROR_ACCESS_DENIED:
      errno = EACCES;
      break;
    case ERROR_INVALID_NAME:
      errno = ENODEV;
      break;
    default:
      if (__ptrace) 
	{
	  sprintf (__syscalls_b,"seterrno with %x!!\n", why);
	  write (1, __syscalls_b, strlen (__syscalls_b));
	}
      errno = EPERM;
      break;
    }
}

int access(const char *fn, int flags)
{
  struct stat s;
  M("access");

  if (stat(fn, &s))
    return -1;
  if (s.st_mode & S_IFDIR)
    return 0;
  if (flags & W_OK)
    {
      if (s.st_mode & S_IWRITE)
	return 0;
      return -1;
    }
  return 0;
}
	

int sys_nerr = 9;

cwait(int *status, int pid, int fake)
{
  int result;
  if (__ptrace) {
    printf("Cwaiting for %d\n",pid);
    M("cwait");
  }
  WaitForSingleObject( pid, INFINITE);

  if (!  GetExitCodeProcess (pid, &result))
    {
      printf("CWAIT ERROR!\n");
    }
  if (__ptrace) {
    printf("CWAIT IS DONE %x!\n", result);
  }
  *status = (result << 8) & 0xff00;
  return pid;
}

spawnvp(int a, char *prog, char **argv)
{
  int clen;
  int i;
  char **p;
  char *copy;
  STARTUPINFO si = {0};
  PROCESS_INFORMATION pi = {0};
  si.cb = sizeof(STARTUPINFO);
  si.lpReserved = NULL;
  si.lpReserved2 = NULL;
  si.cbReserved2 = 0;
  si.lpDesktop = NULL;
  si.dwFlags = 0;
  M("spawnvp");
  /* Make sure we stick a .exe on the end of the executable name */
  {
    int l = strlen (prog);
    if (l < 5 || strcmp (prog + l - 4, ".exe"))
      {
	char *copy = malloc (l + 5);
	strcpy (copy, prog);
	strcat (copy, ".exe");
	prog = copy;
      }
  }

  clen = 0;
  for (i = 0; argv[i]; i++)
    clen += strlen (argv[i]) + 1;


  copy = malloc (clen+1);
  clen = 0;
  for (i = 0; argv[i]; i++)
    {
      int l = strlen (argv[i]);
      memcpy (copy + clen, argv[i], l);
      clen += l;
      copy[clen++] = ' ';
      copy[clen] = 0;
    }

  if (__ptrace)
    printf("FULL COMMAND ARG (no arg) %d (%s) %s\n",a, prog, copy);
  if (  CreateProcessA (0,
			copy,
			0,
			0,
			1,
			NORMAL_PRIORITY_CLASS,
			0,
			0,
			&si,
			&pi))
    {
      if (__ptrace)
	printf("OKEY DOODE\n");
    }
  else
    {
      if (__ptrace) {
	printf("Bummer %d\n", GetLastError());
      }
      seterrno();
      return -1;
    }
  free (copy);
  if (__ptrace) {
    printf("returning %d\n", pi.hProcess);
  }
  return pi.hProcess;
}

spawnv(int a, char *prog, char **argv)
{
  spawnvp (a,prog,argv);
}







int
_unlink (char *name)
{
  int res;
M("unlink");
  if (!DeleteFileA (name))
    {
      seterrno();
      res = -1; 
    }
  else
    res = 0;

  if (__ptrace)
    printf ("%d = unlink (%s)\n", res, name);


  return res;
}

void _exit(n)
{
  M("exit");
  if (__ptrace) {
    printf("exit (%d)\n", n);
  }
  ExitProcess(n);
}


_kill(n)
{
  if (__ptrace) {
    printf("kill (%d)\n", n);
  }
  ExitProcess(n);
}



int _getpid() { return GetCurrentProcess();}

int _stat(const char *name, struct stat *buf)
{
  int h;
  int res;
  int  atts;
M("stat");


  memset (buf, sizeof (struct stat), 0);

  atts = GetFileAttributesA (name);
  if (atts == -1)
    {
      seterrno();
      return -1;
    }
  if (atts == FILE_ATTRIBUTE_DIRECTORY)  
    {
      buf->st_mode = S_IFDIR;
      res = 0;
    }
  else 
    {
      int h = open (name, O_RDONLY);
      if (h < 0) 
	{
	  return -1;
	}
      res = fstat (h, buf);
      close (h);
    }
  return res;
}


totime_t (FILETIME *ptr)
{
  /* A filetime is the number of 100ns since jan 1 1601
     stuffed into two long words.
     a time_t is the number of seconds since jan 1 1970.
     
     */
  long long x= ((long long)ptr->dwHighDateTime << 32 ) + (ptr->dwLowDateTime);
  x -= 0x19db1ded53e8000LL;	/* number of 100ns between 1601 and 1970 */
  x /= 10000000;		/* number of 100ns in a second */
  return x;
}


int _fstat (int handle, struct stat *buf)
{
  int res; 
  BY_HANDLE_FILE_INFORMATION local;

  M("fstat");
  memset (buf, sizeof (buf), 0);

  res = GetFileInformationByHandle (__hmap[handle], &local);




  if (res == 0)
    {
      /* GetFileInformationByHandle can fail if it's given stdin/out/err */
      if (handle > 2)
	{
	  if (__ptrace) 
	    {
	      sprintf (__syscalls_b, "-1 = fstat (%d, %x)\n", handle, buf);
	      write (1, __syscalls_b, strlen (__syscalls_b));
	    }

	  seterrno();
	  return -1;
	}
    }

  buf->st_atime = totime_t(&local.ftLastAccessTime);
  buf->st_mtime = totime_t(&local.ftLastWriteTime);
  buf->st_ctime = totime_t(&local.ftCreationTime);
  buf->st_ino = 0;
  /* If it's stdin/out/err then we say it's a tty otherwise
     its a real file */
  switch (GetFileType(__hmap[handle]))
    {
    case FILE_TYPE_CHAR:
    case FILE_TYPE_UNKNOWN: 
      buf->st_mode = S_IFCHR;
      break;
    case FILE_TYPE_DISK:
      buf->st_mode = S_IFREG;
      break;
    case FILE_TYPE_PIPE:
      buf->st_mode = S_IFSOCK;
      break;
    }

  buf->st_size = local.nFileSizeLow;

  if (__ptrace) 
    {
      sprintf(__syscalls_b, "0 = fstat (%d, %x) st_size=%d, st_mode=%d %d\n",
	      handle, buf, buf->st_size, buf->st_mode,
	      sizeof (*buf));
      write (1, __syscalls_b, strlen(__syscalls_b));
    }
  return 0;
}


time_t time(time_t *ptr)
{
  time_t res;
  SYSTEMTIME systemtime;
  FILETIME filetime;
  M("time");
  if (__ptrace)
    D("time");
  GetSystemTime(&systemtime);
  SystemTimeToFileTime(&systemtime, &filetime);
  res = totime_t (&filetime);
  if (ptr)
    *ptr= res;
  return res;
}


int
_read (int file,
     void *ptr,
       size_t len)
{
  int l;
  M("read");
  l = _lread(__hmap[file], ptr, len);
  if (__ptrace)
    {
      printf("%d = read (%d, %x, %d)", l, file, ptr, len);
    }
  return l;
}

int
_write (int file,
	const void *ptr,
	size_t len)
{
  int res;
  res = _lwrite(__hmap[file], ptr, len);
  if (0 && __ptrace && file != 1 && file != 2)
    {
      sprintf (__syscalls_b, "%s = write (%d, %x, %d)\n", 
	       res, file,ptr,len);
      write (1, __syscalls_b, strlen (__syscalls_b));
    }
  return res;
}

R(a,b)
char *a;
int b;
{
  char x[200];
  _lwrite(7,a,strlen(a));

  sprintf(x,"%d\n",b);
  _lwrite(7,x,strlen(x));
}
int
_open (const char *path,
      int flags, ...)
{
  int j;
  int res;
  int x ;
  int access;
  int file_attributes;
  int shared;
  void *security_attributes;
  int creation_distribution;
  M("open");
  if ((flags & (O_RDONLY| O_WRONLY|O_RDWR)) == O_RDONLY)
    {
      access = GENERIC_READ;
    }
  else if ((flags & (O_RDONLY| O_WRONLY|O_RDWR)) == O_WRONLY)
    {
      access = GENERIC_WRITE;
    }
  else 
    {
      access = GENERIC_READ|GENERIC_WRITE;
    }
  shared = FILE_SHARE_READ|FILE_SHARE_WRITE;
  security_attributes = 0;
  file_attributes = FILE_ATTRIBUTE_NORMAL;

  if (flags & O_CREAT)
    creation_distribution = CREATE_ALWAYS;
  else
    creation_distribution = OPEN_EXISTING;

  if (flags & O_APPEND)
    creation_distribution = OPEN_ALWAYS;


  x = CreateFileA (path, access, shared,
		   security_attributes, creation_distribution,
		   file_attributes,
		   0);


  if (x < 0)
    {
      res = -1;
      seterrno();
    }
  else {
    for (j= 0; j < MAX_HANDLES; j++) 
      {
	if (__hmap[j] <= 0)
	  {
	    __hmap[j] = x;
	    res = j;
	    break;
	  }
      }
  }

  if (__ptrace) 
{
  sprintf (__syscalls_b,"%d = open (%s, %x);\n", res, path, flags);
  write (1, __syscalls_b, strlen(__syscalls_b));
}
  return res;

}


off_t _lseek (int file, off_t pos, int dir)
{
  int res;
  M("lseek");
  res = SetFilePointer (__hmap[file], pos, 0, dir);

  if (__ptrace)
    {
      sprintf(__syscalls_b, "%d = lseek (%d,%d,%d)\n", res, file,pos,dir);
      write (1, __syscalls_b, strlen(__syscalls_b));
    }

  if (res < 0)
    {
      seterrno ();
      return -1;
    }
  return res;
}

int _close(int file)
{
  int res;
M("close");
  if (!CloseHandle(__hmap[file]))
    {
      seterrno ();
      res=  -1;
    }
  else {
    __hmap[file] = -1;
    res = 0;
  }
  if (__ptrace) {
    sprintf (__syscalls_b, "%d = close (%d)\n", res, file);
    write (1, __syscalls_b, strlen (__syscalls_b));
  }
  return 0;
}



void *
_sbrk (size_t incr)
{
  char *res;
  static char *ptr;
  static char *base;
  if (base == 0) 
    {
      /* Hardwire in 64 megs, what can you do about this ??? */

      ptr =  base = VirtualAlloc (0, 64 * 1024 * 1024, MEM_RESERVE, PAGE_READWRITE);

    }

  res = ptr;
  VirtualAlloc (ptr, incr, MEM_COMMIT, PAGE_READWRITE);
  ptr += incr;
  if(__ptrace) 
    {
      sprintf (__syscalls_b, "%x = local sbrk (%x)\n", ptr, incr);
      write (1, __syscalls_b,strlen(__syscalls_b));
    }

  return res;
}



D(char *x)
{
  _lwrite(7,x, strlen(x));
  _lwrite(7,"\n", 1);
}


isatty (fd)
     int fd;


{
  return GetFileType(__hmap[fd]) == FILE_TYPE_CHAR;
}
/*atexit() {}*/

int _fltused() {}
int fltused() {}
 





int
_link(const char *a,const char *b)
{
  /* do this with a copy */
  if (CopyFileA (a, __syscalls_b, 1))
    {
      return 0;
    }
  seterrno();
  return -1;
}


static void totimeval(struct timeval *dst,
		      FILETIME *src)
{
  long long total = 
    ((long long)src->dwHighDateTime << 32 ) + (src->dwLowDateTime);

  /* each inc in total is 100ns, we want usecs as the minimum*/
  total /= 10;

  dst->tv_usec = total % 1000000;
  dst->tv_sec  = total  / 1000000;

}
getrusage(int who,  struct rusage *rusage)
{
  FILETIME creation;
  FILETIME exit;
  FILETIME kernel;
  FILETIME user;
  long long tosec;
  M("getrusage");
  if (who == 0)
    who = GetCurrentProcess();

  GetProcessTimes (who, &creation, &exit, &kernel, &user);

  totimeval(&rusage->ru_stime, &kernel);
  totimeval(&rusage->ru_utime, &user);
  M("getrusage done");
}



int mkdir (char *name, mode_t mode)
{
  M("mkdir");
  if (CreateDirectoryA (name, 0) == 0)
    {
      seterrno();
      return -1;
    }
  return 0;
}



int rmdir (char *name)
{
  if (RemoveDirectoryA (name) == 0)
    {
      seterrno();
      return -1;
    }
  return 0;
}




int lstat(const char *name, struct stat *buf)
{
  return _stat(name, buf);
}


int chown(const char *path, uid_t owner, gid_t group)
{

}


char *getcwd (char *buf, size_t len)
{
  if (GetCurrentDirectoryA (len, buf))
    return buf;
  seterrno();
  return 0;
}

_execve(const char *_path, char * const _argv[], char * const _envp[] ) 
{ 
  write(1,"NO EXECVE\n", 11);
}
_fork(void) 
{
  write(1,"NO FORK\n", 8);
}
_wait() 
{
  write(1,"NO WAIT\n", 8);
}

utimes()
{
  return 0;
}


int
chdir (const char *dir)
{
  if (!SetCurrentDirectoryA (dir))
    {
      seterrno();
      return -1;
    }
  return 0;
}

mode_t umask(mode_t x ) {  }
int chmod(const char *a, mode_t x) {  }
uid_t getuid(void) { return 99; }
gid_t getgid(void ) { return 100;}




