#include "sys/wintypes.h"

int
WINAPI
WinMain(
    HANDLE hInstance,
    HANDLE hPrevInstance,
    LPSTR lpCmdLine,
    int nShowCmd
    );


#define CS_VREDRAW          0x0001
#define CS_HREDRAW          0x0002
#define CS_KEYCVTWINDOW     0x0004
#define CS_DBLCLKS          0x0008
#define CS_OWNDC            0x0020
#define CS_CLASSDC          0x0040
#define CS_PARENTDC         0x0080
#define CS_NOKEYCVT         0x0100
#define CS_NOCLOSE          0x0200
#define CS_SAVEBITS         0x0800
#define CS_BYTEALIGNCLIENT  0x1000
#define CS_BYTEALIGNWINDOW  0x2000
#define CS_GLOBALCLASS      0x4000


#define DT_SINGLELINE       0x00000020
#define DT_CENTER           0x00000001
#define DT_VCENTER          0x00000004


#define WM_DESTROY                      0x0002
#define WM_PAINT                        0x000F


typedef struct
{
  UINT        style;
  WNDPROC     lpfnWndProc;
  int         cbClsExtra;
  int         cbWndExtra;
  HINSTANCE   hInstance;
  HICON       hIcon;
  HCURSOR     hCursor;
  HBRUSH      hbrBackground;
  LPCSTR      lpszMenuName;
  LPCSTR      lpszClassName;
} WNDCLASS;


#define MAKEINTRESOURCE(x) ((char *)x)
#define IDC_ARROW           MAKEINTRESOURCE(32512)


#define WHITE_BRUSH         0
#define LTGRAY_BRUSH        1
#define GRAY_BRUSH          2
#define DKGRAY_BRUSH        3
#define BLACK_BRUSH         4
#define NULL_BRUSH          5
#define WHITE_PEN           6
#define BLACK_PEN           7
#define NULL_PEN            8
#define OEM_FIXED_FONT      10
#define ANSI_FIXED_FONT     11
#define ANSI_VAR_FONT       12
#define SYSTEM_FONT         13
#define DEVICE_DEFAULT_FONT 14
#define DEFAULT_PALETTE     15
#define SYSTEM_FIXED_FONT   16

#define IDI_APPLICATION   MAKEINTRESOURCE(32512)


typedef struct {
    HWND        hwnd;
    UINT        message;
    WORD      wParam;
    DWORD      lParam;
    DWORD       time;
    POINT       pt;
} MSG;

typedef int HDC;

typedef struct
{
    HDC         hdc;
    BOOL        fErase;
    RECT        rcPaint;
    BOOL        fRestore;
    BOOL        fIncUpdate;
    BYTE        rgbReserved[32];
} PAINTSTRUCT;

#define WS_MINIMIZEBOX      0x00020000L
#define WS_MAXIMIZEBOX      0x00010000L
#define WS_OVERLAPPED       0x00000000L
#define WS_POPUP            0x80000000L
#define WS_CHILD            0x40000000L
#define WS_MINIMIZE         0x20000000L
#define WS_VISIBLE          0x10000000L
#define WS_DISABLED         0x08000000L
#define WS_CLIPSIBLINGS     0x04000000L
#define WS_CLIPCHILDREN     0x02000000L
#define WS_MAXIMIZE         0x01000000L
#define WS_CAPTION          0x00C00000L
#define WS_BORDER           0x00800000L
#define WS_DLGFRAME         0x00400000L
#define WS_VSCROLL          0x00200000L
#define WS_HSCROLL          0x00100000L
#define WS_SYSMENU          0x00080000L
#define WS_THICKFRAME       0x00040000L
#define WS_GROUP            0x00020000L
#define WS_TABSTOP          0x00010000L


typedef int HGDIOBJ;
typedef int HMENU;


#define WS_OVERLAPPEDWINDOW (WS_OVERLAPPED     | \
                             WS_CAPTION        | \
                             WS_SYSMENU        | \
                             WS_THICKFRAME     | \
                             WS_MINIMIZEBOX    | \
                             WS_MAXIMIZEBOX)
#define CW_USEDEFAULT       ((int)0x80000000)



#define LoadIcon LoadIconA
#define LoadCursor LoadCursorA
HICON
WINAPI
LoadIconA(    HINSTANCE hInstance,    LPCSTR lpIconName);
HCURSOR WINAPI LoadCursorA(     HINSTANCE hInstance,    LPCSTR lpCursorName);

HGDIOBJ WINAPI GetStockObject(int);



HWND
WINAPI
CreateWindowExA(
    DWORD dwExStyle,
    LPCSTR lpClassName,
    LPCSTR lpWindowName,
    DWORD dwStyle,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    HWND hWndParent ,
    HMENU hMenu,
    HINSTANCE hInstance,
    VOID *lpParam);

#define CreateWindow(lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)\
CreateWindowExA(0L, lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)



BOOL
WINAPI
ShowWindow(
    HWND hWnd,
    int nCmdShow);


#define DispatchMessage DispatchMessageA

LONG
WINAPI
DispatchMessageA(
    CONST MSG *lpMsg);




HDC
WINAPI
BeginPaint(
    HWND hWnd,
    PAINTSTRUCT *lpPaint);


BOOL
WINAPI
EndPaint(
    HWND hWnd,
    CONST PAINTSTRUCT *lpPaint);


#define DrawText DrawTextA
int
WINAPI
DrawTextA(
    HDC hDC,
    LPCSTR lpString,
    int nCount,
    RECT *lpRect,
    UINT uFormat);


#define DefWindowProc DefWindowProcA

int
WINAPI
DefWindowProcA(
    HWND hWnd,
    UINT Msg,
    short wParam,
    long lParam);



VOID
WINAPI
PostQuitMessage(
    int nExitCode);

BOOL
WINAPI
UpdateWindow(
    HWND hWnd);

typedef int ATOM;

#define RegisterClass RegisterClassA
ATOM
WINAPI
RegisterClassA(
    CONST WNDCLASS *lpWndClass);

#define GetMessage GetMessageA
BOOL
WINAPI
GetMessageA(
    MSG *lpMsg,
    HWND hWnd ,
    UINT wMsgFilterMin,
    UINT wMsgFilterMax);


BOOL
WINAPI
TranslateMessage(
    CONST MSG *lpMsg);



BOOL
WINAPI
GetClientRect(
    HWND hWnd,
    RECT *lpRect);
