#include <signal.h>
#include <unistd.h>


#include <sys/winbase.h>
#include <sys/wincon.h>
extern int __ptrace;

static int *myp;

/* I'm making a lot of this up as I go along, the doc is just not there */

asm (".equ __except_list,0");
extern long _except_list asm ("%fs:__except_list");

static int etable[3] = {-1, 0, 0};
extern char __syscalls_b[];

_sig_func_ptr __sig_table[NSIG];

static struct
{
  int code;
  char *name;
} status_info[] = 
{
  STATUS_ABANDONED_WAIT_0          ,"STATUS_ABANDONED_WAIT_0",
  STATUS_ACCESS_VIOLATION          ,"STATUS_ACCESS_VIOLATION",
  STATUS_ARRAY_BOUNDS_EXCEEDED     ,"STATUS_ARRAY_BOUNDS_EXCEEDED",
  STATUS_BREAKPOINT                ,"STATUS_BREAKPOINT",
  STATUS_CONTROL_C_EXIT            ,"STATUS_CONTROL_C_EXIT",
  STATUS_DATATYPE_MISALIGNMENT     ,"STATUS_DATATYPE_MISALIGNMENT",
  STATUS_FLOAT_DENORMAL_OPERAND    ,"STATUS_FLOAT_DENORMAL_OPERAND",
  STATUS_FLOAT_DIVIDE_BY_ZERO      ,"STATUS_FLOAT_DIVIDE_BY_ZERO",
  STATUS_FLOAT_INEXACT_RESULT      ,"STATUS_FLOAT_INEXACT_RESULT",
  STATUS_FLOAT_INVALID_OPERATION   ,"STATUS_FLOAT_INVALID_OPERATION",
  STATUS_FLOAT_OVERFLOW            ,"STATUS_FLOAT_OVERFLOW",
  STATUS_FLOAT_STACK_CHECK         ,"STATUS_FLOAT_STACK_CHECK",
  STATUS_FLOAT_UNDERFLOW           ,"STATUS_FLOAT_UNDERFLOW",
  STATUS_GUARD_PAGE_VIOLATION      ,"STATUS_GUARD_PAGE_VIOLATION",
  STATUS_ILLEGAL_INSTRUCTION       ,"STATUS_ILLEGAL_INSTRUCTION",
  STATUS_INTEGER_DIVIDE_BY_ZERO    ,"STATUS_INTEGER_DIVIDE_BY_ZERO",
  STATUS_INTEGER_OVERFLOW          ,"STATUS_INTEGER_OVERFLOW",
  STATUS_INVALID_DISPOSITION       ,"STATUS_INVALID_DISPOSITION",
  STATUS_IN_PAGE_ERROR             ,"STATUS_IN_PAGE_ERROR",
  STATUS_NONCONTINUABLE_EXCEPTION  ,"STATUS_NONCONTINUABLE_EXCEPTION",
  STATUS_NO_MEMORY                 ,"STATUS_NO_MEMORY",
  STATUS_PENDING                   ,"STATUS_PENDING",
  STATUS_PRIVILEGED_INSTRUCTION    ,"STATUS_PRIVILEGED_INSTRUCTION",
  STATUS_SINGLE_STEP               ,"STATUS_SINGLE_STEP",
  STATUS_STACK_OVERFLOW            ,"STATUS_STACK_OVERFLOW",
  STATUS_TIMEOUT                   ,"STATUS_TIMEOUT",
  STATUS_USER_APC                  ,"STATUS_USER_APC",
  STATUS_WAIT_0                    ,"STATUS_WAIT_0",
  0,0};

static void ehandler3(exception *e, int *f, exception_info *in)
{ 
  int i;
  int sig;
  initmine();
  if (__ptrace) {
    long *l= in;

    sprintf (__syscalls_b,"Exception trapped!\n");
    write (1, __syscalls_b, strlen (__syscalls_b));
    sprintf(__syscalls_b,"exception type: %x ax %x bx %x cx %x dx %x\n", e->type, in->eax, in->ebx, in->ecx, in->edx);
    write (1,__syscalls_b,strlen(__syscalls_b));

    sprintf(__syscalls_b,"exception at: %x\n", in->eip);
    write (1,__syscalls_b,strlen(__syscalls_b));
    for ( i = 0; status_info[i].name; i++)
      {
	if (status_info[i].code == e->type) 
	  {
	    sprintf(__syscalls_b,"exception is: %s\n", status_info[i].name);
	    write (1,__syscalls_b,strlen(__syscalls_b));
	    break;
	  }

      }

  }

  /* See if we've got a signal handler installed for it */
  switch (e->type) 
    {
    case STATUS_INTEGER_DIVIDE_BY_ZERO:
      sig = SIGFPE;
      break;
    default:
      sig = SIGSEGV;
      break;
    }


  if (__sig_table[sig] == SIG_DFL
      || __sig_table[sig] == SIG_IGN
      || __sig_table[sig] == SIG_ERR)
    {
      sprintf(__syscalls_b, "Signal %d has no handler\n", sig);
      write (1, __syscalls_b, strlen (__syscalls_b));
      exit(2);
    }

  __sig_table[sig] (sig);

  sprintf(__syscalls_b, "Returned from signal handler !!\n");
  write (1, __syscalls_b, strlen (__syscalls_b));
  exit(2);


}

static
BOOL ctrl_c_handler (WORD type)
{
  int sig;
  initmine();
  switch (type)
    {
    case CTRL_C_EVENT:
      sig = SIGINT;
      break;
    case CTRL_BREAK_EVENT:
      sig = SIGINT;
      break;
    case CTRL_CLOSE_EVENT:
      sig = SIGQUIT;
      break;
    case CTRL_LOGOFF_EVENT:
      sig = SIGQUIT;
      break;
    case CTRL_SHUTDOWN_EVENT:
      sig = SIGQUIT;
      break;
    }

  if (__sig_table[sig] == SIG_DFL)
    return 0;
  if (__sig_table[sig] == SIG_IGN)
    return 1;
  if (__sig_table[sig] == SIG_ERR)
    return 0;

  __sig_table[sig] (sig);

  return 1;
}



initmine()
{
  int *f = myp+5;
  *--f = -1;
  *--f = etable;
  *--f = ehandler3;
  *--f = _except_list ;		/* prev entry */
  _except_list = f;


}
__init_exceptions(int argc, char **argv)
{
  int mine[5];
  myp = mine;
  SetConsoleCtrlHandler (ctrl_c_handler, 1);
  initmine();

  main(argc, argv);
}
