;; HI3 multiply
; the h8 only has an 8*8->16 multiply
; answer is the same as
; 
; product = (srca.l * srcb.l) + ((srca.h * srcb.l) + (srcb.h * srca.l)) * 256
; (we can ignore A1.h * A0.h cause that will all off the top)
; A0 in
; A1 in 
; A0 answer

#ifdef __H8300__

#include "defines.h"

	.global	___mulhi3
___mulhi3:
	mov.b	A1L,A2L		; A2l gets srcb.l
	mulxu	A0L,A2		; A2 gets first sub product 

	mov.b	A0H,A3L		; prepare for
	mulxu	A1L,A3		; second sub product

	add.b	A3L,A2H		; sum first two terms

	mov.b	A1H,A3L		; third sub product
	mulxu	A0L,A3		

	add.b	A3L,A2H		; almost there
	mov.w	A2,A0		; that is
	rts

#endif