	.title "H8/300 DIVIDE"
;; Divide code for the H8/300
;;
;; Steve Chamberlain
;; sac@cygnus.com
;;

; general purpose normalize routine
; 
; divisor in A0
; dividend in A1
; turns both into +ve numbers, and leaves what the answer sign
; should be in A2L

#ifdef __H8300__

#include "defines.h"

divnorm:
	mov.b	#0x0,A2L
	or	A0H,A0H		; is divisor > 0
	bge	_lab1			
	not	A0H		; no - then make it +ve
	not	A0L
	adds	#1,A0			
	xor	#0x1,A2L	; and remember that in A2L
_lab1:	or	A1H,A1H	; look at dividend
	bge	_lab2		
	not	A1H		; it is -ve, make it positive
	not	A1L
	adds	#1,A1
	xor	#0x1,A2L; and toggle sign of result
_lab2:	rts


; A0=A0/A1 signed

	.global	___divhi3
___divhi3:

	bsr	divnorm
	bsr	___udivhi3
negans:	or	A2L,A2L	; should answer be negative ?
	beq	_lab4
	not	A0H	; yes, so make it so
	not	A0L
	adds	#1,A0
_lab4:	rts	


; A0=A0%A1 signed

	.global	___modhi3
___modhi3:

	bsr	divnorm
	bsr	___udivhi3
	mov	A3,A0
	bra	negans


; A0=A0%A1 unsigned

	.global	___umodhi3
___umodhi3:
	bsr	___udivhi3
	mov	A3,A0
	rts


; A0=A0/A1 unsigned
; A3=A0%A1 unsigned
; A2H trashed
	.global	___udivhi3
; D high 8 bits of denom
; d low 8 bits of denom
; N high 8 bits of num
; n low 8 bits of num
; M high 8 bits of mod
; m low 8 bits of mod
; Q high 8 bits of quot
; q low 8 bits of quot
; P preserve

; the h8 only has a 16/8 bit divide, so we look at the incoming and
; see how to partition up the expression.
___udivhi3:
				; A0 A1 A2 A3 
				; Nn Dd       P
	sub.w	A3,A3		; Nn Dd xP 00 
	or	A1H,A1H		 
	bne	divlongway
	or	A0H,A0H		
	beq	_lab6		

; we know that D ==0 and N is !=0
	mov.b	A0H,A3L		; Nn Dd xP 0N
	divxu	A1L,A3		;          MQ
	mov.b	A3L,A0H	 	; Q
; dealt with N, do n
_lab6:	mov.b	A0L,A3L		;           n
	divxu	A1L,A3		;          mq
	mov.b	A3L,A0L		; Qq
	mov.b	A3H,A3L         ;           m
	mov.b	#0x0,A3H	; Qq       0m
	rts	

; D!=0 - which means the denominator is
;        loop around to get the result.

divlongway:
	mov.b	A0H,A3L		; Nn Dd xP 0N
	mov.b	#0x0,A0H	; high byte of answer has to be zero
	mov.b	#0x8,A2H	;       8
div8:	add.b	A0L,A0L		; n*=2
	rotxl	A3L		; Make remainder bigger
	rotxl	A3H		
	sub.w	A1,A3		; Q-=N
	bhs	setbit		; set a bit ?
	add.w	A1,A3		;  no : too far , Q+=N

	dec	A2H		
	bne	div8		; next bit	
	rts	

setbit:	inc	A0L		; do insert bit
	dec	A2H		
	bne	div8		; next bit	
	rts	

#endif
