! Copyright (c) 1995 Cygnus Support
!
! The authors hereby grant permission to use, copy, modify, distribute,
! and license this software and its documentation for any purpose, provided
! that existing copyright notices are retained in all copies and that this
! notice is included verbatim in any distributions. No written agreement,
! license, or royalty fee is required for any of the authorized uses.
! Modifications to this software may be copyrighted by their authors
! and need not follow the licensing terms described here, provided that
! the new terms are clearly indicated on the first page of each file where
! they apply.
!
! C startup code for the Fujitsu SPARClite demo board

	.text
	.align 8

win_ovf_trap:
	sethi %hi(win_ovf), %l3
	jmpl %lo(win_ovf)+%l3, %g0
	mov %wim, %l0
	nop

win_unf_trap:
	sethi %hi(win_unf), %l3
	jmpl %lo(win_unf)+%l3, %g0
	mov %wim, %l0
	nop

	.globl start

start:
! First, copy prom & trap vectors to sram

	set 0x30000000, %l0
	set 0xfff8, %l1

copyloop:
	ldd [%l1], %l2
	std %l2, [%l0 + %l1]
	subcc %l1, 8, %l1
	bge copyloop
	nop

	set 0x30000000, %l0
	mov %l0, %tbr			! Install the new tbr

	set win_ovf_trap, %l1		! Setup window overflow trap
	ldd [%l1], %l2
	std %l2, [%l0 + 5 * 16]
	ld [%l1 + 8], %l2
	st %l2, [%l0 + 5 * 16 + 8]

	set win_unf_trap, %l1		! Setup window underflow trap
	ldd [%l1], %l2
	std %l2, [%l0 + 6 * 16]
	ld [%l1 + 8], %l2
	st %l2, [%l0 + 6 * 16 + 8]

	set _main, %g1
	jmp %g1
	nop
