/*
 * setup entry point into the ROM monitor
 */
#define BASEENTRY	0xbfc00000
#define PROM_ENTRY(x)   (BASEENTRY+((x)*8))
#define GETCHAR          (*(int (*)())(unsigned char)PROM_ENTRY(11))		/* getchar from console */
#define PUTCHAR          (*(int (*)())PROM_ENTRY(12))		/* putchar to console */
#define GETS             PROM_ENTRY(14)		/* gets with editing */
#define PUTS             PROM_ENTRY(15)		/* puts to console */

/* (*(int (*)())((int *)(*((int *)PGZ_MEM_PDC)))) */

/*
 * define common register names
 */
#define zero	$0

/* function return registers $2 and $3 */
#define v0	$2
#define v1	$3

/* incoming argument registers $4 - $7 */
#define a0	$4
#define a1	$5
#define a2	$6
#define a3	$7

/* temporaries $8 - $15 */
#define t0	$8
#define t1	$9
#define t2	$10
#define t3	$11
#define t4	$12
#define t5	$13
#define t6	$14
#define t7	$15

/* saved temporaries $16 - $23 */
#define s0	$16
#define s1	$17
#define s2	$18
#define s3	$19
#define s4	$20
#define s5	$21
#define s6	$22
#define s7	$23

/* temporaries $24 ansd $25 */
#define t8	$24
#define t9	$25

/* exception handling $26 and $27 */
#define k0	$26
#define k1	$27

#if 0			/* These two are defined by the assembler */
/* global data pointer $28 */
#define gp	$28

/* stack pointer $29 */
#define sp	$29
#endif

/* saved temporaries $30 */
#define s8	$30

/* return address $31 */
#define ra	$31
