/*
 * crt0.S -- startup file for MIPS.
 *		rob@cygnus.com (Rob Savoye)
 */

/*
 * Set up some room for a stack. We just grab a chunk of memory.
 */
#include "mips.h"

#define STACK_SIZE  0x2000
#define GLOBAL_SIZE 0x2000

        .comm   stack,   STACK_SIZE
	.comm	environ, 0x1
	.comm	globals, GLOBAL_SIZE 

	.text
	.align	2
	.globl	_exit
	.globl	start

	.ent	start
start:
	la	v0, _bss_start
	la	v1, _end

bssloop:
	sw	zero,0(t0)
	addiu	v0,v0,4
	bne	v0,v1,bssloop

	la	$sp, stack			# set set stack pointer
	la	$gp, globals			# set the global data pointer

	# call the main C routine
	jal	main
	.end start

/*
 * _exit -- Exit from the application. Normally we cause a user trap
 *          to return to the ROM monitor for another run.
 */
	.ent _exit
_exit:
	nop
	break	0
	j	start				# go back to the beginning
	.end _exit




