#include "op50n.h"

void zylons();
void strobe();
void led_putnum();
void delay();

/*
 * led_putnum -- print a hex number on the LED. the value of num must be a byte. 
 *		 The max number 15, since the front panel only has 4 LEDs.
 */
void
led_putnum ( num )
char num;
{
    static unsigned char *leds = (unsigned char *)LED_ADDR;
    
/**    *leds = (num << 4); **/
    *leds = num;
}

/*
 * strobe -- do a zylons thing, toggling each led in sequence forever...
 */
void
zylons()
{
  while (1) {
    strobe();
  }
}

/*
 * strobe -- toggle each led in sequence up and back once.
 */
void
strobe()
{
  static unsigned char curled;
  static unsigned char dir;

  curled = 1;
  dir = 0;
  while (curled != 0) {
    led_putnum (curled);
    delay (70000);
    if (dir)
      curled >>= 1;
    else
      curled <<= 1;
    
    if (curled == 0x100) {
      dir = ~dir;
    }
  }
  curled = 1;
  dir = 0;
}

void
delay (x)
     int x;
{
  int  y = 17;
  while (x-- !=0)
    y = y^2;
}
