/*
; HP PA-RISC division support for implementations without FP hardware

; Uses a special calling convention and register usage convention
; r29 = r26 op r25
; We're allowed to clobber r1. r31 and the input operands r25 and r26
; r31 is used for linkage by the calling routine



; rem_ptr	gr26
; n1		gr25
; n0		gr24
; d		gr23

; The code size is a bit excessive.  We could merge the last two ds;addc
; sequences by simply moving the "bb,< Odd" instruction down.  The only
; trouble is the FFFFFFFF code that would need some hacking.
*/

#if SPECIAL_CALLING_CONVENTION
#define dividend %r26
#define divisor %r25
#define quotient %r29
#define tmp %r1
#define ret %r31
#else
#define dividend %r26
#define divisor %r25
#define quotient %r28
#define tmp %r1
#define ret %r2
#endif

#if SPECIAL_CALLING_CONVENTION
	.space $TEXT$
	.subspa $MILLICODE$,quad=0,align=8,access=0x2c,sort=8
	.align 4
	.export $$divU
$$divU
#else
	.space $TEXT$
	.subspa $CODE$
	.align 4
	.export milli_div,entry,priv_lev=3,argw0=gr,argw1=gr,rtnval=gr
milli_div
#endif
	.proc
	.callinfo	frame=0,no_calls
	.entry

	comb,<		divisor,0,L$largedivisor
	 sub		%r0,divisor,%r1
	ds		%r0,%r1,%r0
	addc		dividend,dividend,dividend
	ds		%r0,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,quotient
	ds		%r1,divisor,%r1
	comclr,>=	%r1,%r0,%r0
	addl		%r1,divisor,%r1
	bv		0(ret)
	 addc		quotient,quotient,quotient

L$largedivisor
	comclr,>>	divisor,dividend,quotient
	ldi		1,quotient
	bv,n		0(ret)


	.exit
	.procend
