/* divU_12

HP PA-RISC division support for implementations without FP hardware

Uses a special calling convention and register usage convention
r29 = r26 op r25
We're allowed to clobber r1. r31 and the input operands r25 and r26
r31 is used for linkage by the calling routine

*/

#define dividend %r26
#define divisor %r25
#define tmp %r1

#if SPECIAL_CALLING_CONVENTION
#define result %r29
#define ret %r31
#else
#define result %r28
#define ret %r2
#endif

#if SPECIAL_CALLING_CONVENTION
	.space $TEXT$
	.align 4
	.export $$divU_12
$$divU_12
#else
	.space $TEXT$
	.align 4
	.export milli_divU_12,entry,priv_lev=3,argw0=gr,argw1=gr,rtnval=gr
milli_divU_12
#endif
	.proc
	.callinfo	frame=0,no_calls
	.entry

	sh2add	%r26,%r26,%r29		; r29 = lo(101 x r)
	shd	%r0,%r26,30,%r1		;  r1 = hi(100 x r)
	addc	%r1,%r0,%r1		;  r1 = hi(101 x r)
; r in r1,,r29
	zdep	%r29,27,28,%r25		; r25 = lo(10000 x r)
	add	%r25,%r29,%r25		; r25 = lo(10001 x r)
	shd	%r1,%r29,28,%r29	; r29 = hi(10000 x r)
	addc	%r29,%r1,%r29		; r29 = hi(10001 x r)
; r in r29,,r25
	zdep	%r25,23,24,%r1		;  r1 = lo(100000000 x r)
	add	%r1,%r25,%r1		;  r1 = lo(100000001 x r)
	shd	%r29,%r25,24,%r25	; r25 = hi(100000000 x r)
	addc	%r25,%r29,%r25		; r25 = hi(100000001 x r)
; r in r25,,r1
	zdep	%r1,15,16,%r29
	add	%r29,%r1,%r29
	shd	%r25,%r1,16,%r1
	addc	%r1,%r25,%r1
; r in r1,,r29
	sh1add	%r29,%r26,%r0		;  r0 = lo(10 x r) + dividend
	shd	%r1,%r29,31,%r29	; r29 = hi(10 x r)
	addc	%r29,%r0,%r29

	bv	0(ret)
	extru	%r29,28,29,result

	.exit
	.procend
