/* Macintosh MPW host definitions for GNU C Compiler.
   Copyright (C) 1993, 1994 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define bzero(a,b) memset(a,0,b)
#define bcopy(a,b,c) memcpy(b,a,c)
#define bcmp(a,b,c) memcmp(a,b,c)

#ifndef MPW
#define MPW
#endif

#define HAVE_PUTENV

#define NO_STAB_H

/* This tweaks the preprocessor to like double slash as a comment. */

#define CPLUSPLUS

/* #defines that need visibility everywhere.  */
#define FALSE 0
#define TRUE 1

/* This describes the machine the compiler is hosted on.  */
#define HOST_BITS_PER_CHAR 8
#define HOST_BITS_PER_SHORT 16
#define HOST_BITS_PER_INT 32
#define HOST_BITS_PER_LONG 32
#define HOST_BITS_PER_LONGLONG 64

#define HOST_WORDS_BIG_ENDIAN

#ifdef MPW_C
#define ONLY_INT_FIELDS

#define __PTR_TO_INT(P) ((int)(P))
#define __INT_TO_PTR(P) ((char *)(P))

#endif /* MPW_C */

#include <Errors.h>

/* Target machine dependencies.
   tm.h is a symbolic link to the actual target specific file.   */

#include "tm.h"

/* Arguments to use with `exit'.  */
#define SUCCESS_EXIT_CODE 0
#define FATAL_EXIT_CODE 33

/* If compiled with GNU C, use the built-in alloca */
#ifdef __GNUC__
/* Use an arg in this macro because that's what some other
   system does--let's avoid conflict.  */
#define alloca(x) __builtin_alloca(x)
#endif

#include <Types.h>

/* MPW C doesn't know about alloca. */
#ifndef __GNUC__
#define USE_C_ALLOCA
#endif

#define index strchr
#define rindex strrchr

/* We want all newly created files to be type TEXT and creator 'MPS ', that is,
   MPW Shell docs that we can look at by double-clicking.  To do this, we
   translate regular fopen into a call to our own routine. */

#ifdef __STDIO__
FILE *mpw_fopen();
#endif

int fstat (int, struct stat *);
int stat (char *, struct stat *);

#define fopen(a,b) mpw_fopen(a,b)
#define open mpw_open
#define access mpw_access

#define SHORT_ENUM_BUG

/* MPW uses a comma to separate the directories in a search path. */

#define PATH_SEPARATOR ','

#define PRINT_FILE_AND_LINE(FILE,LINE) \
  fprintf (stderr, "File \"%s\"; Line %d\t# ", (FILE), (LINE))

#include "spin.h"
