/* Definitions of target machine for GNU compiler.
   Hitachi H8/500 version generating coff
   Copyright (C) 1993, 1995 Free Software Foundation, Inc.
   Contributed by Steve Chamberlain (sac@cygnus.com)
              and Jim Wilson        (wilson@cygnus.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES ""

/* Write out defines which depend on the compilation options */
#define NO_BUILTIN_SIZE_TYPE
#define NO_BUILTIN_PTRDIFF_TYPE

/* These are the combinations.

   			code	data	size_t
default	-mtiny		S	S	HI
	-msmall		S	S	HI
	-mmedium	L	S	HI	
	-mcompact	S	L	HI	
	-mbig		L	L	HI
*/

#define CPP_SPEC \
 "-Acpu(h8500) -Amachine(h8500) -D__H8500__ -D__SIZE_TYPE__=unsigned \
 %{mbig:   -D__CODE__=32 -D__DATA__=32 -D__TINY__=0 -D__PDIFF__=16 -D__PTRDIFF_TYPE__=int}\
 %{mmedium:-D__CODE__=32 -D__DATA__=16 -D__TINY__=0 -D__PDIFF__=16 -D__PTRDIFF_TYPE__=int}\
 %{mcompact:-D__CODE__=16 -D__DATA__=32 -D__TINY__=0 -D__PDIFF__=16 -D__PTRDIFF_TYPE__=int}\
 %{msmall: -D__CODE__=16 -D__DATA__=16 -D__TINY__=0 -D__PDIFF__=16 -D__PTRDIFF_TYPE__=int}\
 %{!mbig:%{!mcompact:%{!mmedium:%{!msmall:-D__CODE__=16 -D__DATA__=16 -D__TINY__=1 -D__PDIFF__=16 -D__PTRDIFF_TYPE__=int}}}}\
 %{!mint32:-D__INT_MAX__=32767} %{mint32:-D__INT_MAX__=2147483647}\
 %{mlong16:-D__LONG_MAX__=32767} %{!mlong16:-D__LONG_MAX__=2147483647}"

#define LINK_SPEC 		\
	"%{mbig:-m h8500b}	\
	 %{mmedium:-m h8500m}	\
 	 %{msmall:-m h8500s}	\
	 %{mcompact:-m h8500c}"

#define PTRDIFF_TYPE	"int"
#define SIZE_TYPE	"unsigned int"
#define OFFSET_SIZE	16

#define OPTIMIZATION_OPTIONS(OPTIMIZE)     			\
  flag_cse_follow_jumps = (OPTIMIZE >= 1); 			\
  flag_caller_saves = 0;

/* Print subsidiary information on the compiler version in use.  */

#define TARGET_VERSION fprintf (stderr, " (Hitachi H8/500)");

/* Sometimes certain combinations of command options do not make 
   sense on a particular target machine.  You can define a macro 
  `OVERRIDE_OPTIONS' to take account of this.  This macro, if defined,
  is executed once just after all the command options have  been parsed. */

#define OVERRIDE_OPTIONS   override_options ()

/* Generate SDB debugging information.  */

#define SDB_DEBUGGING_INFO
#define SDB_DELIM	";"

/* Output DBX (stabs) debugging information if doing -gstabs.  */

#define DBX_DEBUGGING_INFO

/* Generate SDB debugging information by default. */

#define PREFERRED_DEBUGGING_TYPE SDB_DEBUG

/* Run-time compilation parameters selecting different hardware subsets.  */

extern int target_flags;

#define MASK_INT32	1
#define MASK_LONG16	2
#define MASK_SLOWBYTE	4
#define MASK_REGPARM	8
#define MASK_SPACE	16
#define MASK_CODE32	32
#define MASK_DATA32	64
#define MASK_RTL	128

/* Nonzero if ints should be 32bits long.  */
#define TARGET_INT32	(target_flags & MASK_INT32)

/* Nonzero if longs should be 16bits long. */
#define TARGET_LONG16	(target_flags & MASK_LONG16)

/* Nonzero if byte fetches are slow on this machine. */
#define TARGET_SLOWBYTE	(target_flags & MASK_SLOWBYTE)

/* Nonzero if parameters passed in registers.  */
#define TARGET_REGPARM	(target_flags & MASK_REGPARM)

/* Nonzero if optimizing for space.  */
#define TARGET_SPACE	(target_flags & MASK_SPACE)

/* Nonzero if optimizing for speed.  */
#define TARGET_SPEED	(!TARGET_SPACE)

/* Nonzero if the code space needs 32bit addresses. */
#define TARGET_CODE32	(target_flags & MASK_CODE32)

/* Nonzero if the data space needs 32bit addresses. */
#define TARGET_DATA32	(target_flags & MASK_DATA32)

/* These can't be extern'd because they are used by various macros that
   the gen* programs need.  */
/* ??? There's a certain amount of bug-potential here.  */
int code_size;
int data_size;

/* Nonzero to dump rtl in assembly output file.  */
#define TARGET_DUMP_RTL	(target_flags & MASK_RTL)

/* Macro to define tables used to set the flags.
   This is a list in braces of pairs in braces,
   each pair being { "NAME", VALUE }
   where VALUE is the bits to set or minus the bits to clear.
   An empty string NAME is used to identify the default VALUE.  */

#define TARGET_SWITCHES  			\
{ {"int32",	MASK_INT32},			\
  {"long16",	MASK_LONG16},			\
  {"slowbyte",	MASK_SLOWBYTE},			\
  {"code32",	MASK_CODE32}, 			\
  {"data32",	MASK_DATA32}, 			\
  {"space",	MASK_SPACE}, 			\
  {"speed",	-MASK_SPACE},			\
  {"small",	-(MASK_CODE32+MASK_DATA32)},	\
  {"tiny",	-(MASK_CODE32+MASK_DATA32)},	\
  {"medium",	-MASK_DATA32},			\
  {"medium",	MASK_CODE32},			\
  {"compact",	-MASK_CODE32},			\
  {"compact",	MASK_DATA32},			\
  {"big",	MASK_DATA32|MASK_CODE32},	\
  {"regparm",	MASK_REGPARM},			\
  {"noregparm",	-MASK_REGPARM},			\
  {"r",		MASK_RTL},			\
  { "",		TARGET_DEFAULT}}

/* Default target_flags if no switches specified.  */
#define TARGET_DEFAULT (MASK_REGPARM)

/* Target machine storage layout */

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields.
   This is not true on the H8/500.  */
#define BITS_BIG_ENDIAN 0

/* Define this if most significant byte of a word is the lowest numbered.  
   That is true on the H8/500.  */
#define BYTES_BIG_ENDIAN 1

/* Define this if most significant word of a multiword number is lowest
   numbered.
   This is true on an H8/500 (actually we can make it up, but we choose to
   be consistent).  */
#define WORDS_BIG_ENDIAN 1

/* Number of bits in an addressable storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", which is the contents of a machine register.
   Note that this is not necessarily the width of data type `int';
   if using 16-bit ints on a 68000, this would still be 32.
   But on a machine with 16-bit registers, this would be 16.  */
#define BITS_PER_WORD 	16
#define MAX_BITS_PER_WORD 16

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD 2

/* Sizes of various types. */

#define POINTER_SIZE    	((TARGET_DATA32 || TARGET_CODE32) ? 32 : 16)
#define SHORT_TYPE_SIZE 	16
#define INT_TYPE_SIZE 		(TARGET_INT32 ? 32 : 16)
#define LONG_TYPE_SIZE 		(TARGET_LONG16 ? 16 : 32)
#define LONG_LONG_TYPE_SIZE	32
#define DOUBLE_TYPE_SIZE	32
#define FLOAT_TYPE_SIZE		32
#define LONG_DOUBLE_TYPE_SIZE 	32

/* Since ints and longs are variable, we need to define these.  */
#define MAX_INT_TYPE_SIZE	32
#define MAX_LONG_TYPE_SIZE	32

/* Wide characters.  */
#define WCHAR_TYPE		"short unsigned int"
#define WCHAR_TYPE_SIZE		16

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY 16

/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY 8

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY (16)

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 8

/* A bitfield declared as `int' forces `int' alignment for the struct.  */
#define PCC_BITFIELD_TYPE_MATTERS  0

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT 16

/* No structure field wants to be aligned rounder than this.  */
#define BIGGEST_FIELD_ALIGNMENT 16

/* The stack goes in 16bit lumps. */
#define STACK_BOUNDARY 16

/* Define this if move instructions will actually fail to work
   when given unaligned data.  */
#define STRICT_ALIGNMENT 1

/* Standard register usage.  */

/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.

   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.

   The H8/500 has 8 general registers, and the program counter.  We
   keep a reg for the argument pointer, but that is always eliminated
   before code output.

   There is also dp, ep, tp, cp.  8+1+1+4 = 14.  */

#define FIRST_PSEUDO_REGISTER 14

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.

   The H8/500 uses r6 and r7 as the fp and sp.  */

#define FIXED_REGISTERS \
  /*  r0 r1 r2 r3 r4 r5 r6 r7 pc ap dp ep tp cp */ \
   {   0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }

#define R0_R 0
#define R1_R 1
#define R2_R 2
#define R3_R 3
#define R4_R 4
#define R5_R 5
#define R6_R 6
#define R7_R 7
#define PC_R 8
#define AP_R 9

#define DP_R 10
#define EP_R 11
#define TP_R 12
#define CP_R 13

#define PREG_1 R2_R
#define PREG_2 R4_R
#define PREG_3 R6_R
#define PREG_4 R7_R

/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you
   like. */

#define CALL_USED_REGISTERS \
  { 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1 }

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.

   On the H8/500, ordinary registers hold 16 bits worth.  When storing
   pointers into a seg:reg pair, an ordinary register is backed up by
   a segment register, so it can hold an entire pointer in one go. */

#define HARD_REGNO_NREGS(REGNO, MODE) \
  ((REGNO)==7 || (data_size == 32 && MODE == PSImode && SEG_REG_P (REGNO)) \
   ? 1 : CLASS_MAX_NREGS (REGNO_REG_CLASS (REGNO), MODE))

#define PTR_REG_P(X) \
 (data_size==32 \
  ? ((X)==PREG_1||((X)==PREG_2)||((X)==PREG_3)||((X)==PREG_4)) \
  : ((X) <= R7_R))

#define SEG_REG_P(X) \
 (data_size==32 \
  ? ((X)==PREG_1||((X)==PREG_2)||((X)==PREG_3)||((X)==PREG_4)) \
  : 0)

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE.  */

extern int ok_modes[];

#define HARD_REGNO_MODE_OK(REGNO, MODE) (ok_modes[REGNO] & (1<<(MODE)))

/* ??? Huh?  */
#define MAX_FIXED_MODE_SIZE HImode

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */

#define MODES_TIEABLE_P(MODE1, MODE2)  ((MODE1)==(MODE2))

/* Specify the registers used for certain standard purposes.
   The values of these macros are register numbers.  */

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM R7_R

/* Base register for access to local variables of the function.  */
#define FRAME_POINTER_REGNUM R6_R

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.  

   When working in large mode we always use an fp, to stop reload
   wanting to use r6 as a temp and clobbering the stack segment
   register. 

   Infact, offsets from the fp are smaller than from the sp anyway, so
   lets always use the fp.  */

#define FRAME_POINTER_REQUIRED 1

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM AP_R

/* Register in which static-chain is passed to a function.  */
#define STATIC_CHAIN_REGNUM ((TARGET_CODE32||TARGET_DATA32) ? 0 : 4)

/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */

/* NON_ADDR_REG_CLASS is for the benefit of regclass, so that when it
   computes register class preferences, registers which don't need
   an address register can be directed to this class.  This reduces the
   number of reloads needed for address registers by avoiding putting
   things in them which don't need an address reg.  */

enum reg_class
{
  NO_REGS, STACK_REG_CLASS, ADDR_REG_CLASS, NON_ADDR_REG_CLASS, ALL_REGS, LIM_REG_CLASSES
};

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file.   */

#define REG_CLASS_NAMES \
 {"NO_REGS", "STACK_REG", "ADDR_REG", "NON_ADDR_REG", "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

#define ADDR_REG_BIT	          ((1<<PREG_1)|(1<<PREG_2)|(1<<PREG_3)|(1<<PREG_4))
#define STACK_REG_BIT	          ((1<<PREG_3)|(1<<PREG_4))
#define ALL_REGS_BIT              0xff
#define REG_CLASS_CONTENTS  				\
 {0,  STACK_REG_BIT, ADDR_REG_BIT,  (~ADDR_REG_BIT)&ALL_REGS_BIT,  ALL_REGS_BIT}

#define GENERAL_REGS ALL_REGS

/* The same information, inverted. Return the class number of the 
  smallest class containing reg  number REGNO.  This could be a
  conditional expression or could index an array.  */

#define REGNO_REG_CLASS(R) 	\
  (((TARGET_DATA32 &&((R) == PREG_1|| (R) == PREG_2 || (R) == PREG_3 || (R) == PREG_4))) ? ADDR_REG_CLASS : NON_ADDR_REG_CLASS)

/* The class value for index registers, and the one for base regs.  */

/* There are no index registers.  */
#define INDEX_REG_CLASS NO_REGS

/* When in large mode, only r2 and r4 may be used as base registers.  */
#define BASE_REG_CLASS  (TARGET_DATA32 ? ADDR_REG_CLASS : GENERAL_REGS)

/* Get reg_class from a letter such as appears in the machine description.  */

#define REG_CLASS_FROM_LETTER(C)  \
  ((C) == 'a' && TARGET_DATA32 ? ADDR_REG_CLASS :\
   (C) == 'b' ? ADDR_REG_CLASS : \
   (C) == 'c' ? STACK_REG_CLASS : NO_REGS)

/* The letters I, J, K, L, M, N, O, P in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.

   I = value for a quick immediate, -2,-1,1,2
   P is a power of two
   J = zero
*/

#define CONST_OK_FOR_I(VALUE) ((VALUE) == -2 ||(VALUE) == -1 ||(VALUE) == 1 ||(VALUE) == 2) 
#define CONST_OK_FOR_J(VALUE) ((VALUE) == 0)
#define CONST_OK_FOR_P(VALUE) (exact_log2(VALUE) >= 0)
#define CONST_OK_FOR_O(VALUE) (exact_log2(~VALUE) >= 0)
#define CONST_OK_FOR_N(VALUE) (exact_log2(~((VALUE) | (~0xff))) >=0)

#define CONST_OK_FOR_LETTER_P(VALUE, C) \
  ((C) == 'I' ? CONST_OK_FOR_I(VALUE) : \
   (C) == 'P' ? CONST_OK_FOR_P(VALUE) : \
   (C) == 'O' ? CONST_OK_FOR_O(VALUE) : \
   (C) == 'N' ? CONST_OK_FOR_N(VALUE) : \
   (C) == 'J' ? CONST_OK_FOR_J(VALUE) : \
   0)

/* Similar, but for floating constants, and defining letters G and H.
   Here VALUE is the CONST_DOUBLE rtx itself.

   `G' is a floating-point zero.  */

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) \
  ((C) == 'G' ? ((VALUE) == CONST0_RTX (DFmode)		\
		 || (VALUE) == CONST0_RTX (DFmode)) /* ??? Huh?  */ \
   : 0)

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  */

#define PREFERRED_RELOAD_CLASS(X,CLASS) \
 (0 && GET_MODE (X) == PSImode ? ADDR_REG_CLASS : CLASS)

/* Allocate an HImode scratch for PSImode moves to or from memory
   in the big memory model.  */

#define SECONDARY_INPUT_RELOAD_CLASS(CLASS, MODE, X) \
  ((MODE) == PSImode							     \
   && (GET_CODE (X) == REG || GET_CODE (X) == SUBREG || GET_CODE (X) == MEM) \
   && (true_regnum (X) == -1 || true_regnum (X) >= FIRST_PSEUDO_REGISTER)    \
   ? ALL_REGS : NO_REGS)

/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS.  */

/* On the H8/500, this is the size of MODE in words,
   except for the ADDR regs in large mode which can hold a PSI on
   their own.  */

#define CLASS_MAX_NREGS(CLASS, MODE) 		\
 (CLASS == ADDR_REG_CLASS && (MODE) == PSImode 	\
  ? 1	 : (GET_MODE_SIZE (MODE) + 1) / 2)

/* Any SI register to register move may need to be reloaded,
   so define REGISTER_MOVE_COST to be > 2 so that reload never
   shortcuts.  */

#define REGISTER_MOVE_COST(CLASS1, CLASS2) 2

/* Stack layout; function entry, exit and calling.  */

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
#define STACK_GROWS_DOWNWARD

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.  */
#define FRAME_GROWS_DOWNWARD

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */
#define STARTING_FRAME_OFFSET 0

/* If we generate an insn to push BYTES bytes,
   this says how many the stack pointer really advances by.

   On the h8/500, @-sp really pushes a byte if you ask it to - but
   that's dangerous, so we claim that it always pushes a word, then we
   catch the mov.b rx,@-sp and turn it into a mov.w rx,@-sp on output.
   */
#define PUSH_ROUNDING(BYTES)   (((BYTES) + 1) & ~1)

/* Offset of first parameter from the argument pointer register value.  */

/* Is equal to the size of the saved fp + pc, even if an fp isn't
   saved since the value is used before we know */
#define FIRST_PARM_OFFSET(FNDECL) 0

/* Value is the number of bytes of arguments automatically
   popped when returning from a subroutine call.
   FUNDECL is the declaration node of the function (as a tree),
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.
   SIZE is the number of bytes of arguments passed on the stack.

   On the H8/500 the return does not pop anything.  */

#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,SIZE) 0

/* Definitions for register eliminations.

   This is an array of structures.  Each structure initializes one pair
   of eliminable registers.  The "from" register number is given first,
   followed by "to".  Eliminations of the same "from" register are listed
   in order of preference.

   We have two registers that can be eliminated on the H8/500.  First, the
   frame pointer register can often be eliminated in favor of the stack
   pointer register.  Secondly, the argument pointer register can always be
   eliminated; it is replaced with either the stack or frame pointer. */

#define ELIMINABLE_REGS				\
{{ ARG_POINTER_REGNUM, STACK_POINTER_REGNUM},	\
 { ARG_POINTER_REGNUM, FRAME_POINTER_REGNUM},   \
 { FRAME_POINTER_REGNUM, STACK_POINTER_REGNUM}}

#define CAN_ELIMINATE(FROM, TO)					\
 ((FROM) == ARG_POINTER_REGNUM && (TO) == STACK_POINTER_REGNUM	\
  ? ! frame_pointer_needed					\
  : 1)

/* Define the offset between two registers, one to be eliminated, and the other
   its replacement, at the start of a routine.  */

#define INITIAL_ELIMINATION_OFFSET(FROM, TO, OFFSET)                       \
{									   \
  OFFSET = 0;							   	   \
									   \
  if ((FROM) == ARG_POINTER_REGNUM && (TO) == FRAME_POINTER_REGNUM)	   \
    (OFFSET) = GET_MODE_SIZE (PmodeCode) + GET_MODE_SIZE (HImode);	   \
  else									   \
    {									   \
      int regno;							   \
      int offset = 0;							   \
									   \
      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)		   \
	if ((regs_ever_live[regno]					   \
	     && (!call_used_regs[regno] || regno == FRAME_POINTER_REGNUM)))\
	  offset += 2;							   \
									   \
      (OFFSET) = offset + get_frame_size ();				   \
									   \
      if ((FROM) == ARG_POINTER_REGNUM && (TO) == STACK_POINTER_REGNUM)	   \
	(OFFSET) += GET_MODE_SIZE (PmodeCode);	/* Skip saved PC */	   \
    }									   \
}									   \

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.

   On the H8/500 the return value is in R0/R1. */

#define FUNCTION_VALUE(VALTYPE, FUNC) \
 gen_rtx (REG, TYPE_MODE (VALTYPE), R0_R)

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  
  
   On the H8/500 the return value is in R0/R1 */

#define LIBCALL_VALUE(MODE)  \
  gen_rtx (REG, MODE, R0_R)

/* 1 if N is a possible register number for a function value.
   On the H8, R0 is the only register thus used.  */
#define FUNCTION_VALUE_REGNO_P(N) ((N) == R0_R)

/* 1 if N is a possible register number for function argument passing.
   On the H8/500, r0-r1 are used to pass args.  */
#define FUNCTION_ARG_REGNO_P(REGNO)  \
  ((REGNO) >= 0 && (REGNO) < NARG_REGS)

/* Register in which address to store a structure value
   is passed to a function, or 0 to use `invisible' first argument.  */
#define STRUCT_VALUE 0

/* Return true if X should be returned in memory.  */
/* ??? BLKmode?  */
#define RETURN_IN_MEMORY(X) (GET_MODE_SIZE (TYPE_MODE (X)) > 4)

#define SMALL_REGISTER_CLASSES

/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   Hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.

   On the h8, this is a two item struct, the first is the number of bytes
   scanned so far and the second is the rtx of the called library
   function if any*/

#define CUMULATIVE_ARGS int

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.

   On the H8, the offset starts at 0.  */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME)	\
 ((CUM) = 0)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)  */

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)  \
  (CUM) += ((MODE) != BLKmode                       \
	    ? (GET_MODE_SIZE (MODE) + 1) & ~1       \
	    : (int_size_in_bytes (TYPE) + 1) & ~1)  

/* Define where to put the arguments to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).  */

/* On the H8/500 we keep some args in a register in small model */

#define NARG_REGS ((TARGET_CODE32||TARGET_DATA32) ? 0 : 4)

/* On the H8/500, normally the first 4 bytes are passed in registers r0-r1; all
   other arguments are passed on the stack.  If (NAMED == 0) (which happens
   only in assign_parms, since SETUP_INCOMING_VARARGS is defined), say it is
   passed in the stack (function_prologue will indeed make it pass in the
   stack if necessary).  */

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)  			\
  ((NAMED)							\
   ? ((CUM) >= NARG_REGS *2 ? 0 : gen_rtx (REG, MODE, (CUM) / 2))	\
   : 0)

/* For an arg passed partly in registers and partly in memory,
   this is the number of registers used.
   For args passed entirely in registers or entirely in memory, zero.  */

#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED)  \
  ((CUM) < NARG_REGS *2 && NARG_REGS *2 < (CUM) + ((MODE) != BLKmode \
			       ? GET_MODE_SIZE (MODE)       \
			       : int_size_in_bytes (TYPE))  \
   ? NARG_REGS - (CUM) / 2 : 0)

/*#define FUNCTION_ARG_PARTIAL_NREGS 0*/

extern int current_function_anonymous_args;

/* Perform any needed actions needed for a function that is receiving a
   variable number of arguments. */

#define SETUP_INCOMING_VARARGS(ASF, MODE, TYPE, PAS, ST) \
  current_function_anonymous_args = 1;

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */
#define FUNCTION_PROLOGUE(FILE, SIZE) \
  function_prologue(FILE,SIZE)

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#define FUNCTION_PROFILER(FILE, LABELNO)  \
   fprintf (FILE, "\tmov.w #LP%d,r0\n\tjsr @mcount\n", (LABELNO));

/* Output assembler code to FILE to initialize this source file's
   basic block profiling info, if that has not already been done.  */

#define FUNCTION_BLOCK_PROFILER(FILE, LABELNO)  \
 fprintf (FILE, "\tpush r0\nmov.w	@LPBX0,r0\n\tbne LPI%d\n\tmov.w @LPBX0,r0\n\tpush\tr0\n\tjsr\t@__bb_init_func\nLPI%d:\tpop\tr0\n",     LABELNO, LABELNO);

/* Output assembler code to FILE to increment the entry-count for
   the BLOCKNO'th basic block in this source file.  This is a real pain in the
   sphincter on a VAX, since we do not want to change any of the bits in the
   processor status word.  The way it is done here, it is pushed onto the stack
   before any flags have changed, and then the stack is fixed up to account for
   the fact that the instruction to restore the flags only reads a word.
   It may seem a bit clumsy, but at least it works.
*/

#define BLOCK_PROFILER(FILE, BLOCKNO)	\
  fprintf (FILE, "\tmovpsl -(sp)\n\tmovw (sp),2(sp)\n\taddl2 $2,sp\n\taddl2 $1,LPBX2+%d\n\tbicpsw $255\n\tbispsw (sp)+\n", \
		4 * BLOCKNO)

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

#define EXIT_IGNORE_STACK 0

/* This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.  */

#define FUNCTION_EPILOGUE(FILE, SIZE)  function_epilogue(FILE,SIZE)

/* Output assembler code for a block containing the constant parts
   of a trampoline, leaving space for the variable parts.  */

/* On the vax, the trampoline contains an entry mask and two instructions:
     .word NN
     movl $STATIC,r0   (store the functions static chain)
     jmp  *$FUNCTION   (jump to function code at address FUNCTION)  */

#define TRAMPOLINE_TEMPLATE(FILE) trampoline_template(FILE)

/* Length in units of the trampoline for entering a nested function.  */

#define TRAMPOLINE_SIZE trapoline_size()

/* Emit RTL insns to initialize the variable parts of a trampoline.
   FNADDR is an RTX for the address of the function's pure code.
   CXT is an RTX for the static chain value for the function.  */

/* We copy the register-mask from the function's pure code
   to the start of the trampoline.  */
#define INITIALIZE_TRAMPOLINE(TRAMP, FNADDR, CXT)  \
initialize_trampoline(TRAMP, FNADDR, CXT)

/* Addressing modes, and classification of registers for them.  */

/* ??? HAVE_POST_INCREMENT and HAVE_PRE_DECREMENT are commented out even
   though they exist.  This is because when given -mbig, we need secondary
   reloads for loading addresses into registers.  Reload however has no
   support for allowing auto-increment addresses to have secondary reloads.
   It just aborts when this happens.  The easiest way to fix this was to
   disable use of auto-increment addresses.  */
/* #define HAVE_POST_INCREMENT */
/*#define HAVE_POST_DECREMENT */

/* #define HAVE_PRE_DECREMENT */
/*#define HAVE_PRE_INCREMENT */

/* Macros to check register numbers against specific register classes.  */

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

#define REGNO_OK_FOR_INDEX_P(regno)  0
#define REGNO_OK_FOR_BASE_P(REGNO) 				\
    ((REGNO) < FIRST_PSEUDO_REGISTER ?				\
     (REGNO==ARG_POINTER_REGNUM || PTR_REG_P(REGNO)) 		\
     : ((unsigned)reg_renumber[REGNO] <= STACK_POINTER_REGNUM 	\
	&& PTR_REG_P(reg_renumber[REGNO])))

/* Maximum number of registers that can appear in a valid memory address.  */

#define MAX_REGS_PER_ADDRESS 1

/* 1 if X is an rtx for a constant that is a valid address.  */

#define CONSTANT_ADDRESS_P(X) CONSTANT_P (X)

/* Nonzero if the constant value X is a legitimate general operand.
   It is given that X satisfies CONSTANT_P or is a CONST_DOUBLE.  */

#define LEGITIMATE_CONSTANT_P(X) (GET_CODE (X) != CONST_DOUBLE)

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
   and check its validity for a certain class.
   We have two alternate definitions for each of them.
   The usual definition accepts all pseudo regs; the other rejects
   them unless they have been allocated suitable hard regs.
   The symbol REG_OK_STRICT causes the latter definition to be used.

   Most source files want to accept pseudo regs in the hope that
   they will get allocated to the class that the insn wants them to be in.
   Source files for reload pass need to be strict.
   After reload, it makes no difference, since pseudo regs have
   been eliminated by then.  */

#define EXTRA_CONSTRAINT(OP, C) 	       	\
  ( (C) == 'S' ? OK_FOR_S (OP)  :  (abort(),0) )

#ifndef REG_OK_STRICT

#define OK_FOR_S(OP) \
  ( TARGET_CODE32 ? (CONSTANT_P(OP) || REG_P(OP)) :                	\
   (REG_P(OP) && REGNO(OP) < FIRST_PSEUDO_REGISTER) || DISP_ADDRESS_P(OP) || ABS_ADDRESS_P(OP))

/* Nonzero if X is a hard reg that can be used as an index
   or if it is a pseudo reg.  */
#define REG_OK_FOR_INDEX_P(X) 0

/* Nonzero if X is a hard reg that can be used as a base reg
   or if it is a pseudo reg.  */
#define REG_OK_FOR_BASE_P(X)			\
  (REGNO(X) <= STACK_POINTER_REGNUM 		\
   || REGNO(X) == ARG_POINTER_REGNUM		\
   || REGNO(X) >= FIRST_PSEUDO_REGISTER)

#else

#define OK_FOR_S(OP) \
 ( TARGET_CODE32						\
  ? (CONSTANT_P(OP)						\
     || (REG_P(OP) && (REGNO(OP) < FIRST_PSEUDO_REGISTER	\
		       || (reg_renumber[REGNO (OP)] > 0))))	\
  : ((REG_P(OP) && REGNO_OK_FOR_BASE_P(REGNO(OP)))		\
     || DISP_ADDRESS_P(OP) || ABS_ADDRESS_P(OP)))

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) 0
/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X)  REGNO_OK_FOR_BASE_P (REGNO (X))
#endif

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

   The other macros defined here are used only in GO_IF_LEGITIMATE_ADDRESS,
   except for CONSTANT_ADDRESS_P which is actually
   machine-independent.

   On the H8/500, a legitimate address has the form
   REG,
   REG+CONSTANT_ADDRESS
   CONSTANT_ADDRESS
   --REG
   REG++

   When using segments on data, the valid addressing modes are the
   same, except that CONSTANT address is not allowed.
*/

#define DISP_ADDRESS_P(X) 			\
      (GET_CODE(X) == PLUS			\
       && REG_P(XEXP(X,0)) 			\
       && REG_OK_FOR_BASE_P(XEXP(X,0)) 		\
       && GET_CODE(XEXP(X,1)) == CONST_INT)

#define ABS_ADDRESS_P(X)  CONSTANT_P(X)

#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR)               \
{							      \
  if (!TARGET_DATA32 && CONSTANT_ADDRESS_P(X)) goto ADDR;     \
  if (REG_P(X) && REG_OK_FOR_BASE_P(X)) goto ADDR;	      \
  else if (DISP_ADDRESS_P(X))  goto ADDR;                     \
  else if ((GET_CODE(X) == PRE_DEC|| GET_CODE(X) == POST_INC) \
	   && REG_P(XEXP(X,0))				      \
	   && REG_OK_FOR_BASE_P(XEXP(X,0))) goto ADDR;	      \
}

/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.  It exists to recognize
   opportunities to optimize the output.

   For the H8/500, don't do anything */
#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) ;

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for.

   On the H8/500, the predecrement and postincrement address depend thus
   (the amount of decrement or increment being the length of the operand)
   and all indexed address depend thus (because the index scale factor
   is the length of the operand).  */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)			\
 { if (GET_CODE (ADDR) == POST_INC || GET_CODE (ADDR) == PRE_DEC)	\
     goto LABEL; 	}

/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE HImode

/* Define this if the case instruction expects the table
   to contain offsets from the address of the table.
   Do not define this if the table should contain absolute addresses.  */

/*#define CASE_VECTOR_PC_RELATIVE*/

/* Define this if the case instruction drops through after the table
   when the index is out of range.  Don't define it if the case insn
   jumps to the default label instead.  */
#define CASE_DROPS_THROUGH

/* Specify the tree operation to be used to convert reals to integers.  */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0.

   On the H8/500, sign extension is expensive, so we'll say that chars
   are unsigned.  */
#define DEFAULT_SIGNED_CHAR 0

/* This flag, if defined, says the same insns that convert to a signed fixnum
   also convert validly to an unsigned one.  */
#define FIXUNS_TRUNC_LIKE_FIX_TRUNC

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  */

#define MOVE_MAX 4

/* Define this if zero-extension is slow (more than one real instruction).  */
/* #define SLOW_ZERO_EXTEND */

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS TARGET_SLOWBYTE

/* Define if shifts truncate the shift count
   which implies one can omit a sign-extension or zero-extension
   of a shift count.  */
/* #define SHIFT_COUNT_TRUNCATED */

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

/* Specify the machine mode that pointers have.
   After generation of rtl, the compiler makes no further distinction
   between pointers and any other objects of this machine mode.  */
#define Pmode     ((TARGET_DATA32||TARGET_CODE32) ? PSImode : HImode)
#define PmodeCode (TARGET_CODE32 ? SImode : HImode)
#define PmodeData (TARGET_DATA32 ? PSImode : HImode)
#define Imode HImode

/* Specify the machine mode that integers have.  */
#define INTEGER_MODE HImode

/* A function address in a call instruction
   is a byte address (for indexing purposes)
   so give the MEM rtx a byte's mode.  */
#define FUNCTION_MODE QImode

/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.  Otherwise, break from the switch.  */

#define CONST_COSTS(RTX,CODE,OUTER_CODE) ;

#define BRANCH_COST 1

/* ??? This has absolutely no effect, because it has no case labels.
   This was discovered by paying attention to compiler warnings.  */

/*#define RTX_COSTS(RTX,CODE,OUTER_CODE) \
   { int _x ; default: _x = h8500_rtx_costs(RTX,CODE,OUTER_CODE); if (_x >= 0) return _x; }*/

/* Tell final.c how to eliminate redundant test instructions.  */

/* Here we define machine-dependent flags and fields in cc_status
   (see `conditions.h').  No extra ones are needed for the vax.  */

/* Store in cc_status the expressions
   that the condition codes will describe
   after execution of an instruction whose pattern is EXP.
   Do not alter them if the instruction would not alter the cc's.  */

#define NOTICE_UPDATE_CC(EXP, INSN) notice_update_cc(EXP, INSN)

#define OUTPUT_JUMP(NORMAL, FLOAT, NO_OV)  \
{ if (cc_status.flags & CC_NO_OVERFLOW)				\
    return NO_OV;						\
  return NORMAL; }

/* Control the assembler format that we output.  */

#define ASM_IDENTIFY_GCC	/* nothing */

/* Output at beginning of assembler file.  */
#define ASM_FILE_START(FILE)	asm_file_start(FILE)

#define ASM_FILE_END(FILE)

/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#define ASM_APP_ON "!APP\n"

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#define ASM_APP_OFF "!NO_APP\n"

#define FILE_ASM_OP "\t.file\n"
#define IDENT_ASM_OP "\t.ident\n"

/* Output before read-only data.  */

#define EXTRA_SECTIONS in_rdata, in_ctors, in_dtors, in_user
#define EXTRA_SECTION_FUNCTIONS					\
void							     \
ctors_section() 					     \
{							     \
  if (in_section != in_ctors)				     \
    {							     \
      fprintf (asm_out_file, "%s\n", CTORS_SECTION_ASM_OP);  \
      in_section = in_ctors;				     \
    }							     \
}							     \
void							     \
dtors_section() 					     \
{							     \
  if (in_section != in_dtors)				     \
    {							     \
      fprintf (asm_out_file, "%s\n", DTORS_SECTION_ASM_OP);  \
      in_section = in_dtors;				     \
    }							     \
}								\
void								\
literal_section ()						\
{								\
  if (in_section != in_rdata)					\
    {								\
      fprintf (asm_out_file, "%s\n", READONLY_DATA_SECTION_ASM_OP); \
      in_section = in_rdata;					\
    }								\
}								\

#define ASM_OUTPUT_CONSTRUCTOR(FILE,NAME)	\
   do { ctors_section();  fprintf(FILE,"\t.long\t_%s\n", NAME); } while (0)

#define ASM_OUTPUT_DESTRUCTOR(FILE,NAME)	\
   do {  dtors_section();  fprintf(FILE,"\t.long\t_%s\n", NAME); } while (0)

#undef DO_GLOBAL_CTORS_BODY                     
#define DO_GLOBAL_CTORS_BODY			\
{						\
  typedef (*pfunc)();				\
  extern pfunc __ctors[];			\
  extern pfunc __ctors_end[];			\
  pfunc *p;					\
  for (p = __ctors_end; p > __ctors; )		\
    {						\
      (*--p)();					\
    }						\
}						

#undef DO_GLOBAL_DTORS_BODY			 
#define DO_GLOBAL_DTORS_BODY                    \
{						\
  typedef (*pfunc)();				\
  extern pfunc __dtors[];			\
  extern pfunc __dtors_end[];			\
  pfunc *p;					\
  for (p = __dtors; p < __dtors_end; p++)	\
    {						\
      (*p)();					\
    }						\
}						 

#define CTORS_SECTION_ASM_OP 	"\t.section .ctors"
#define DTORS_SECTION_ASM_OP 	"\t.section .dtors"
#define TEXT_SECTION_ASM_OP 	"\t.section .text"
#define DATA_SECTION_ASM_OP 	"\t.section .data"
#define BSS_SECTION_ASM_OP 	"\t.section .bss" 
#define READONLY_DATA_SECTION_ASM_OP  "\t.section .rdata"
#define READONLY_DATA_SECTION	literal_section

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */
#define REGISTER_NAMES \
{ "r0", "r1", "r2", "r3", "r4", "r5", "fp", "sp", \
  "pc", "ap", "dp", "ep", "tp", "cp" }

#define ADDITIONAL_REGISTER_NAMES \
{ { "r6", 6 }, { "r7", 7 } }

/* How to renumber registers for dbx and gdb.
   If we're outputting a pointer type, then we'll add 14 to the
   register number, so that gdb can tell we want to prepend the right
   segment number */

#define DBX_REGISTER_NUMBER(REGNO) REGNO

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */
#define ASM_OUTPUT_LABEL(FILE,NAME)	\
  do { assemble_name (FILE, NAME); fputs (":\n", FILE); } while (0)

/* This is how to output a command to make the user-level label named NAME
   defined for reference from other files.  */
#define ASM_GLOBALIZE_LABEL(FILE,NAME)	\
  do { fputs ("\t.global ", FILE); assemble_name (FILE, NAME); fputs ("\n", FILE);} while (0)

#define ASM_DECLARE_FUNCTION_NAME(FILE, NAME, DECL) \
 ASM_OUTPUT_LABEL(FILE, NAME)

/* This is how to output a reference to a user-level label named NAME.  */
#define ASM_OUTPUT_LABELREF(FILE,NAME)	asm_output_labelref(FILE, NAME)

/* This is how to output an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.  */
#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM)	\
  fprintf (FILE, ".%s%d:\n", PREFIX, NUM)

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */
#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
  sprintf (LABEL, "*.%s%d", PREFIX, NUM)

/* This is how to output an assembler line defining a `double' constant.
   It is .dfloat or .gfloat, depending.  */

#define ASM_OUTPUT_DOUBLE(FILE,VALUE)		\
  fprintf (FILE, "\t.double %.20e\n", (VALUE))

/* This is how to output an assembler line defining a `float' constant.  */
/* ??? Huh?  */
#define ASM_OUTPUT_FLOAT(FILE,VALUE)		\
  fprintf (FILE, "\t.float %.20e\n", (VALUE)>1e30?1e30:((VALUE)<-1e30)?-1e30:(double)((float)VALUE));

/* This is how to output an assembler line defining an `int' constant.  */
#define ASM_OUTPUT_INT(FILE,VALUE)  \
( fprintf (FILE, "\t.long "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */
#define ASM_OUTPUT_SHORT(FILE,VALUE)  \
( fprintf (FILE, "\t.word "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

#define ASM_OUTPUT_CHAR(FILE,VALUE)  \
( fprintf (FILE, "\t.byte "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */
#define ASM_OUTPUT_BYTE(FILE,VALUE)  \
  fprintf (FILE, "\t.byte 0x%x\n", (VALUE))

/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */
#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)  \
  fprintf (FILE, "\tpush %s\n", reg_names[REGNO])

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */
#define ASM_OUTPUT_REG_POP(FILE,REGNO)  \
  fprintf (FILE, "\tpop\t%s\n", reg_names[REGNO])

/* This is how to output an element of a case-vector that is absolute.
   (The Vax does not use such vectors,
   but we must define this macro anyway.)  */
#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
  asm_fprintf (FILE, "\t.word	.L%d\n", VALUE);

/* This is how to output an element of a case-vector that is relative.  */
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL)  \
  fprintf (FILE, "\t.word .L%d-.L%d\n", VALUE, REL)

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */
#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
  if ((LOG) != 0)			\
    fprintf (FILE, "\t.align %d\n", 1 << (LOG))

/* This is how to output an assembler line
   that says to advance the location counter by SIZE bytes.  */

#define ASM_OUTPUT_IDENT(FILE, NAME) \
  fprintf(FILE, "%s\t \"%s\"\n", IDENT_ASM_OP, NAME)

#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
  fprintf (FILE, "\t.space %d\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)  \
( fputs ("\t.comm ", (FILE)),			\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), ",%d\n", (SIZE)))

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE,ROUNDED)	\
( fputs ("\t.lcomm ", (FILE)),				\
  assemble_name ((FILE), (NAME)),			\
  fprintf ((FILE), ",%d\n", (SIZE)))

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
  sprintf ((OUTPUT), "%s___%d", (NAME), (LABELNO)))

/* Define the parentheses used to group arithmetic operations
   in assembler code.  */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* Define results of standard character escape sequences.  */
#define TARGET_BELL     007
#define TARGET_BS 	010
#define TARGET_TAB 	011
#define TARGET_NEWLINE 	012
#define TARGET_VT 	013
#define TARGET_FF 	014
#define TARGET_CR 	015

#define FINAL_PRESCAN_INSN(INSN, OPVEC, NOPERANDS)  \
do {						\
  if (TARGET_DUMP_RTL)				\
    {						\
      fprintf (asm_out_file, "\n");		\
      print_rtl (asm_out_file, PATTERN(insn));	\
      fprintf (asm_out_file, "\n\n");		\
    }						\
} while (0)

/* Print an instruction operand X on file FILE.  */
#define PRINT_OPERAND(FILE, X, CODE)  \
  print_operand(FILE,X,CODE)

/* Print a memory operand whose address is X, on file FILE. */
#define PRINT_OPERAND_ADDRESS(FILE, ADDR)  \
 print_operand_address (FILE, ADDR)

#define HANDLE_PRAGMA(FILE) handle_pragma(FILE)

/* Define this macro if GNU CC should generate calls to the System V
   (and ANSI C) library functions `memcpy' and `memset' rather than
   the BSD functions `bcopy' and `bzero'.  */
#define TARGET_MEM_FUNCTIONS 1

/* Define this macro if registers of mode should always be in memory,
   eg, on the H8/500, there is no room in the register set for even one DF
   mode value, so whenever gen_reg_rtx is called, a stack slot is made. */

#define INTmode HImode

/* The sort of things returned from libcalls cmp.  */

#define CMPINTmode HImode

#define MOVE_RATIO 3

/* Declare functions defined in h8500.c and used in templates.  */

extern char *movpsi ();
extern char *truncsipsi ();
extern char *emit_a_shift();
extern char *move_two_words();

#define TARGET_H8500 1
#define TARGET_SEGMENTED 

#define NO_FUNCTION_CSE

#define MULHI3_LIBCALL  "__mulhi3"
#define ADDPSI3_LIBCALL "__addpsi3"
#define SUBPSI3_LIBCALL "__subpsi3"
#define MULPSI3_LIBCALL "__mulpsi3"
#define CMPPSI2_LIBCALL "__cmppsi2"

#define INIT_TARGET_OPTABS \
  do { \
    smul_optab->handlers[(int) HImode].libfunc		\
      = gen_rtx (SYMBOL_REF, Pmode, MULHI3_LIBCALL);	\
    add_optab->handlers[(int) PSImode].libfunc		\
      = gen_rtx (SYMBOL_REF, Pmode, ADDPSI3_LIBCALL);	\
    sub_optab->handlers[(int) PSImode].libfunc		\
      = gen_rtx (SYMBOL_REF, Pmode, SUBPSI3_LIBCALL);	\
    smul_optab->handlers[(int) PSImode].libfunc		\
      = gen_rtx (SYMBOL_REF, Pmode, MULPSI3_LIBCALL);	\
    cmp_optab->handlers[(int) PSImode].libfunc		\
      = gen_rtx (SYMBOL_REF, Pmode, CMPPSI2_LIBCALL);	\
  } while (0)

