#include "defs.h"

/*  The banner used here should be replaced with an #ident directive	*/
/*  if the target C compiler supports #ident directives.		*/
/*									*/
/*  If the skeleton is changed, the banner should be changed so that	*/
/*  the altered version can easily be distinguished from the original.	*/

char *banner[] =
{
    "#if defined(__STDC__) || defined(__cplusplus)",
    "#define YYCONST const",
    "#define YYPARAMS(x) x",
    "#define YYDEFUN(name, arglist, args) name(args)",
    "#define YYAND ,",
    "#define YYPTR void *",
    "#else",
    "#define YYCONST",
    "#define YYPARAMS(x) ()",
    "#define YYDEFUN(name, arglist, args) name arglist args;",
    "#define YYAND ;",
    "#define YYPTR char *",
    "#endif",
    "#ifndef lint",
    "YYCONST static char yysccsid[] = \"@(#)yaccpar	1.8 (Berkeley +Cygnus.28) 01/20/91\";",
    "#endif",
    "#define YYBYACC 1",
    /* FIXME: bison always includes stdio.h, this seems unnecessary.  */
    "#ifndef YYDONT_INCLUDE_STDIO",
    "#include <stdio.h>",
    "#endif",
    "#ifdef __cplusplus",
    "#include <stdlib.h> /* for malloc/realloc/free */",
    "#endif",
    0
};


char *tables[] =
{
    /*$"extern short yylhs[];",
    "extern short yylen[];",FIXME$*/
    /*$"extern short yydefred[];",FIXME$*/
    /*$"extern short yydgoto[];",FIXME$*/
    /*$"extern short yysindex[];",
    "extern short yyrindex[];",
    "extern short yygindex[];",FIXME$*/
    /*$"extern short yytable[];", FIXME $*/
    /*$"extern short yycheck[];",FIXME$*/
    "#if YYDEBUG",
    /*$"extern char *yyname[];",FIXME$*/
    /*$"extern char *yyrule[];",FIXME$*/
    "#endif",
    0
};


char *header[] =
{
    "#define YYLEX yylex()",
    "#define YYEMPTY -1",
    "#define yyclearin (yychar=(YYEMPTY))",
    "#define yyerrok (yyerrflag=0)",
    "#ifndef YYINITDEPTH",
    "#define YYINITDEPTH 200",
    "#endif",
    "#ifdef YYSTACKSIZE",
    "#undef YYMAXDEPTH",
    "#define YYMAXDEPTH YYSTACKSIZE",
    "#else",
    "#ifdef YYMAXDEPTH",
    "#define YYSTACKSIZE YYMAXDEPTH",
    "#else",
    "#define YYSTACKSIZE 10000",
    "#define YYMAXDEPTH 10000",
    "#endif",
    "#endif",
    "int yydebug;",
    "int yynerrs;",
    "int yyerrflag;",
    "int yychar;",
    "YYSTYPE yyval;",
    "YYSTYPE yylval;",
    "static short *yyss;",
    "static YYSTYPE *yyvs;",
    "static int yystacksize;",
    "static int yygrow ();",
    "static YYPTR yymalloc YYPARAMS((unsigned));",
    "static YYPTR yyrealloc YYPARAMS((YYPTR, unsigned));",
    "#define yyfree(x) free(x)",
    0
};


char *body[] =
{
    "#define YYABORT goto yyabort",
    "#define YYACCEPT goto yyaccept",
    "#define YYERROR goto yyerrlab",
    "",
    "#if YYDEBUG",
    "#ifdef __cplusplus",
    "extern \"C\" char *getenv();",
    "#else",
    "extern char *getenv();",
    "#endif",
    "#endif",
    "",
    "int",
    "yyparse()",
    "{",
    "    register int yym, yyn, yystate;",
    "    register YYSTYPE *yyvsp;",
    "    register short *yyssp;",
    "    short *yysse;",
    "#if YYDEBUG",
    "    register YYCONST char *yys;",
    "",
    "    if (yys = getenv(\"YYDEBUG\"))",
    "    {",
    "        yyn = *yys;",
    "        if (yyn >= '0' && yyn <= '9')",
    "            yydebug = yyn - '0';",
    "    }",
    "#endif",
    "",
    "    yynerrs = 0;",
    "    yyerrflag = 0;",
    "    yychar = (-1);",
    "",
    "    if (yyss == 0)",
    "    {",
    "        yyss = (short *) yymalloc (YYINITDEPTH * sizeof (short));",
    "        if (yyss == 0)",
    "          goto yyabort;",
    "        yyvs = (YYSTYPE *) yymalloc (YYINITDEPTH * sizeof (YYSTYPE));",
    "        if (yyvs == 0)",
    "        {",
    "            yyfree (yyss);",
    "            goto yyabort;",
    "        }",
    "        yystacksize = YYINITDEPTH;",
    "    }",
    "    yysse = yyss + yystacksize - 1;",
    "    yyssp = yyss;",
    "    yyvsp = yyvs;",
    "    *yyssp = yystate = 0;",
    "",
    "yyloop:",
    "    if (yyn = yydefred[yystate]) goto yyreduce;",
    "    if (yychar < 0)",
    "    {",
    "        if ((yychar = yylex()) < 0) yychar = 0;",
    "#if YYDEBUG",
    "        if (yydebug)",
    "        {",
    "            yys = 0;",
    "            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "            if (!yys) yys = \"illegal-symbol\";",
    "            printf(\"yydebug: state %d, reading %d (%s)\\n\", yystate,",
    "                    yychar, yys);",
    "        }",
    "#endif",
    "    }",
    "    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)",
    "    {",
    "#if YYDEBUG",
    "        if (yydebug)",
    "            printf(\"yydebug: state %d, shifting to state %d\\n\",",
    "                    yystate, yytable[yyn]);",
    "#endif",
    "        if (yyssp >= yysse)",
    "        {",
    "            /* FIXME: Rework so there's only one of these.  */",
    "            int depth = yyssp - yyss;",
    "            if (yygrow () != 0)",
    "              goto yyoverflow;",
    "            yysse = yyss + yystacksize - 1;",
    "            yyssp = yyss + depth;",
    "            yyvsp = yyvs + depth;",
    "        }",
    "        *++yyssp = yystate = yytable[yyn];",
    "        *++yyvsp = yylval;",
    "        yychar = (-1);",
    "        if (yyerrflag > 0)  --yyerrflag;",
    "        goto yyloop;",
    "    }",
    "    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)",
    "    {",
    "        yyn = yytable[yyn];",
    "        goto yyreduce;",
    "    }",
    "    if (yyerrflag) goto yyinrecovery;",
    "#ifdef lint",
    "    goto yynewerror;",
    "#endif",
    "yynewerror:",
    "    yyerror(\"syntax error\");",
    "#ifdef lint",
    "    goto yyerrlab;",
    "#endif",
    "yyerrlab:",
    "    ++yynerrs;",
    "yyinrecovery:",
    "    if (yyerrflag < 3)",
    "    {",
    "        yyerrflag = 3;",
    "        for (;;)",
    "        {",
    "            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&",
    "                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)",
    "            {",
    "#if YYDEBUG",
    "                if (yydebug)",
    "                    printf(\"yydebug: state %d, error recovery shifting\\",
    " to state %d\\n\", *yyssp, yytable[yyn]);",
    "#endif",
    "                if (yyssp >= yysse)",
    "                {",
    "                    int depth = yyssp - yyss;",
    "                    if (yygrow () != 0)",
    "                      goto yyoverflow;",
    "                    yysse = yyss + yystacksize - 1;",
    "                    yyssp = yyss + depth;",
    "                    yyvsp = yyvs + depth;",
    "                }",
    "                *++yyssp = yystate = yytable[yyn];",
    "                *++yyvsp = yylval;",
    "                goto yyloop;",
    "            }",
    "            else",
    "            {",
    "#if YYDEBUG",
    "                if (yydebug)",
    "                    printf(\"yydebug: error recovery discarding state %d\
\\n\",",
    "                            *yyssp);",
    "#endif",
    "                if (yyssp <= yyss) goto yyabort;",
    "                --yyssp;",
    "                --yyvsp;",
    "            }",
    "        }",
    "    }",
    "    else",
    "    {",
    "        if (yychar == 0) goto yyabort;",
    "#if YYDEBUG",
    "        if (yydebug)",
    "        {",
    "            yys = 0;",
    "            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "            if (!yys) yys = \"illegal-symbol\";",
    "            printf(\"yydebug: state %d, error recovery discards token %d\
 (%s)\\n\",",
    "                    yystate, yychar, yys);",
    "        }",
    "#endif",
    "        yychar = (-1);",
    "        goto yyloop;",
    "    }",
    "yyreduce:",
    "#if YYDEBUG",
    "    if (yydebug)",
    "        printf(\"yydebug: state %d, reducing by rule %d (%s)\\n\",",
    "                yystate, yyn, yyrule[yyn]);",
    "#endif",
    "    yym = yylen[yyn];",
    "    yyval = yyvsp[1-yym];",
    "    switch (yyn)",
    "    {",
    0
};


char *trailer[] =
{
    "    }",
    "    yyssp -= yym;",
    "    yystate = *yyssp;",
    "    yyvsp -= yym;",
    "    yym = yylhs[yyn];",
    "    if (yystate == 0 && yym == 0)",
    "    {",
    "#if YYDEBUG",
    "        if (yydebug)",
    "            printf(\"yydebug: after reduction, shifting from state 0 to\\",
    " state %d\\n\", YYFINAL);",
    "#endif",
    "        yystate = YYFINAL;",
    "        *++yyssp = YYFINAL;",
    "        *++yyvsp = yyval;",
    "        if (yychar < 0)",
    "        {",
    "            if ((yychar = yylex()) < 0) yychar = 0;",
    "#if YYDEBUG",
    "            if (yydebug)",
    "            {",
    "                yys = 0;",
    "                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "                if (!yys) yys = \"illegal-symbol\";",
    "                printf(\"yydebug: state %d, reading %d (%s)\\n\",",
    "                        YYFINAL, yychar, yys);",
    "            }",
    "#endif",
    "        }",
    "        if (yychar == 0) goto yyaccept;",
    "        goto yyloop;",
    "    }",
    "    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)",
    "        yystate = yytable[yyn];",
    "    else",
    "        yystate = yydgoto[yym];",
    "#if YYDEBUG",
    "    if (yydebug)",
    "        printf(\"yydebug: after reduction, shifting from state %d \\",
    "to state %d\\n\", *yyssp, yystate);",
    "#endif",
    "    if (yyssp >= yysse)",
    "    {",
    "        int depth = yyssp - yyss;",
    "        if (yygrow () != 0)",
    "          goto yyoverflow;",
    "        yysse = yyss + yystacksize - 1;",
    "        yyssp = yyss + depth;",
    "        yyvsp = yyvs + depth;",
    "    }",
    "    *++yyssp = yystate;",
    "    *++yyvsp = yyval;",
    "    goto yyloop;",
    "yyoverflow:",
    "    yyerror(\"yacc stack overflow\");",
    "yyabort:",
    "    return (1);",
    "yyaccept:",
    "    return (0);",
    "}",
    "",
    "static int",
    "yygrow ()",
    "{",
    "    int old_stacksize = yystacksize;",
    "    short *new_yyss;",
    "    YYSTYPE *new_yyvs;",
    "",
    "    if (yystacksize >= YYMAXDEPTH)",
    "        return (1);",
    "    yystacksize *= 2;",
    "    if (yystacksize > YYMAXDEPTH)",
    "        yystacksize = YYMAXDEPTH;",
    "#if YYDEBUG",
    "    if (yydebug)",
    "        printf(\"yydebug: growing stack size from %d to %d\\n\",",
    "               old_stacksize, yystacksize);",
    "#endif",
    "    new_yyss = (short *) yyrealloc (yyss, yystacksize * sizeof (short));",
    "    if (new_yyss == 0)",
    "        return (1);",
    "    new_yyvs = (YYSTYPE *) yyrealloc (yyvs, yystacksize * sizeof (YYSTYPE));",
    "    if (new_yyvs == 0)",
    "    {",
    "        yyfree (new_yyss);",
    "        return (1);",
    "    }",
    "    yyss = new_yyss;",
    "    yyvs = new_yyvs;",
    "    return (0);",
    "}",
    "",
    "static YYPTR",
    "YYDEFUN (yymalloc, (bytes), unsigned bytes)",
    "{",
    "    YYPTR ptr = (YYPTR) malloc (bytes);",
    "    if (ptr != 0) return (ptr);",
    "    yyerror (\"yyparse: memory exhausted\");",
    "    return (0);",
    "}",
    "",
    "static YYPTR",
    "YYDEFUN (yyrealloc, (old, bytes), YYPTR old YYAND unsigned bytes)",
    "{",
    "    YYPTR ptr = (YYPTR) realloc (old, bytes);",
    "    if (ptr != 0) return (ptr);",
    "    yyerror (\"yyparse: memory exhausted\");",
    "    return (0);",
    "}",
    0
};


write_section(section)
char *section[];
{
    register int i;
    register FILE *fp;

    fp = code_file;
    for (i = 0; section[i]; ++i)
    {
	++outline;
	fprintf(fp, "%s\n", section[i]);
    }
}
