%{
/* deflex.l - Lexer for .def files */

/*   Copyright (C) 1995 Free Software Foundation, Inc.

This file is part of GNU Binutils.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/* Contributed by Steve Chamberlain
   		  sac@cygnus.com

*/
#define DONTDECLARE_MALLOC
#include "defparse.h"
extern char *strdup();
int linenumber;

%}
%%
"NAME" 		 { return NAME;}
"LIBRARY"	 { return LIBRARY;}
"DESCRIPTION" 	 { return DESCRIPTION;}
"STACKSIZE"	 { return STACKSIZE;}
"HEAPSIZE" 	 { return HEAPSIZE;}
"CODE" 		 { return CODE;}
"DATA"		 { return DATA;}
"SECTIONS"	 { return SECTIONS;}
"EXPORTS"	 { return EXPORTS;}
"IMPORTS"	 { return IMPORTS;}
"VERSION"	 { return VERSION;}
"BASE"		 { return BASE;}
"CONSTANT"	{ return CONSTANT; }
"NONAME"	{ return NONAME; }

"READ"	{ return READ;}
"WRITE"	{ return WRITE;}
"EXECUTE"	{ return EXECUTE;}
"SHARED"	{ return SHARED;}

[0-9][x0-9A-Fa-f]* { yylval.number = strtol (yytext,0,0); 
		return NUMBER; }

[A-Za-z$:\-\_][A-Za-z0-9/$:\-\_@]+ { 	
		yylval.id =  strdup(yytext);
		return ID;
		}
"\""[^\"]*"\"" {
					yylval.string = strdup (yytext+1);
					yylval.string[yyleng-2] = 0;
					return STRING;
		}

"\'"[^\']*"\'" {
					yylval.string = strdup (yytext+1);
					yylval.string[yyleng-2] = 0;
					return STRING;
		}
"*".* 		{ }
";".* 		{ }
" "		{ }
"\t"		{ }
"\n"	 	 { linenumber ++ ;}
"=" { return '=';}
"." { return '.';}
"@" { return '@';}
"," { return ',';}
%%
#ifndef yywrap
/* Needed for lex, though not flex. */
int yywrap() { return 1; }
#endif
