'\"
'\" Copyright (c) 1991 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /afs/cs.cmu.edu/user/cgd/cvsroot/alphasrc/cygnus/tk/doc/wm.n,v 1.1.1.1 1995/08/19 03:11:11 cgd Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS wm tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
wm \- Communicate with window manager
.SH SYNOPSIS
\fBwm\fR \fIoption window \fR?\fIargs\fR?
.BE

.SH DESCRIPTION
.PP
The \fBwm\fR command is used to interact with window managers in
order to control such things as the title for a window, its geometry,
or the increments in terms of which it may be resized.  The \fBwm\fR
command can take any of a number of different forms, depending on
the \fIoption\fR argument.  All of the forms expect at least one
additional argument, \fIwindow\fR, which must be the path name of a
top-level window.
.PP
The legal forms for the \fBwm\fR command are:
.TP
\fBwm aspect \fIwindow\fR ?\fIminNumer minDenom maxNumer maxDenom\fR?
If \fIminNumer\fR, \fIminDenom\fR, \fImaxNumer\fR, and \fImaxDenom\fR
are all specified, then they will be passed to the window manager
and the window manager should use them to enforce a range of
acceptable aspect ratios for \fIwindow\fR.  The aspect ratio of
\fIwindow\fR (width/length) will be constrained to lie
between \fIminNumer\fR/\fIminDenom\fR and \fImaxNumer\fR/\fImaxDenom\fR.
If \fIminNumer\fR etc. are all specified as empty strings, then
any existing aspect ratio restrictions are removed.
If \fIminNumer\fR etc. are specified, then the command returns an
empty string.  Otherwise, it returns
a Tcl list containing four elements, which are the current values
of \fIminNumer\fR, \fIminDenom\fR, \fImaxNumer\fR, and \fImaxDenom\fR
(if no aspect restrictions are in effect, then an empty string is
returned).
.TP
\fBwm client \fIwindow\fR ?\fIname\fR?
.VS
If \fIname\fR is specified, this command stores \fIname\fR (which
should be the name of
the host on which the application is executing) in \fIwindow\fR's
\fBWM_CLIENT_MACHINE\fR property for use by the window manager or
session manager.
The command returns an empty string in this case.
If \fIname\fR isn't specified, the command returns the last name
set in a \fBwm client\fR command for \fIwindow\fR.
If \fIname\fR is specified as an empty string, the command deletes the
\fBWM_CLIENT_MACHINE\fR property from \fIwindow\fR.
.TP
\fBwm command \fIwindow\fR ?\fIvalue\fR?
If \fIvalue\fR is specified, this command stores \fIvalue\fR in \fIwindow\fR's
\fBWM_COMMAND\fR property for use by the window manager or
session manager and returns an empty string.
\fIValue\fR must have proper list structure;  the elements should
contain the words of the command used to invoke the application.
If \fIvalue\fR isn't specified then the command returns the last value
set in a \fBwm command\fR command for \fIwindow\fR.
If \fIvalue\fR is specified as an empty string, the command
deletes the \fBWM_COMMAND\fR property from \fIwindow\fR.
.VE
.TP
\fBwm deiconify \fIwindow\fR
Arrange for \fIwindow\fR to be displayed in normal (non-iconified) form.
This is done by mapping the window.  If the window has never been
mapped then this command will not map the window, but it will ensure
that when the window is first mapped it will be displayed
in de-iconified form.  Returns an empty string.
.TP
\fBwm focusmodel \fIwindow\fR ?\fBactive\fR|\fBpassive\fR?
If \fBactive\fR or \fBpassive\fR is supplied as an optional argument
to the command, then it specifies the focus model for \fIwindow\fR.
In this case the command returns an empty string.  If no additional
argument is supplied, then the command returns the current focus
model for \fIwindow\fR.
An \fBactive\fR focus model means that \fIwindow\fR will claim the
input focus for itself or its descendants, even at times when
the focus is currently in some other application.  \fBPassive\fR means that
\fIwindow\fR will never claim the focus for itself:  the window manager
should give the focus to \fIwindow\fR at appropriate times.  However,
once the focus has been given to \fIwindow\fR or one of its descendants,
the application may re-assign the focus among \fIwindow\fR's descendants.
The focus model defaults to \fBpassive\fR, and Tk's \fBfocus\fR command
assumes a passive model of focussing.
.TP
\fBwm frame \fIwindow\fR
.VS
If \fIwindow\fR has been reparented by the window manager into a
decorative frame, the command returns the X window identifier for
the outermost frame that contains \fIwindow\fR (the window whose
parent is the root or virtual root).  If \fIwindow\fR hasn't been
reparented by the window manager then the command returns the
X window identifier for \fIwindow\fR.
.VE
.TP
\fBwm geometry \fIwindow\fR ?\fInewGeometry\fR?
If \fInewGeometry\fR is specified, then the geometry of \fIwindow\fR
is changed and an empty string is returned.  Otherwise the current
geometry for \fIwindow\fR is returned (this is the most recent
geometry specified either by manual resizing or
in a \fBwm geometry\fR command).  \fINewGeometry\fR has
the form \fB=\fIwidth\fBx\fIheight\fB\(+-\fIx\fB\(+-\fIy\fR, where
any of \fB=\fR, \fIwidth\fBx\fIheight\fR, or \fB\(+-\fIx\fB\(+-\fIy\fR
may be omitted.  \fIWidth\fR and \fIheight\fR are positive integers
specifying the desired dimensions of \fIwindow\fR.  If \fIwindow\fR
is gridded (see GRIDDED GEOMETRY MANAGEMENT below) then the dimensions
are specified in grid units;  otherwise they are specified in pixel
units.  \fIX\fR and \fIy\fR specify the desired location of
\fIwindow\fR on the screen, in pixels.
If \fIx\fR is preceded by \fB+\fR, it specifies
the number of pixels between the left edge of the screen and the left
edge of \fIwindow\fR's border;  if preceded by \fB\-\fR then
\fIx\fR specifies the number of pixels
between the right edge of the screen and the right edge of \fIwindow\fR's
border.  If \fIy\fR is preceded by \fB+\fR then it specifies the
number of pixels between the top of the screen and the top
of \fIwindow\fR's border;  if \fIy\fR is preceded by \fB\-\fR then
it specifies the number of pixels between the bottom of \fIwindow\fR's
border and the bottom of the screen.
If \fInewGeometry\fR is specified as an empty string then any
existing user-specified geometry for \fIwindow\fR is cancelled, and
the window will revert to the size requested internally by its
widgets.
.TP
\fBwm grid \fIwindow\fR ?\fIbaseWidth baseHeight widthInc heightInc\fR?
This command indicates that \fIwindow\fR is to be managed as a
gridded window.
It also specifies the relationship between grid units and pixel units.
\fIBaseWidth\fR and \fIbaseHeight\fR specify the number of grid
units corresponding to the pixel dimensions requested internally
by \fIwindow\fR using \fBTk_GeometryRequest\fR.  \fIWidthInc\fR
and \fIheightInc\fR specify the number of pixels in each horizontal
and vertical grid unit.
These four values determine a range of acceptable sizes for
\fIwindow\fR, corresponding to grid-based widths and heights
that are non-negative integers.
Tk will pass this information to the window manager;  during
manual resizing, the window manager will restrict the window's size
to one of these acceptable sizes.
Furthermore, during manual resizing the window manager will display
the window's current size in terms of grid units rather than pixels.
If \fIbaseWidth\fR etc. are all specified as empty strings, then
\fIwindow\fR will no longer be managed as a gridded window.  If
\fIbaseWidth\fR etc. are specified then the return value is an
empty string.
Otherwise the return value is a Tcl list containing
four elements corresponding to the current \fIbaseWidth\fR,
\fIbaseHeight\fR, \fIwidthInc\fR, and \fIheightInc\fR;  if
\fIwindow\fR is not currently gridded, then an empty string
is returned.
Note: this command should not be needed very often, since the
\fBTk_SetGrid\fR library procedure and the \fBsetGrid\fR option
provide easier access to the same functionality.
.TP
\fBwm group \fIwindow\fR ?\fIpathName\fR?
If \fIpathName\fR is specified, it gives the path name for the leader of
a group of related windows.  The window manager may use this information,
for example, to unmap all of the windows in a group when the group's
leader is iconified.  \fIPathName\fR may be specified as an empty string to
remove \fIwindow\fR from any group association.  If \fIpathName\fR is
specified then the command returns an empty string;  otherwise it
returns the path name of \fIwindow\fR's current group leader, or an empty
string if \fIwindow\fR isn't part of any group.
.TP
\fBwm iconbitmap \fIwindow\fR ?\fIbitmap\fR?
If \fIbitmap\fR is specified, then it names a bitmap in the standard
forms accepted by Tk (see the \fBTk_GetBitmap\fR manual entry for details).
This bitmap is passed to the window manager to be displayed in
\fIwindow\fR's icon, and the command returns an empty string.  If
an empty string is specified for \fIbitmap\fR, then any current icon
bitmap is cancelled for \fIwindow\fR.
If \fIbitmap\fR is specified then the command returns an empty string.
Otherwise it returns the name of
the current icon bitmap associated with \fIwindow\fR, or an empty
string if \fIwindow\fR has no icon bitmap.
.TP
\fBwm iconify \fIwindow\fR
Arrange for \fIwindow\fR to be iconified.  It \fIwindow\fR hasn't
yet been mapped for the first time, this command will arrange for
it to appear in the iconified state when it is eventually mapped.
.TP
\fBwm iconmask \fIwindow\fR ?\fIbitmap\fR?
If \fIbitmap\fR is specified, then it names a bitmap in the standard
forms accepted by Tk (see the \fBTk_GetBitmap\fR manual entry for details).
This bitmap is passed to the window manager to be used as a mask
in conjunction with the \fBiconbitmap\fR option:  where the mask
has zeroes no icon will be displayed;  where it has ones, the bits
from the icon bitmap will be displayed.  If
an empty string is specified for \fIbitmap\fR then any current icon
mask is cancelled for \fIwindow\fR (this is equivalent to specifying
a bitmap of all ones).  If \fIbitmap\fR is specified
then the command returns an empty string.  Otherwise it
returns the name of the current icon mask associated with
\fIwindow\fR, or an empty string if no mask is in effect.
.TP
\fBwm iconname \fIwindow\fR ?\fInewName\fR?
If \fInewName\fR is specified, then it is passed to the window
manager;  the window manager should display \fInewName\fR inside
the icon associated with \fIwindow\fR.  In this case an empty
string is returned as result.  If \fInewName\fR isn't specified
then the command returns the current icon name for \fIwindow\fR,
or an empty string if no icon name has been specified (in this
case the window manager will normally display the window's title,
as specified with the \fBwm title\fR command).
.TP
\fBwm iconposition \fIwindow\fR ?\fIx y\fR?
If \fIx\fR and \fIy\fR are specified, they are passed to the window
manager as a hint about where to position the icon for \fIwindow\fR.
In this case an empty string is returned.  If \fIx\fR and \fIy\fR are
specified as empty strings then any existing icon position hint is cancelled.
If neither \fIx\fR nor \fIy\fR is specified, then the command returns
a Tcl list containing two values, which are the current icon position
hints (if no hints are in effect then an empty string is returned).
.TP
\fBwm iconwindow \fIwindow\fR ?\fIpathName\fR?
If \fIpathName\fR is specified, it is the path name for a window to
use as icon for \fIwindow\fR: when \fIwindow\fR is iconified then
\fIpathName\fR should be mapped to serve as icon, and when \fIwindow\fR
is de-iconified then \fIpathName\fR will be unmapped again.  If
\fIpathName\fR is specified as an empty string then any existing
icon window association for \fIwindow\fR will be cancelled.  If
the \fIpathName\fR argument is specified then an empty string is
returned.  Otherwise the command returns the path name of the
current icon window for \fIwindow\fR, or an empty string if there
is no icon window currently specified for \fIwindow\fR.  Note:
not all window managers support the notion of an icon window.
.TP
\fBwm maxsize \fIwindow\fR ?\fIwidth height\fR?
If \fIwidth\fR and \fIheight\fR are specified, then \fIwindow\fR
becomes resizable and \fIwidth\fR and \fIheight\fR give its
maximum permissible dimensions.
For gridded windows the dimensions are specified in
grid units;  otherwise they are specified in pixel units.
During manual sizing, the window manager
should restrict the window's dimensions to be less than or
equal to \fIwidth\fR and \fIheight\fR.
If \fIwidth\fR and \fIheight\fR are specified as empty strings,
then the maximum size option is cancelled for \fIwindow\fR.
If \fIwidth\fR and \fIheight\fR are
specified, then the command returns an empty string.  Otherwise
it returns a Tcl list with two elements, which are the
maximum width and height currently in effect;  if no maximum
dimensions are in effect for \fIwindow\fR then an empty
string is returned.  See the sections on geometry management
below for more information.
.TP
\fBwm minsize \fIwindow\fR ?\fIwidth height\fR?
If \fIwidth\fR and \fIheight\fR are specified, then \fIwindow\fR
becomes resizable and \fIwidth\fR and \fIheight\fR give its
minimum permissible dimensions.
For gridded windows the dimensions are specified in
grid units;  otherwise they are specified in pixel units.
During manual sizing, the window manager
should restrict the window's dimensions to be greater than or
equal to \fIwidth\fR and \fIheight\fR.
If \fIwidth\fR and \fIheight\fR are specified as empty strings,
then the minimum size option is cancelled for \fIwindow\fR.
If \fIwidth\fR and \fIheight\fR are
specified, then the command returns an empty string.  Otherwise
it returns a Tcl list with two elements, which are the
minimum width and height currently in effect;  if no minimum
dimensions are in effect for \fIwindow\fR then an empty
string is returned.  See the sections on geometry management
below for more information.
.TP
\fBwm overrideredirect \fIwindow\fR ?\fIboolean\fR?
.VS
If \fIboolean\fR is specified, it must have a proper boolean form and
the override-redirect flag for \fIwindow\fR is set to that value.
If \fIboolean\fR is not specified then \fB1\fR or \fB0\fR is
returned to indicate whether or not the override-redirect flag
is currently set for \fIwindow\fR.
Setting the override-redirect flag for a window causes
it to be ignored by the window manager;  among other things, this means
that the window will not be reparented from the root window into a
decorative frame and the user will not be able to manipulate the
window using the normal window manager mechanisms.
.VE
.TP
\fBwm positionfrom \fIwindow\fR ?\fIwho\fR?
If \fIwho\fR is specified, it must be either \fBprogram\fR or
\fBuser\fR, or an abbreviation of one of these two.  It indicates
whether \fIwindow\fR's current position was requested by the
program or by the user.  Many window managers ignore program-requested
initial positions and ask the user to manually position the window;  if
\fBuser\fR is specified then the window manager should position the
window at the given place without asking the user for assistance.
If \fIwho\fR is specified as an empty string, then the current position
source is cancelled.
If \fIwho\fR is specified, then the command returns an empty string.
Otherwise it returns \fBuser\fR or \fBwindow\fR to indicate the
source of the window's current position, or an empty string if
no source has been specified yet.  Most window managers interpret
``no source'' as equivalent to \fBprogram\fR.
.VS
Tk will automatically set the position source to \fBuser\fR
when a \fBwm geometry\fR command is invoked, unless the source has
been set explicitly to \fBprogram\fR.
.TP
\fBwm protocol \fIwindow\fR ?\fIname\fR? ?\fIcommand\fR?
This command is used to manage window manager protocols such as
\fBWM_DELETE_WINDOW\fR.
\fIName\fR is the name of an atom corresponding to a window manager
protocol, such as \fBWM_DELETE_WINDOW\fR or \fBWM_SAVE_YOURSELF\fR
or \fBWM_TAKE_FOCUS\fR.
If both \fIname\fR and \fIcommand\fR are specified, then \fIcommand\fR
is associated with the protocol specified by \fIname\fR.
\fIName\fR will be added to \fIwindow\fR's \fBWM_PROTOCOLS\fR
property to tell the window manager that the application has a
protocol handler for \fIname\fR, and \fIcommand\fR will
be invoked in the future whenever the window manager sends a
message to the client for that protocol.
In this case the command returns an empty string.
If \fIname\fR is specified but \fIcommand\fR isn't, then the current
command for \fIname\fR is returned, or an empty string if there
is no handler defined for \fIname\fR.
If \fIcommand\fR is specified as an empty string then the current
handler for \fIname\fR is deleted and it is removed from the
\fBWM_PROTOCOLS\fR property on \fIwindow\fR;  an empty string is
returned.
Lastly, if neither \fIname\fR nor \fIcommand\fR is specified, the
command returns a list of all the protocols for which handlers
are currently defined for \fIwindow\fR.
.RS
.LP
Tk always defines a protocol handler for \fBWM_DELETE_WINDOW\fR, even if
you haven't asked for one with \fBwm protocol\fR.
If a \fBWM_DELETE_WINDOW\fR message arrives when you haven't defined
a handler, then Tk handles the message by destroying the window for
which it was received.
.RE
.VE
.TP
\fBwm sizefrom \fIwindow\fR ?\fIwho\fR?
If \fIwho\fR is specified, it must be either \fBprogram\fR or
\fBuser\fR, or an abbreviation of one of these two.  It indicates
whether \fIwindow\fR's current size was requested by the
program or by the user.  Some window managers ignore program-requested
sizes and ask the user to manually size the window;  if
\fBuser\fR is specified then the window manager should give the
window its specified size without asking the user for assistance.
If \fIwho\fR is specified as an empty string, then the current size
source is cancelled.
If \fIwho\fR is specified, then the command returns an empty string.
Otherwise it returns \fBuser\fR or \fBwindow\fR to indicate the
source of the window's current size, or an empty string if
no source has been specified yet.  Most window managers interpret
``no source'' as equivalent to \fBprogram\fR.
.TP
\fBwm state \fIwindow\fR
.VS
Returns the current state of \fIwindow\fR:  either \fBnormal\fR,
\fBiconic\fR, or \fBwithdrawn\fR.
.VE
.TP
\fBwm title \fIwindow\fR ?\fIstring\fR?
If \fIstring\fR is specified, then it will be passed to the window
manager for use as the title for \fIwindow\fR (the window manager
should display this string in \fIwindow\fR's title bar).  In this
case the command returns an empty string.  If \fIstring\fR isn't
specified then the command returns the current title for the
\fIwindow\fR.  The title for a window defaults to its name.
.TP
\fBwm transient \fIwindow\fR ?\fImaster\fR?
If \fImaster\fR is specified, then the window manager is informed
that \fIwindow\fR is a transient window (e.g. pull-down menu) working
on behalf of \fImaster\fR (where \fImaster\fR is the
path name for a top-level window).  Some window managers will use
this information to manage \fIwindow\fR specially.  If \fImaster\fR
is specified as an empty string then \fIwindow\fR is marked as not
being a transient window any more.  If \fImaster\fR is specified,
then the command returns an empty string.  Otherwise the command
returns the path name of \fIwindow\fR's current master, or an
empty string if \fIwindow\fR isn't currently a transient window.
.TP
\fBwm withdraw \fIwindow\fR
Arranges for \fIwindow\fR to be withdrawn from the screen.  This
causes the window to be unmapped and forgotten about by the window
manager.  If the window
.VS
has never been mapped, then this command
causes the window to be mapped in the withdrawn state.  Not all
window managers appear to know how to handle windows that are
mapped in the withdrawn state.
.VE
Note: it sometimes seems to be necessary to withdraw a
window and then re-map it (e.g. with \fBwm deiconify\fR) to get some
window managers to pay attention to changes in window attributes
such as group.

.SH "SOURCES OF GEOMETRY INFORMATION"
.PP
Size-related information for top-level windows
can come from three sources.
First, geometry requests come from the widgets that are descendants
of a top-level window.
Each widget requests a particular size for itself
by calling \fBTk_GeometryRequest\fR.  This information is passed to
geometry managers, which then request large enough sizes for parent
windows so that they can layout the children properly.
Geometry information passes upwards through the window hierarchy
until eventually a particular size is requested for each top-level
window.
These requests are called \fIinternal requests\fR in the discussion
below.
The second source of width and height information is through the
\fBwm geometry\fR command.  Third, the user can
request a particular size for a window using the
interactive facilities of the window manager.
The second and third types of geometry requests are called
\fIexternal requests\fR in the discussion below;  Tk treats
these two kinds of requests identically.

.SH "UNGRIDDED GEOMETRY MANAGEMENT"
.PP
Tk allows the geometry of a top-level window to be managed in
either of two general ways: ungridded or gridded.
The ungridded form occurs if no \fBwm grid\fR command
has been issued for a top-level window.
Ungridded management has several variants.
In the simplest variant of ungridded windows,
no \fBwm geometry\fR, \fBwm minsize\fR, or \fBwm maxsize\fR
commands have been invoked either.
In this case, the window's size is
determined totally by the internal requests emanating from the
widgets inside the window:  Tk will ask the window manager not to
permit the user to resize the window interactively.
.PP
If a \fBwm geometry\fR command is invoked on an ungridded window,
then the size in that command overrides any size requested by the
window's widgets;  from now on, the window's size will be determined
entirely by the most recent information from \fBwm geometry\fR
commands.  To go back to using the size requested by the window's
widgets, issue a \fBwm geometry\fR command with an empty \fIgeometry\fR
string.
.PP
To enable interactive resizing of an ungridded window, one or both
of the \fBwm maxsize\fR
and \fBwm minsize\fR commands must be issued.
The information from these commands will be passed to the window
manager, and size changes within the specified range will be permitted.
For ungridded windows the limits refer to the top-level window's
dimensions in pixels.
If only a \fBwm maxsize\fR command is issued then the minimum
dimensions default to 1;  if only a \fBwm minsize\fR command is
.VS
issued then the maximum dimensions default to the size of the display.
.VE
If the size of a window is changed interactively, it has the same
effect as if \fBwm geometry\fR had been invoked:  from now on, internal
geometry requests will be ignored.
To return to internal control over the window's size, issue a
\fBwm geometry\fR command with an empty \fIgeometry\fR argument.
If a window has been manually resized or moved, the \fBwm geometry\fR
command will return the geometry that was requested interactively.

.SH "GRIDDED GEOMETRY MANAGEMENT"
.PP
The second style of geometry management is called \fIgridded\fR.
This approach occurs when one of the widgets of an application
supports a range of useful sizes.
This occurs, for example, in a text editor where the scrollbars,
menus, and other adornments are fixed in size but the edit widget
can support any number of lines of text or characters per line.
In this case, it is usually desirable to let the user specify the
number of lines or characters-per-line, either with the
\fBwm geometry\fR command or by interactively resizing the window.
In the case of text, and in other interesting cases also, only
discrete sizes of the window make sense, such as integral numbers
of lines and characters-per-line;  arbitrary pixel sizes are not useful.
.PP
Gridded geometry management provides support for this kind of
application.
Tk (and the window manager) assume that there is a grid of some
sort within the application and that the application should be
resized in terms of \fIgrid units\fR rather than pixels.
Gridded geometry management is typically invoked by turning on
the \fBsetGrid\fR option for a widget;  it can also be invoked
with the \fBwm grid\fR command or by calling \fBTk_SetGrid\fR.
In each of these approaches the particular widget (or sometimes
code in the application as a whole) specifies the relationship between 
integral grid sizes for the window and pixel sizes.
To return to non-gridded geometry management, invoke
\fBwm grid\fR with empty argument strings.
.PP
When gridded geometry management is enabled then all the dimensions specified
in \fBwm minsize\fR, \fBwm maxsize\fR, and \fBwm geometry\fR commands
are treated as grid units rather than pixel units.
Interactive resizing is automatically enabled, and it will be
carried out in even numbers of grid units rather than pixels.
By default there are no limits on the minimum or maximum dimensions
of a gridded window.
As with ungridded windows, interactive resizing has exactly the
same effect as invoking the \fBwm geometry\fR command.
For gridded windows, internally- and externally-requested dimensions
work together: the externally-specified width and height determine
the size of the window in grid units, and the information from the
last \fBwm grid\fR command maps from grid units to pixel units.

.SH BUGS
.PP
The window manager interactions seem too complicated, especially
for managing geometry.  Suggestions on how to simplify this would
be greatly appreciated.
.PP
Most existing window managers appear to have bugs that affect the
operation of the \fBwm\fR command.  For example, some changes won't
take effect if the window is already active:  the window will have
to be withdrawn and de-iconified in order to make the change happen.

.SH KEYWORDS
aspect ratio, deiconify, focus model, geometry, grid, group, icon, iconify, increments, position, size, title, top-level window, units, window manager
