'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /afs/cs.cmu.edu/user/cgd/cvsroot/alphasrc/cygnus/tk/doc/scrollbar.n,v 1.1.1.1 1995/08/19 03:11:07 cgd Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS scrollbar tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scrollbar \- Create and manipulate scrollbar widgets
.SH SYNOPSIS
\fBscrollbar\fI pathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveForeground\fR	\fBcursor\fR	\fBrelief\fR
.VE
\fBbackground\fR	\fBforeground\fR	\fBrepeatDelay\fR
\fBborderWidth\fR	\fBorient\fR	\fBrepeatInterval\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke to change the view
in the widget associated with the scrollbar.  When a user requests
a view change by manipulating the scrollbar, a Tcl command is
invoked.  The actual command consists of this option followed by
a space and a number.  The number indicates the logical unit that
should appear at the top of the associated window.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired narrow dimension of the scrollbar window,
not including 3-D border, if any.  For vertical
scrollbars this will be the width and for horizontal scrollbars
this will be the height.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBscrollbar\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a scrollbar widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the scrollbar such as its colors, orientation,
and relief.  The \fBscrollbar\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A scrollbar is a widget that displays two arrows, one at each end of
the scrollbar, and a \fIslider\fR in the middle portion of the
scrollbar.  A scrollbar is used to provide information about what
is visible in an \fIassociated window\fR that displays an object
of some sort (such as a file being edited or a drawing).
The position and size of the slider indicate which portion of the
object is visible in the associated window.  For example, if the
slider in a vertical scrollbar covers the top third of the area
between the two arrows, it means that the associated window displays
the top third of its object.
.PP
Scrollbars can be used to adjust the view in the associated window
by clicking or dragging with the mouse.  See the BINDINGS section
below for details.

.SH "WIDGET COMMAND"
.PP
The \fBscrollbar\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrollbar widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscrollbar\fR
command.
.TP
\fIpathName \fBget\fR
Returns a Tcl list containing four decimal values, which are
the current \fItotalUnits\fR, \fIwidnowUnits\fR, \fIfirstUnit\fR,
and \fIlastUnit\fR values for the scrollbar.  These are the values
from the most recent \fBset\fR widget command on the scrollbar.
.TP
\fIpathName \fBset\fR \fItotalUnits windowUnits firstUnit lastUnit\fR
This command is invoked to give the scrollbar information about the
widget associated with the scrollbar.  \fITotalUnits\fR is an integer
value giving the total size of the object being displayed in the
associated widget.  The meaning of one unit depends on the associated
widget;  for example, in a text editor widget units might
correspond to lines of
text.  \fIWindowUnits\fR indicates the total number of units that
can fit in the associated window at one time.  \fIFirstUnit\fR
and \fIlastUnit\fR give the indices of the first and last units
currently visible in the associated window (zero corresponds to the
first unit of the object).  This command should
be invoked by the associated widget whenever its object or window
changes size and whenever it changes the view in its window.

.SH BINDINGS
.PP
The description below assumes a vertically-oriented scrollbar.
For a horizontally-oriented scrollbar replace the words ``up'', ``down'',
``top'', and ``bottom'' with ``left'', ``right'', ``left'',
and ``right'', respectively
.PP
A scrollbar widget is divided into five distinct areas.  From top
to bottom, they are:  the top arrow, the top gap (the empty space
between the arrow and the slider), the slider, the bottom gap,
and the bottom arrow.  Pressing mouse button 1 in each area has
a different effect:
.TP 20
\fBtop arrow\fR
Causes the view in the associated window to shift up by one unit
(i.e. the object appears to move down one unit in its window).
If the button is held down the action will auto-repeat.
.TP 20
\fBtop gap\fR
Causes the view in the associated window to shift up by one
less than the number of units in the window
(i.e. the portion of the object that used to appear at the very
top of the window will now appear at the very bottom).
If the button is held down the action will auto-repeat.
.TP 20
\fBslider\fR
Pressing button 1 in this area has no immediate effect except to
cause the slider to appear sunken rather than raised.  However,
if the mouse is moved with the button down then the slider will
be dragged, adjusting the view as the mouse is moved.
.TP 20
\fBbottom gap\fR
Causes the view in the associated window to shift down by one
less than the number of units in the window
(i.e. the portion of the object that used to appear at the very
bottom of the window will now appear at the very top).
If the button is held down the action will auto-repeat.
.TP 20
\fBbottom arrow\fR
Causes the view in the associated window to shift down by one unit
(i.e. the object appears to move up one unit in its window).
If the button is held down the action will auto-repeat.
.PP
Note:  none of the actions described above has an immediate impact
on the position of the slider in the scrollbar.  It simply invokes
the command specified in the \fBcommand\fR option to notify the
associated widget that a change in view is desired.  If the view is
actually changed then the associated widget must invoke the
scrollbar's \fBset\fR widget command to change what is displayed in
the scrollbar.

.SH KEYWORDS
scrollbar, widget
