'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) Tcl.n 1.119 94/12/17 16:17:33
'
.so man.macros
.de UL
\\$1\l'|0\(ul'\\$2
..
.HS Tcl tcl
.BS
.SH NAME
Tcl \- Summary of Tcl language syntax.
.BE

.SH DESCRIPTION
.LP
The following rules define the syntax and semantics of the Tcl language:
.IP [1]
A Tcl script is a string containing one or more commands.
Semi-colons and newlines are command separators unless quoted as
described below.
Close brackets are command terminators during command substitution
(see below) unless quoted.
.IP [2]
A command is evaluated in two steps.
First, the Tcl interpreter breaks the command into \fIwords\fR
and performs substitutions as described below.
These substitutions are performed in the same way for all
commands.
The first word is used to locate a command procedure to
carry out the command, then all of the words of the command are
passed to the command procedure.
The command procedure is free to interpret each of its words
in any way it likes, such as an integer, variable name, list,
or Tcl script.
Different commands interpret their words differently.
.IP [3]
Words of a command are separated by white space (except for
newlines, which are command separators).
.IP [4]
If the first character of a word is double-quote (``"'') then
the word is terminated by the next double-quote character.
If semi-colons, close brackets, or white space characters
(including newlines) appear between the quotes then they are treated
as ordinary characters and included in the word.
Command substitution, variable substitution, and backslash substitution
are performed on the characters between the quotes as described below.
The double-quotes are not retained as part of the word.
.IP [5]
If the first character of a word is an open brace (``{'') then
the word is terminated by the matching close brace (``}'').
Braces nest within the word: for each additional open
brace there must be an additional close brace (however,
if an open brace or close brace within the word is
quoted with a backslash then it is not counted in locating the
matching close brace).
No substitutions are performed on the characters between the
braces except for backslash-newline substitutions described
below, nor do semi-colons, newlines, close brackets,
or white space receive any special interpretation.
The word will consist of exactly the characters between the
outer braces, not including the braces themselves.
.IP [6]
If a word contains an open bracket (``['') then Tcl performs
\fIcommand substitution\fR.
To do this it invokes the Tcl interpreter recursively to process
the characters following the open bracket as a Tcl script.
The script may contain any number of commands and must be terminated
by a close bracket (``]'').
The result of the script (i.e. the result of its last command) is
substituted into the word in place of the brackets and all of the
characters between them.
There may be any number of command substitutions in a single word.
Command substitution is not performed on words enclosed in braces.
.IP [7]
If a word contains a dollar-sign (``$'') then Tcl performs \fIvariable
substitution\fR:  the dollar-sign and the following characters are
replaced in the word by the value of a variable.
Variable substition may take any of the following forms:
.RS
.TP 15
\fB$\fIname\fR
\fIName\fR is the name of a scalar variable;  the name is terminated
by any character that isn't a letter, digit, or underscore.
.TP 15
\fB$\fIname\fB(\fIindex\fB)\fR
\fIName\fR gives the name of an array variable and \fIindex\fR gives
the name of an element within that array.
\fIName\fR must contain only letters, digits, and underscores.
Command substitutions, variable substitutions, and backslash
substitutions are performed on the characters of \fIindex\fR.
.TP 15
\fB${\fIname\fB}\fR
\fIName\fR is the name of a scalar variable.  It may contain any
characters whatsoever except for close braces.
.RE
.LP
There may be any number of variable substitutions in a single word.
Variable substitution is not performed on words enclosed in braces.
.IP [8]
If a backslash (``\e'') appears within a word then
\fIbackslash substitution\fR occurs.
.VS
In all cases but those described below the backslash is dropped and
the following character is treated as an ordinary
character and included in the word.
.VE
This allows characters such as double quotes, close brackets,
and dollar signs to be included in words without triggering
special processing.
The following table lists the backslash sequences that are
handled specially, along with the value that replaces each sequence.
.RS
.VS
.TP 6
\e\fBa\fR
Audible alert (bell) (0x7).
.VE
.TP 6
\e\fBb\fR
Backspace (0x8).
.TP 6
\e\fBf\fR
Form feed (0xc).
.TP 6
\e\fBn\fR
Newline (0xa).
.TP 6
\e\fBr\fR
Carriage-return (0xd).
.TP 6
\e\fBt\fR
Tab (0x9).
.TP 6
\e\fBv\fR
Vertical tab (0xb).
.TP 6
\e\fB<newline>\fIwhiteSpace\fR\fR
.VS
A single space character replaces the backslash, newline, and all
white space after the newline.
This backslash sequence is unique in that it is replaced in a separate
pre-pass before the command is actually parsed.
This means that it will be replaced even when it occurs between
braces, and the resulting space will be treated as a word separator
if it isn't in braces or quotes.
.VE
.TP 6
\e\e
Backslash (``\e'').
.TP 6
\e\fIooo\fR
The digits \fIooo\fR (one, two, or three of them) give the octal value of
the character.
.TP 6
\e\fBx\fIhh\fR
.VS
The hexadecimal digits \fIhh\fR give the hexadecimal value of
the character.  Any number of digits may be present.
.VE
.RE
.LP
Backslash substitution is not performed on words enclosed in braces,
except for backslash-newline as described above.
.IP [9]
If a hash character (``#'') appears at a point where Tcl is
expecting the first character of the first word of a command,
then the hash character and the characters that follow it, up
through the next newline, are treated as a comment and ignored.
The comment character only has significance when it appears
at the beginning of a command.
.IP [10]
Each character is processed exactly once by the Tcl interpreter
as part of creating the words of a command.
For example, if variable substition occurs then no further
substitions are performed on the value of the variable;  the
value is inserted into the word verbatim.
If command substitution occurs then the nested command is
processed entirely by the recursive call to the Tcl interpreter;
no substitutions are perfomed before making the recursive
call and no additional substitutions are performed on the result
of the nested script.
.IP [11]
Substitutions do not affect the word boundaries of a command.
For example, during variable substitution the entire value of
the variable becomes part of a single word, even if the variable's
value contains spaces.
