#ifndef _WINTYPES_H
#define _WINTYPES_H
#define WINAPI __attribute__ ((stdcall))


#define INFINITE            0xFFFFFFFF  


#define GENERIC_READ                     0x80000000
#define GENERIC_WRITE                    0x40000000
#define GENERIC_EXECUTE                  0x20000000
#define GENERIC_ALL                      0x10000000

#define FILE_TYPE_UNKNOWN   0x0000
#define FILE_TYPE_DISK      0x0001
#define FILE_TYPE_CHAR      0x0002
#define FILE_TYPE_PIPE      0x0003

#define FILE_ATTRIBUTE_DIRECTORY        0x00000010  
#define FILE_ATTRIBUTE_NORMAL           0x00000080  
#define FILE_SHARE_READ                 0x00000001 
#define FILE_SHARE_WRITE                0x00000002  
#define CREATE_NEW          1
#define CREATE_ALWAYS       2
#define OPEN_EXISTING       3
#define OPEN_ALWAYS         4
#define TRUNCATE_EXISTING   5

#define NORMAL_PRIORITY_CLASS       0x00000020
#define IDLE_PRIORITY_CLASS         0x00000040
#define HIGH_PRIORITY_CLASS         0x00000080
#define REALTIME_PRIORITY_CLASS     0x00000100

#define ERROR_FILE_NOT_FOUND             2
#define ERROR_ACCESS_DENIED              5
#define ERROR_INVALID_NAME               123
#define ERROR_PATH_NOT_FOUND             3

#define OF_READ             0x00000000
#define OF_WRITE            0x00000001
#define OF_READWRITE        0x00000002
#define OF_SHARE_COMPAT     0x00000000
#define OF_SHARE_EXCLUSIVE  0x00000010
#define OF_SHARE_DENY_WRITE 0x00000020
#define OF_SHARE_DENY_READ  0x00000030
#define OF_SHARE_DENY_NONE  0x00000040
#define OF_PARSE            0x00000100
#define OF_DELETE           0x00000200
#define OF_VERIFY           0x00000400
#define OF_CANCEL           0x00000800
#define OF_CREATE           0x00001000
#define OF_PROMPT           0x00002000
#define OF_EXIST            0x00004000
#define OF_REOPEN           0x00008000
typedef long HINSTANCE;
typedef long LONG;
typedef int HANDLE;
typedef int DWORD;
typedef char *LPSTR;
typedef char *LPBYTE;
typedef short WORD;
typedef short SHORT;
typedef int BOOL;
typedef int WCHAR;
typedef unsigned int UINT;
#define CONST const
typedef char CHAR;
#define VOID void

#define LMEM_FIXED          0x0000
#define LMEM_MOVEABLE       0x0002
#define LMEM_NOCOMPACT      0x0010
#define LMEM_NODISCARD      0x0020
#define LMEM_ZEROINIT       0x0040
#define GMEM_FIXED          0x0000

#define ERROR_FILE_NOT_FOUND             2
#define ERROR_INVALID_NAME               123
#define ERROR_INVALID_HANDLE 		6
#define ERROR_ACCESS_DENIED              5


#define STD_INPUT_HANDLE    -10
#define STD_OUTPUT_HANDLE   -11
#define STD_ERROR_HANDLE    -12

typedef struct  
{
  HANDLE hProcess;
  HANDLE hThread;
  DWORD dwProcessId;
  DWORD dwThreadId;
} PROCESS_INFORMATION;


typedef struct 
{
  DWORD   cb;
  LPSTR   lpReserved;
  LPSTR   lpDesktop;
  LPSTR   lpTitle;
  DWORD   dwX;
  DWORD   dwY;
  DWORD   dwXSize;
  DWORD   dwYSize;
  DWORD   dwXCountChars;
  DWORD   dwYCountChars;
  DWORD   dwFillAttribute;
  DWORD   dwFlags;
  WORD    wShowWindow;
  WORD    cbReserved2;
  LPBYTE  lpReserved2;
  HANDLE  hStdInput;
  HANDLE  hStdOutput;
  HANDLE  hStdError;
} STARTUPINFO;


typedef struct
{
  SHORT X;
  SHORT Y;
} COORD;

typedef struct 
{
  SHORT Left;
  SHORT Top;
  SHORT Right;
  SHORT Bottom;
} SMALL_RECT;




typedef struct 
{
  int dwLowDateTime;
  int dwHighDateTime;
} FILETIME;

typedef struct {
    WORD wYear;
    WORD wMonth;
    WORD wDayOfWeek;
    WORD wDay;
    WORD wHour;
    WORD wMinute;
    WORD wSecond;
    WORD wMilliseconds;
} SYSTEMTIME;

typedef struct 
{
  int dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  int dwVolumeSerialNumber;
  int nFileSizeHigh;
  int nFileSizeLow;
  int nNumberOfLinks;
  int nFileIndexHigh;
  int nFileIndexLow;
} BY_HANDLE_FILE_INFORMATION ;


DWORD WINAPI GetFileType(DWORD);
DWORD WINAPI GetFileAttributesA (const char *);
DWORD WINAPI CreateDirectoryA (const char*, void *);
DWORD WINAPI RemoveDirectoryA (const char *);
DWORD WINAPI GetCurrentProcess(void);
DWORD WINAPI GetProcessTimes(DWORD, FILETIME *,FILETIME *,FILETIME *,FILETIME *);
			   
DWORD WINAPI DeleteFileA (const char *);
DWORD WINAPI GetLastError (void);
char * WINAPI GetEnvironmentStrings (void);
DWORD WINAPI CloseHandle (DWORD);
DWORD WINAPI SetFilePointer (DWORD,DWORD,DWORD,DWORD);
DWORD WINAPI SystemTimeToFileTime (SYSTEMTIME *,  FILETIME *);

char *WINAPI GetCurrentDirectoryA (DWORD , char *);
void WINAPI GetSystemTime (SYSTEMTIME *);
void WINAPI ExitProcess (DWORD); 

DWORD WINAPI _lwrite(DWORD,const char *, DWORD);
DWORD WINAPI _lread(DWORD, char *, DWORD);
DWORD WINAPI _lopen(const char *,DWORD);

DWORD WINAPI  CreateFileA(const char *, DWORD, DWORD, void *,
			   DWORD, DWORD, DWORD);

DWORD WINAPI GetFileInformationByHandle(DWORD, BY_HANDLE_FILE_INFORMATION *);


void *WINAPI LocalAlloc (DWORD flags, DWORD size);
void *WINAPI GlobalAlloc (DWORD flags, DWORD size);
void *WINAPI LocalReAlloc (void *, DWORD size, DWORD flags);
void *WINAPI LocalFree(void *);
DWORD WINAPI _lopen (const char *, DWORD);
DWORD WINAPI GetExitCodeProcess (HANDLE, DWORD *);
DWORD WINAPI GetLastError (void);
DWORD WINAPI CopyFileA (const char *, const char *, DWORD);
DWORD WINAPI WaitForSingleObject(HANDLE, DWORD );
void *WINAPI GetProcessHeap (void);
DWORD WINAPI CreateProcessA 
     (const char *name,
      char *commandline, 
      void * processatts,
      void * threadatts,
      DWORD inherit,
      DWORD creation,
      void * environ,
      char *currentdir,
      STARTUPINFO *startup,
      PROCESS_INFORMATION *processinfo);
      

char * WINAPI GetCommandLineA (void);
DWORD WINAPI GetStdHandle (DWORD);
char *WINAPI GetEnvironmentStrings (void);
void WINAPI ExitProcess (DWORD);

BOOL WINAPI SetCurrentDirectoryA (const char *);

char *WINAPI RtlUnwind(void *,void *,void *,void *);

typedef int HWND;
typedef unsigned char BYTE;
#ifndef NULL
#define NULL 0
#endif

typedef struct  
    {
    LONG x;
    LONG y;
    }   POINT;

typedef struct 
{
  LONG Left;
  LONG Top;
  LONG Right;
  LONG Bottom;
} RECT;


typedef void *WNDPROC;
typedef int HICON;
typedef int HCURSOR;
typedef int HBRUSH;
typedef const char *LPCSTR;
#define PASCAL WINAPI
#define _export
#endif

