
/* crt0.c for WIN32.

   Written by Steve Chamberlain of Cygnus Support.
   sac@cygnus.com

   This file is part of SH sim


		THIS SOFTWARE IS NOT COPYRIGHTED

   Cygnus offers the following for use in the public domain.  Cygnus
   makes no warranty with regard to the software or it's performance
   and the user accepts the software "AS IS" with all faults.

   CYGNUS DISCLAIMS ANY WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO
   THIS SOFTWARE INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdlib.h>
#define alloca(x) __builtin_alloca(x)
#include "sys/wintypes.h"
#include "sys/wincon.h"
#include "sys/winbase.h"
#define VER 0

#include <_ansi.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "syscalls.h"



#undef environ


char **environ = 0;

int __ptrace;
int __hmap[MAX_HANDLES];	/* map of unix style file handles to
				   win32 ones */
/*

   turn the command line into an argc/argv list.

   The state table is probably a bit of overkill,
   but I suspect that I should do something with
   quote characters, and this will help.

 */

typedef struct st
  {
    int action;
    int nextrow;
  }
state;

#define INC 0
#define QUIT 1
#define FILL 2
#define POINT 3

state table[2][3] =
{
  /* white    end        alpha */
  {
    {INC, 0},
    {QUIT, 0},
    {POINT, 1}} /* Row 0 */ ,
  {
    {FILL, 0},
    {FILL, 0},
    {INC, 1}}			/* Row 1 */
};


static int
passover (char *line, int len, char **argv)
{
  int count = 0;
  int i;
  char *p;
  char *e;
  int row, col;

  e = line + len;
  p = line;
  row = 0;
  while (1)
    {
      if (p >= e)
	col = 1;
      else if (*p == ' ' || *p == '\t' || *p == 0)
	col = 0;
      else
	col = 2;

      switch (table[row][col].action)
	{
	case INC:
	  p++;
	  break;
	case QUIT:
	  goto quit;
	case FILL:
	  *p++ = 0;
	  break;
	case POINT:
	  if (argv)
	    argv[count] = p;
	  count++;
	  p++;
	  break;
	}
      row = table[row][col].nextrow;
    }
 quit:
  if (argv)
    {
      argv[count] = 0;
    }
  return count;
}



static 
long func(struct _EXCEPTION_POINTERS *p)
{

  D("outch!\n");
  ExitProcess(33);
}

void
mainCRTStartup ()
{
  char *line = GetCommandLineA ();
  int len = strlen (line);
  char *mine = alloca (len + 1);
  char *rawenv = GetEnvironmentStrings ();
  int envc;
  int envlim;
  char **argv;
  int i;
  int argc = 0;
  int inwhite = 1;

  __hmap[0] = GetStdHandle (STD_INPUT_HANDLE);
  __hmap[1] = GetStdHandle (STD_OUTPUT_HANDLE);
  __hmap[2] = GetStdHandle (STD_ERROR_HANDLE);


  memcpy (mine, line, len + 1);

  /* Count the words */
  argc = passover (mine, len, 0);
  /* make space for the pointers */
  argv = alloca ((argc + 2) * sizeof (char *));
  /* fill in the pointers */
  argc = passover (mine, len, argv);
  /* size up the environment and count the words */
  {
    int i = 0;
    int j;
    envc = 0;
    while (1)
      {
	if (rawenv[i] == 0)
	  {
	    envc++;
	    if (rawenv[i + 1] == 0)
	      break;
	  }
	i++;
      }


    envc++;
    envlim = envc;
    environ = alloca ((envc + 50) * sizeof (char *));
    envc = 0;

    j = 0;
    environ[envc++] = rawenv;
    i = 0;
    while (envc < envlim)
      {
	if (rawenv[i] == 0)
	  {
	    environ[envc] = rawenv + i + 1;
	    envc++;
	    if (rawenv[i + 1] == 0)
	      break;

	  }
	i++;
      }
    environ[envc++] = 0;
  }

  for (i = 0; i < envc -1 ; i++)
    {
      if  (strncasecmp (environ[i],  "ptrace=", 7) == 0) 
	{                       
	  __ptrace = environ[i][7] - '0';
	  D("PTRACE ON");
	}
    }



  exit (__init_exceptions(argc, argv));
}


