/*
 * mc68681-duart.c -- Low level support code for the Motorola mc68681
 *                   DUART.
 *		     Written by rob@cygnus.com (Rob Savoye)
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <_ansi.h>
#include <errno.h>
#include "mc68681-duart.h"
#include "leds.h"		/* mostly for debugging */
extern void delay();
extern void led_putnum();

unsigned char *duart_base = (unsigned char *)DUART_ADDR;
static struct duart_regs duart_info;

#define READREG(x)	(*(duart_base + x))
/*** #define READREG(x)	(*(duart_base + x) & 0x7f) ***/
#define WRITEREG(x, y)	(*(duart_base + x) = y & 0x7f)

/*
 * duart_status -- get the status of a channel
 */
unsigned char
_DEFUN (duart_status, (channel),
	int channel)
{
  if (channel == 0)
    return (READREG(DUART_SRA));

  if (channel == 1)
    return (READREG(DUART_SRB));
}

/*
 * duart_mode -- get the mode settings of a channel
 */
unsigned char
_DEFUN (duart_mode, (channel),
	int channel)
{
  if (channel == 0)
    return (READREG(DUART_MR1A));

  if (channel == 1)

    return (READREG(DUART_MR2A));
}

/*
 * duart_init -- initialize the DUART for polling operation. This
 *               basically assumnes that only channel A will be used.
 */
void
_DEFUN_VOID (duart_init)
{
  /* get current settings */
#ifdef JUNK
  duart_info.mr1a_reg = READREG (DUART_MR1A); 		/* Mode Register A */
  duart_info.mr2a_reg = READREG (DUART_MR2A);	 	/* Mode Register A */
  duart_info.csra_reg = READREG (DUART_CSRA); 		/* Clock-Select Register A */
  duart_info.cra_reg  = READREG (DUART_CRA); 		/* Command Register A */
  duart_info.ivr_reg  = READREG (DUART_IVR);		/* interupt vector */
  duart_info.imr_reg  = READREG (DUART_IMR);		/* interupt mask register */
  duart_info.acr_reg  = READREG (DUART_ACR);		/* auxiliary control register */
  duart_info.ctur_reg = READREG (DUART_CTUR);		/* counter/timer upper reg */
  duart_info.ctlr_reg = READREG (DUART_CTLR);		/* counter/timer lower reg */
  duart_info.opcr_reg = READREG (DUART_OPCR);		/* output port configuration reg */
#endif
  /* initialize channel A */
  WRITEREG (DUART_CRA, 0x30);		/* reset transmit data A */
  WRITEREG (DUART_CRA, 0x20);		/* reset receive data A */
  WRITEREG (DUART_CRA, 0x10);		/* reset MR pointer A */

  /* initialize channel B */
  WRITEREG (DUART_CRB, 0x30);		/* reset transmit data B */
  WRITEREG (DUART_CRB, 0x20);		/* reset receive data B */
  WRITEREG (DUART_CRB, 0x10);		/* reset MR pointer B */

  /* initialize the DUARTs registers */
  WRITEREG (DUART_IVR, 0x0f);		/* interupt vector */
  WRITEREG (DUART_IMR, 0x0);		/* interupt mask register */
  WRITEREG (DUART_ACR, 0x0);		/* auxiliary control register */
  WRITEREG (DUART_CTUR, 0x0);		/* counter/timer upper reg */
  WRITEREG (DUART_CTLR, 0x2);		/* counter/timer lower reg */
  WRITEREG (DUART_OPCR, 0x0);		/* output port configuration reg */

  /* initilalize channel A */
#ifdef JUNK
  WRITEREG (DUART_CSRA, 0xbb);		/* set A to 9600 baud */
  WRITEREG (DUART_MR1A, 0x13);		/* 8 bits, no parity,  */
  WRITEREG (DUART_MR2A, 0x07);		/* set stop bit length to 1 */
  WRITEREG (DUART_CRA,  0x05);		/* enable transmit and receive */
#endif
}

/*
 * duart_restore -- restore the DUART to where it was when we started
 */
void
_DEFUN_VOID (duart_restore)
{
  /* get current settings */
  WRITEREG (DUART_MR1A, duart_info.mr1a_reg); 		/* Mode Register A */
  WRITEREG (DUART_MR2A, duart_info.mr2a_reg);	 	/* Mode Register A */
  WRITEREG (DUART_CSRA, duart_info.csra_reg); 		/* Clock-Select Register A */
  WRITEREG (DUART_CRA, duart_info.cra_reg); 		/* Command Register A */
  WRITEREG (DUART_IVR, duart_info.ivr_reg);		/* interupt vector */
  WRITEREG (DUART_IMR, duart_info.imr_reg);		/* interupt mask register */
  WRITEREG (DUART_ACR, duart_info.acr_reg);		/* auxiliary control register */
  WRITEREG (DUART_CTUR, duart_info.ctur_reg);		/* counter/timer upper reg */
  WRITEREG (DUART_CTLR, duart_info.ctlr_reg);		/* counter/timer lower reg */
  WRITEREG (DUART_OPCR, duart_info.opcr_reg);		/* output port configuration reg */
}

#define DELAY 5000
/*
 * inbyte -- get a byte from the DUART buffer. This only reads
 *           from channel A
 */
char
_DEFUN_VOID (inbyte)
{
  while ((READREG (DUART_SRA) & 0x01) == 0x00)/* hang till ready */
    {
      delay (DELAY);
    };

  return (READREG (DUART_RBA));		/* read the byte */
}

/*
 * outbyte -- send a byte to the DUART buffer. This only sends
 *           to channel A.
 */
void
_DEFUN (outbyte, (byte),
	char byte)
{
  delay (DELAY);

  while ((READREG (DUART_SRA) & 0x04) == 0x00)
    {
      delay (DELAY);
    };	/* hang till ready */

  WRITEREG (DUART_TBA, byte);		/* write the byte */
}
